#ifndef GGAFDXCORE_GGAFDXCAMERAACTOR_H_
#define GGAFDXCORE_GGAFDXCAMERAACTOR_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"

namespace GgafDxCore {

/**
 * JAN^[.
 * GgafDxGeometricActor pAJ\AN^[łB<BR>
 * {NX͐_(GgafDxGod)ƘAĂ܂Bo𑀍삷ƁA̒ʂɃJ̈ʒuƒ_ł܂B<BR>
 * processPreDraw \bhĂA̒Ő_(GgafDxGod)̃JɍW㏑܂B<BR>
 * <BR>
 * _x,_y,_z             EEE J̈ʒu <BR>
 * <BR>
 * g<BR>
 * pAprocessBehavior()  I[o[ChčDɍW𓮂悢<BR>
 * <BR>
 * @version 1.00
 * @since 2009/02/12
 * @author Masatoshi Tsuge
 */
class GgafDxCamera : public GgafDxGeometricActor {
    friend GgafDxGod;
    friend GgafDxUtil;
    friend GgafDxGeometricActor;
    friend GgafDxSeTransmitterForActor;

public:
    D3DVIEWPORT9 _viewport;

    // 6̖ʂ̒_W
    /** [r]ʁAO̎lp`̒_(ǂݍݐpAt[XV) */
    D3DXVECTOR3 _vecNear[4];
    /** [r]ʁA̎lp`̒_(ǂݍݐpAt[XV) */
    D3DXVECTOR3 _vecFar[4];

    D3DXVECTOR3 _vecVerticalCenter[4];

    // 6̖
    /** [r]ʁA(ǂݍݐpAt[XV) */
    D3DXPLANE _plnTop;
    /** [r]ʁA(ǂݍݐpAt[XV) */
    D3DXPLANE _plnBottom;
    /** [r]ʁA(ǂݍݐpAt[XV) */
    D3DXPLANE _plnLeft;
    /** [r]ʁAE(ǂݍݐpAt[XV) */
    D3DXPLANE _plnRight;
    /** [r]ʁAO(ǂݍݐpAt[XV) */
    D3DXPLANE _plnInfront;
    /** [r]ʁA(ǂݍݐpAt[XV) */
    D3DXPLANE _plnBack;
    /** [r]Eɕ鐂ʁAĚʉ̃pɎgp(ǂݍݐpAt[XV) */
    D3DXPLANE _plnVerticalCenter;

    /** [r]DirectXˉeϊs */
    D3DXMATRIX _matProj;
    /** [r]DirectXˉeϊs */
    D3DXMATRIX _vMatrixOrthoProj;

    /** [r]DirectXJ̈ʒu(t[XV) */
    D3DXVECTOR3* _pVecCamFromPoint;
    /** [r]DirectXJ̒_(t[XV) */
    D3DXVECTOR3* _pVecCamLookatPoint;
    /** [r]DirectXJ̏xNg(t[XV) */
    D3DXVECTOR3* _pVecCamUp;
    /** [r]DirectXVIEWϊs(t[XV) */
    D3DXMATRIX _matView;

    /** [r]pXWA */
    const double _rad_fovX;
    /** [r][i_cameraZ_org̉{)  */
    const double _dep;
    /** [r]pXWA̔ */
    const double _rad_half_fovX;
    /** [r]AXyNg */
    const double _screen_aspect;
    /** [r]pYWA */
    const double _rad_fovY;
    /** [r]pYWA̔ */
    const double _rad_half_fovY;
    /** [r]pX^WFg̔ */
    const double _tan_half_fovX;
    /** [r]pY^WFg̔ */
    const double _tan_half_fovY;
    /** [r]JZWʒu */
    const dxcoord _cameraZ_org;
    /** [r]J߂̃Nbvʂ܂ł̋(ǂ̋\Ώۂj0 */
    const dxcoord _zn;
    /** [r]J牓̃Nbvʂ܂ł̋(ǂ܂ł̋\Ώۂj> zn */
    const dxcoord _zf;
    const coord _x_buffer_left;
    const coord _x_buffer_right;
    const coord _y_buffer_top;
    const coord _y_buffer_bottom;

    /** [r/w]_iW _pVecCamLookatPoint ƘAj **/
    GgafDxCameraViewPoint* _pCameraViewPoint;
    GgafDxCameraUpVector* _pCameraUpVector;

    coord _x_prev, _y_prev, _z_prev;

public:
    /**
     * RXgN^ .
     * pƕ\[ݒ肷B
     * pɂāAJ̏Zʒu肷B
     * ̃J̏ZʒúA_t߂DirectX̒1ĩIuWFNgj
     * ʏ10sNZŕ\ʒuփJ悤ɎvZBi_cameraZ_orgɕێ)
     * ̌_ÃJZʒu܂ł1.0ƂāA\͈͂̐[̔{ prm_dep Őݒ肷B
     * prm_dep=1.0ƂꍇB\͈͂ _𒆐SƂAaJZʒű̋ƂȂB
     * ܂A\͈́{AAN^[B̃Q[ł̉͈͂ƂȂ悤ɐ݌vĂ邽߁AJ̏ݒl
     * ɏdvłB
     * ʏ펋p߂΃Y[Abv̌ʂ邪A{Cuł́A
     * L̏Zʒu܂ŃJň߁ApύXĂAN^[̕\̑傫͉ʏςȂB
     * p΁ÃJLт邱ƂɂȂAʂƂ
     * E̕\͈͂g傷ʂ邱ƂłB
     * tɎpL΁AJ̏Zʒu͌_ɋ߂ȂA͐E̕\͈͂͋ȂB
     *
     * @param prm_name O(fobNŕ\Bł悢)
     * @param prm_rad_fovX E̎piWAj
     * @param prm_dep [i_cameraZ_org̉{)
     * @return
     */
    GgafDxCamera(const char* prm_name, double prm_rad_fovX, double prm_dep);

    virtual void initialize() override;

    /**
     * ʏXVB
     */
    virtual void processBehavior() override;


    virtual void processSettlementBehavior() override {
        _fX = C_DX(_x);
        _fY = C_DX(_y);
        _fZ = C_DX(_z);
    }

    /**
     * DirectX̃J֔f .
     * g̍W _pVecCamFromPoint փRs[
     * _pCameraViewPoint ̍W _pVecCamLookatPoint փRs[B
     * _pCameraUpVector ̈ʒuxNg _pVecCamUp wRs[B
     * _pVecCamFromPoint, _pVecCamLookatPoint, _pVecCamUp 
     * D3DXMatrixLookAtLH() sB
     */
    virtual void processJudgement() override;


    virtual void setDefaultPosition();

    /**
     * _pAN^[擾 .
     * ς݂̎_pAN^[擾܂B
     * AA߂ČĂяoꍇAcreateCameraViewPoint() Ăяo
     * CX^X쐬܂B
     * @return ςݎ_pAN^[
     */
    virtual GgafDxCameraViewPoint* getCameraViewPoint();

    /**
     * _pAN^[̃CX^X𐶐 .
     * Ǝ̃CX^X𐶐ꍇ́AI[o[ChĂB
     * @return ꂽ_pAN^[
     */
    virtual GgafDxCameraViewPoint* createCameraViewPoint() = 0;

    virtual GgafDxCameraUpVector* getCameraUpVector();

    virtual GgafDxCameraUpVector* createCameraUpVector() = 0;

    bool isMoving();

    inline dxcoord getZFar() const {
        return _zf;
    }

    inline dxcoord getZNear() const {
        return _zn;
    }

    inline D3DXMATRIX* getProjectionMatrix()  {
        return &_matProj;
    }

    inline D3DXMATRIX* getViewMatrix() {
        return &_matView;
    }

    inline D3DXVECTOR3* getVecCamFromPoint() const {
        return _pVecCamFromPoint;
    }

    inline D3DXVECTOR3* getVecCamLookatPoint() const {
        return _pVecCamLookatPoint;
    }

    inline dxcoord getZOrigin() const {
        return _cameraZ_org;
    }

    void setCamUpVecByFaceNo(dir26 prm_face_no);


    virtual ~GgafDxCamera(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXCAMERAACTOR_H_*/
