#ifndef GGAFDXCORE_GGAFDXAXESMOVER_H_
#define GGAFDXCORE_GGAFDXAXESMOVER_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"

namespace GgafDxCore {

/**
 * sړx .
 * GgafDxGeometricActor ̃o<BR>
 *  _x, _y, _z  EEE AN^[̍W<BR>
 * AeɊȒPɑ삷邽߂ɍ쐬B<BR>
 * @version 1.00
 * @since 2008/08/20
 * @author Masatoshi Tsuge
 */
class GgafDxAxesMover : public GgafCore::GgafObject {

public:
    /** [r]ΏۃAN^[ */
    GgafDxGeometricActor* const _pActor;
    /** [r/w]Xړx */
    velo _velo_vx_mv;
    /** [r/w]Xړx */
    velo _top_velo_vx_mv;
    /** [r/w]Xړx */
    velo _bottom_velo_vx_mv;
    /** [r/w]Xړx */
    acce _acce_vx_mv;
    /** [r/w]Xړx*/
    acce _top_acce_vx_mv;
    /** [r/w]Xړx*/
    acce _bottom_acce_vx_mv;
    /** [r/w]Yړx */
    velo _velo_vy_mv;
    /** [r/w]Yړx */
    velo _top_velo_vy_mv;
    /** [r/w]Yړx */
    velo _bottom_velo_vy_mv;
    /** [r/w]Yړx */
    acce _acce_vy_mv;
    /** [r/w]Yړx*/
    acce _top_acce_vy_mv;
    /** [r/w]Yړx*/
    acce _bottom_acce_vy_mv;
    /** [r/w]Zړx */
    velo _velo_vz_mv;
    /** [r/w]Zړx */
    velo _top_velo_vz_mv;
    /** [r/w]Zړx */
    velo _bottom_velo_vz_mv;
    /** [r/w]Zړx */
    acce _acce_vz_mv;
    /** [r/w]Zړx*/
    acce _top_acce_vz_mv;
    /** [r/w]Zړx*/
    acce _bottom_acce_vz_mv;

    coord _grv_mv_target_x;
    coord _grv_mv_target_y;
    coord _grv_mv_target_z;
    const GgafDxGeometricActor* _grv_mv_pActor_target;
    velo _grv_mv_max_velo;
    acce _grv_mv_acce;
    coord _grv_mv_stop_renge;
    bool _grv_mv_flg;
    /** [r]B̏A */
    GgafDxAxesMoverAssistantA* _pAsstMv;

public:
    /**
     * RXgN^<BR>
     * @param   prm_pActor  KpActor
     */
    explicit GgafDxAxesMover(GgafDxGeometricActor* prm_pActor);

    /**
     * B̏(炩ړS)擾 .
     * @return B̏
     */
    GgafDxAxesMoverAssistantA* asst();

    int dot(int prm_vX, int prm_vY, int prm_vZ);
    /**
     * Xړxݒ .
     * @param prm_velo_vx_mv Xړx
     */
    void setVxMvVelo(velo prm_velo_vx_mv);

    /**
     * XړxZ .
     * @param prm_velo_vx_mv Xړx
     */
    void addVxMvVelo(velo prm_velo_vx_mv);

    /**
     * Xړx̏ .
     * @param prm_velo_vx_mv01 xP
     * @param prm_velo_vx_mv02 xQ
     */
    void forceVxMvVeloRange(velo prm_velo_vx_mv01, velo prm_velo_vx_mv02);

    /**
     * Xړxݒ .
     * @param prm_acce_vx_mv Xړx
     */
    void setVxMvAcce(acce prm_acce_vx_mv);

    /**
     * XړxZ .
     * @param prm_acce_vx_mv Xړx
     */
    void addVxMvAcce(acce prm_acce_vx_mv);

    /**
     * Xړx̏ .
     * @param prm_acce_vx_mv01 xP
     * @param prm_acce_vx_mv02 xQ
     */
    void forceVxMvAcceRange(acce prm_acce_vx_mv01, acce prm_acce_vx_mv02);

    /**
     * Yړxݒ .
     * @param prm_velo_vy_mv Yړx
     */
    void setVyMvVelo(velo prm_velo_vy_mv);

    /**
     * YړxZ .
     * @param prm_velo_vy_mv Yړx
     */
    void addVyMvVelo(velo prm_velo_vy_mv);

    /**
     * Yړx̏ .
     * @param prm_velo_vy_mv01 xP
     * @param prm_velo_vy_mv02 xQ
     */
    void forceVyMvVeloRange(velo prm_velo_vy_mv01, velo prm_velo_vy_mv02);

    /**
     * Yړxݒ .
     * @param prm_acce_vy_mv Yړx
     */
    void setVyMvAcce(acce prm_acce_vy_mv);

    /**
     * YړxZ .
     * @param prm_acce_vy_mv Yړx
     */
    void addVyMvAcce(acce prm_acce_vy_mv);

    /**
     * Yړx̏ .
     * @param prm_acce_vy_mv01 xP
     * @param prm_acce_vy_mv02 xQ
     */
    void forceVyMvAcceRange(acce prm_acce_vy_mv01, acce prm_acce_vy_mv02);

    /**
     * Zړxݒ .
     * @param prm_velo_vz_mv Zړx
     */
    void setVzMvVelo(velo prm_velo_vz_mv);

    /**
     * ZړxZ .
     * @param prm_velo_vz_mv Zړx
     */
    void addVzMvVelo(velo prm_velo_vz_mv);

    /**
     * Zړx̏ .
     * @param prm_velo_vz_mv01 xP
     * @param prm_velo_vz_mv02 xQ
     */
    void forceVzMvVeloRange(velo prm_velo_vz_mv01, velo prm_velo_vz_mv02);

    /**
     * Zړxݒ .
     * @param prm_acce_vz_mv Zړx
     */
    void setVzMvAcce(acce prm_acce_vz_mv);

    /**
     * ZړxZ .
     * @param prm_acce_vz_mv Zړx
     */
    void addVzMvAcce(acce prm_acce_vz_mv);

    /**
     * Zړx̏ .
     * @param prm_acce_vz_mv01 xP
     * @param prm_acce_vz_mv02 xQ
     */
    void forceVzMvAcceRange(acce prm_acce_vz_mv01, acce prm_acce_vz_mv02);

    /**
     * XYZ̈ړx̏ .
     * @param prm_velo_vxyz_mv01 x1
     * @param prm_velo_vxyz_mv02 x2
     */
    void forceVxyzMvVeloRange(velo prm_velo_vxyz_mv01, velo prm_velo_vxyz_mv02);

    /**
     * XYZ̈ړx̏ .
     * @param prm_acce_vxyz_mv01 xP
     * @param prm_acce_vxyz_mv02 xQ
     */
    void forceVxyzMvAcceRange(acce prm_acce_vxyz_mv01, acce prm_acce_vxyz_mv02);

    /**
     * XYZ̈ړxݒ肷B
     * @param prm_velo_vx_mv Xړx
     * @param prm_velo_vy_mv Yړx
     * @param prm_velo_vz_mv Zړx
     */
    void setVxyzMvVelo(velo prm_velo_vx_mv, velo prm_velo_vy_mv, velo prm_velo_vz_mv);

    /**
     * XYZ̈ړxڕWpxƈړxŐݒ肷B
     * @param prm_rz ڕWZ]AOl
     * @param prm_ry ڕWY]AOl
     * @param prm_velo ړx
     */
    void setVxyzMvVeloTwd(angle prm_rz, angle prm_ry, velo prm_velo);

    /**
     * XYZ̈ړxڕWWƈړxŐݒ肷B
     * @param prm_tx ڕWXW
     * @param prm_ty ڕWYW
     * @param prm_tz ڕWZW
     * @param prm_velo ړx
     */
    void setVxyzMvVeloTwd(coord prm_tx, coord prm_ty, coord prm_tz, velo prm_velo);

    /**
     * XYZ̈ړxڕWAN^[ƈړxŐݒ肷B
     * @param prm_pTargetActor ڕWAN^[
     * @param prm_velo ړx
     */
    void setVxyzMvVeloTwd(const GgafDxGeometricActor* prm_pTargetActor, velo prm_velo) {
        setVxyzMvVeloTwd(prm_pTargetActor->_x, prm_pTargetActor->_y, prm_pTargetActor->_z, prm_velo);
    }

    /**
     * XYZ̈ړxݒ肷B
     * @param prm_acce_vx_mv Xړx
     * @param prm_acce_vy_mv Yړx
     * @param prm_acce_vz_mv Zړx
     */
    void setVxyzMvAcce(acce prm_acce_vx_mv, acce prm_acce_vy_mv, acce prm_acce_vz_mv);



    /**
     * ړxAuڕWBxvu₷ԁvɂݒ .
     * <pre><code>
     *
     *    x(v)
     *     ^        a:xi_acc_mv ɐݒ肳)
     *     |        D:ړ i߂lj
     *     |       V0:_̑xi= ݂ _velo_mv gpj
     *     |       Vt:ڕWBxij
     *     |       Te:ڕWBxɒB̎ԁij
     *   Vt|........
     *     |      ^|
     *     |    ^  |
     *     |  ^    |   Εӂ̌Xa
     *     |^      |
     *   V0|    D   |
     *     |        |
     *   --+--------+---> (tt[)
     *   0 |        Te
     *
     *    a = (Vt-V0) / Te
     * </code></pre>
     * }̂悤ȏԂz肵AڕWBx(Vt)ƁA̓B(Te) Ax(a)vZݒ肵ĂB<BR>
     * ړ(D)́Ap[^ɂω邽ߎwsB<BR>
     * @param prm_target_frames ₷(Te)
     * @param prm_target_velo   ڕWBx(Vt)
     * @return ړ(D)
     */
    coord setVxAcceByT(frame prm_target_frames, velo prm_target_velo);
    coord setVyAcceByT(frame prm_target_frames, velo prm_target_velo);
    coord setVzAcceByT(frame prm_target_frames, velo prm_target_velo);
    void setVxyzAcceByT(frame prm_target_frames, velo prm_target_velo) {
        setVxAcceByT(prm_target_frames, prm_target_velo);
        setVyAcceByT(prm_target_frames, prm_target_velo);
        setVzAcceByT(prm_target_frames, prm_target_velo);
    }


    /**
     * XYZ̈ړx 0 ɐݒ肷B
     */
    void setZeroVxyzMvVelo() {
        _velo_vx_mv = _velo_vy_mv = _velo_vz_mv = 0;
    }

    /**
     * XYZ̈ړx 0 ɐݒ肷B
     */
    void setZeroVxyzMvAcce() {
        _acce_vx_mv = _acce_vy_mv = _acce_vz_mv = 0;
    }

    /**
     * d͂ɂ蕨̂񂹂邩悤Ȋ݂̓Ȋۂ̂߂ .
     */
    void stopGravitationMvSequence() {
        _grv_mv_flg = false;
    }

    /**
     * d͂ɂ蕨̂񂹂邩悤Ȋ݂̓Ȋۂ̍Œǂ
     * @return true:Œ/false:łȂ
     */
    bool isGravitationMvSequence() {
        return _grv_mv_flg;
    }

    /**
     * d͂ɂ蕨̂񂹂邩悤Ȋ݂̓Ȋۂ̂s .
     * yASYTvz<BR>
     * X,Y,Z̊e̍WꂼɁAڕW̍WƃAN^[̍WA<BR>
     * ̐ɂAxZZĖڕWɋ߂ÂƂ܂B<BR>
     * AÂ܂܂łƁAq񂷂邪@AiɖڕW̍WɓB܂B<BR>
     * ŁAڕW̍WX,Y,Z̊eƁAAN^[̍W<BR>
     * -1*prm_stop_renge ` prm_stop_renge<BR>
     * ͈͓̔ɂȂꍇAxɘa()AڕW̍WɍXɋ߂Â܂B<BR>
     * eꂼAڕWɋ߂ÂƎx0ɋ߂ÂAƂŏd͂Ƃ͕IɓقȂ܂B<BR>
     * łAd͂ňt邩̂悤Ȍʂҏo܂B<BR>
     * wIɂ́AڕW̍WɌȂ߂ÂŁAڕWWƈv邱Ƃ͂܂B<BR>
     * @param prm_tx 񂹂ēBڕWXW(΍W)
     * @param prm_ty 񂹂ēBڕWYW(΍W)
     * @param prm_tz 񂹂ēBڕWZW(΍W)
     * @param prm_max_velo 񂹂ĂŒ̊e(XYZ)̎ړxl
     * @param prm_acce 񂹂ĂŒ̊e(XYZ)̎ړxl
     * @param prm_stop_renge x}ڕWW̊e̋
     */
    void execGravitationMvSequenceTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                                      velo prm_max_velo,
                                      acce prm_acce,
                                      coord prm_stop_renge);

    /**
     * d͂ɂ蕨̂񂹂邩悤Ȋ݂̓Ȋۂ̖ڕWWXVݒ .
     * @param prm_tx 񂹂ēBڕWXW
     * @param prm_ty 񂹂ēBڕWYW
     * @param prm_tz 񂹂ēBڕWZW
     */
    void setGravitationTwd(coord prm_tx, coord prm_ty, coord prm_tz) {
        _grv_mv_target_x = prm_tx;
        _grv_mv_target_y = prm_ty;
        _grv_mv_target_z = prm_tz;
        _grv_mv_pActor_target = nullptr;
    }

    /**
     * d͂ɂ蕨̂񂹂邩悤Ȋ݂̓Ȋۂ̂s .
     * ́A
     * execGravitationMvSequenceTwd(coord,coord,coord,velo,acce,int)
     * QƁB
     * @param prm_pActor_target 񂹂ēBڕWWƂȂAN^[
     * @param prm_max_velo 񂹂ĂŒ̊e(XYZ)̎ړxl
     * @param prm_acce 񂹂ĂŒ̊e(XYZ)̎ړxl
     * @param prm_stop_renge x}ڕWW̊e̋
     */
    void execGravitationMvSequenceTwd(const GgafDxGeometricActor* prm_pActor_target,
                                      velo prm_max_velo,
                                      acce prm_acce,
                                      coord prm_stop_renge);
    /**
     * d͂ɂ蕨̂񂹂邩悤Ȋ݂̓Ȋۂ̂s .
     * ́A
     * execGravitationMvSequenceTwd(coord,coord,coord,velo,acce,int)
     * QƁB
     * @param prm_pActor_target 񂹂ēBڕWWƂȂAN^[
     * @param prm_local_offset_tx ڕWXWʒu̕␳Bprm_pActor_target̑΍Wݒ肷B
     * @param prm_local_offset_ty ڕWYWʒu̕␳Bprm_pActor_target̑΍Wݒ肷B
     * @param prm_local_offset_tz ڕWZWʒu̕␳Bprm_pActor_target̑΍Wݒ肷B
     * @param prm_max_velo 񂹂ĂŒ̊e(XYZ)̎ړxl
     * @param prm_acce 񂹂ĂŒ̊e(XYZ)̎ړxl
     * @param prm_stop_renge x}ڕWW̊e̋
     */
    void execGravitationMvSequenceTwd(const GgafDxGeometricActor* prm_pActor_target,
                                      coord prm_local_offset_tx, coord prm_local_offset_ty, coord prm_local_offset_tz,
                                      velo prm_max_velo,
                                      acce prm_acce,
                                      coord prm_stop_renge);


    /**
     * d͂ɂ蕨̂񂹂邩悤Ȋ݂̓Ȋۂ̖ڕWWXVݒ .
     * @param prm_pActor_target 񂹂ēBڕWWƂȂAN^[
     */
    void setGravitationTwd(const GgafDxGeometricActor* prm_pActor_target) {
        _grv_mv_target_x = 0;
        _grv_mv_target_y = 0;
        _grv_mv_target_z = 0;
        _grv_mv_pActor_target = prm_pActor_target;
    }

    /**
     * sړx̎dp .
     *  GgafDxAxesMover IuWFNgԂgɈp .
     * @param prm_pAxsMver p
     */
    void takeoverMvFrom(GgafDxAxesMover* const prm_pAxsMver);

    /**
     * GgafDxAxesMoverɂAN^[ړ~B
     */
    void stopMv();

    /**
     * xAxZbgAeݒB
     */
    void resetMv();

    /**
     * sړxU镑 .
     * sړx@\𗘗pꍇ́Ã\bh𖈃t[ĂяosĂB<BR>
     * tɕsړxKvƂȂꍇ́Ã\bhĂяoȂƂŁAptH[}Xɉe^܂B<BR>
     */
    virtual void behave();

    virtual ~GgafDxAxesMover();
};

}
#endif /*GGAFDXCORE_GGAFDXAXESMOVER_H_*/

