#ifndef GGAFDXCORE_GGAFDXMASSBOARDMODEL_H_
#define GGAFDXCORE_GGAFDXMASSBOARDMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/model/GgafDxMassModel.h"

namespace GgafDxCore {

/**
 * GgafDxMassBoardActorpfNX.
 * @version 1.00
 * @since 2016/02/25
 * @author Masatoshi Tsuge
 */
class GgafDxMassBoardModel : public GgafDxMassModel {
    friend class GgafDxModelManager;
    friend class GgafDxMassBoardActor;

public:
    struct VERTEX_model : public GgafDxModel::VERTEX_3D_BASE {
        float tu, tv;     // eNX`W
    };
    VERTEX_model* _paVtxBuffer_data_model;
    WORD* _paIndexBuffer_data;

    float _model_width_px;
    float _model_height_px;
    float _model_half_width_px;
    float _model_half_height_px;
    int _row_texture_split;
    int _col_texture_split;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    GgafDxMassBoardModel(const char* prm_model_name);

    static void createVertexModel(void* prm, GgafDxMassModel::VertexModelInfo* out_info);

    /**
     * f̕`s .
     * @param prm_pActor_target `悷郂f̃AN^
     * @param prm_draw_set_num  `悷CX^X
     * @param prm_pPrm CX^Xf[^̐擪AhX
     * @return
     */
    virtual HRESULT draw(GgafDxFigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    /**
     * fXgN^<BR>
     */
    virtual ~GgafDxMassBoardModel(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXMASSBOARDMODEL_H_*/
