#include "jp/ggaf/dxcore/actor/GgafDxMeshSetActor.h"

#include "jp/ggaf/dxcore/exception/GgafDxCriticalException.h"
#include "jp/ggaf/dxcore/effect/GgafDxMeshSetEffect.h"
#include "jp/ggaf/dxcore/model/GgafDxMeshSetModel.h"
#include "jp/ggaf/dxcore/scene/GgafDxSpacetime.h"
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxMeshSetActor::GgafDxMeshSetActor(const char* prm_name,
                                       const char* prm_model_id,
                                       const char* prm_effect_id,
                                       const char* prm_technique,
                                       GgafStatus* prm_pStat,
                                       GgafDxChecker* prm_pChecker) :

                                           GgafDxFigureActor(prm_name,
                                                             prm_model_id,
                                                             "x",
                                                             prm_effect_id,
                                                             "x",
                                                             prm_technique,
                                                             prm_pStat,
                                                             prm_pChecker),
_pMeshSetModel((GgafDxMeshSetModel*)_pModel),
_pMeshSetEffect((GgafDxMeshSetEffect*)_pEffect)
{
    _obj_class |= Obj_GgafDxMeshSetActor;
    _class_name = "GgafDxMeshSetActor";
    defineRotMvWorldMatrix(UTIL::setWorldMatrix_RxRzRyMv); //ftHg̉]~ړ̕ϊs
}

GgafDxMeshSetActor::GgafDxMeshSetActor(const char* prm_name,
                                       const char* prm_model_id,
                                       const char* prm_model_type,
                                       const char* prm_effect_id,
                                       const char* prm_effect_type,
                                       const char* prm_technique,
                                       GgafStatus* prm_pStat,
                                       GgafDxChecker* prm_pChecker) :

                                           GgafDxFigureActor(prm_name,
                                                             prm_model_id,
                                                             prm_model_type,
                                                             prm_effect_id,
                                                             prm_effect_type,
                                                             prm_technique,
                                                             prm_pStat,
                                                             prm_pChecker),
_pMeshSetModel((GgafDxMeshSetModel*)_pModel),
_pMeshSetEffect((GgafDxMeshSetEffect*)_pEffect) {

    _obj_class |= Obj_GgafDxMeshSetActor;
    _class_name = "GgafDxMeshSetActor";
    defineRotMvWorldMatrix(UTIL::setWorldMatrix_RxRzRyMv); //ftHg̉]~ړ̕ϊs
}

void GgafDxMeshSetActor::processDraw() {
    int draw_set_num = 0; //GgafDxMeshSetActor̓fœeNjbN
                       //AĂJEgB`[x͈xɕ`悷B
    ID3DXEffect* const pID3DXEffect = _pMeshSetEffect->_pID3DXEffect;
    HRESULT hr;
    GgafDxFigureActor* pDrawActor = this;
    GgafDxMeshSetActor* pMeshSetActor = nullptr;
    const int model_set_num = _pMeshSetModel->_set_num;
    while (pDrawActor) {
        if (pDrawActor->getModel() == _pMeshSetModel && pDrawActor->_hash_technique == _hash_technique) {
            pMeshSetActor = (GgafDxMeshSetActor*)pDrawActor;
            hr = pID3DXEffect->SetMatrix(_pMeshSetEffect->_ah_matWorld[draw_set_num], &(pMeshSetActor->_matWorld));
            checkDxException(hr, D3D_OK, "SetMatrix(g_matWorld) Ɏs܂B");
            hr = pID3DXEffect->SetValue(_pMeshSetEffect->_ah_materialDiffuse[draw_set_num], &(pMeshSetActor->_paMaterial[0].Diffuse), sizeof(D3DCOLORVALUE) );
            //yGgafDxMeshSetActor̃}eAJ[ɂčlzY^
            //{̓}eAPIuWFNgɕێA}eAXg̃O[vɐݒ肷̂AsxœKƎgpWX^팸(sNZVF[_[2.0)ׁ̈A
            //eZbg[0]̃}eAŜ̃}eAƂB
            //GgafDxMeshSetActor̓}eAF͂PFs\B
            //ꂼ̂PFA}eAFƂăIuWFNgʂɂ邽ߒ_J[ŎĂB
            //ƂƖ{NX́AꃂfIuWFNgAɈŕ`悵Xs[hAbv}邱ƂړIƂNXŁA}eAO[vIuWFNgɂ͕sƂӖłB
            //PeNX`Ŋ撣ΖȂEEEƂjB}eAFŐFꍇ GgafDxMeshActor gȂB
            checkDxException(hr, D3D_OK, "SetValue(g_colMaterialDiffuse) Ɏs܂B");
            draw_set_num++;
            if (draw_set_num >= model_set_num) {
                break;
            }
            pDrawActor = pDrawActor->_pNextRenderActor;
        } else {
            break;
        }
    }
    GgafDxSpacetime::_pActor_draw_active = pMeshSetActor; //`Zbg̍ŌAN^[Zbg
    ((GgafDxMeshSetModel*)_pMeshSetModel)->GgafDxMeshSetModel::draw(this, draw_set_num);
}

GgafDxMeshSetActor::~GgafDxMeshSetActor() {
}
