#ifndef GGAFLIB_COLLISIONCHECKER_H_
#define GGAFLIB_COLLISIONCHECKER_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxChecker.h"

namespace GgafLib {

/**
 * Փ˃`FbJ[NX.
 * AN^[ɓ蔻`FbN@\ǉNXB
 * P́u蔻̈v́Áu蔻̈vfv`Ă܂B<BR>
 * eu蔻̈vfv́ABOX^Ƌ^̂Qނ̓Iׂ܂B<BR>
 * u蔻̈vu蔻̈vfvƌẗӖʂÂ悤ɂȈӖƒ`B<BR>
 * u蔻̗̈vfvEEEPLN^̓蔻̈B󂩁A邢BOX̕̗̈PwB<BR>
 * u蔻̈v      EEEPȏ̗̔̈vf킳APLN^̓蔻Ŝ\B<BR>
 *
 * @version 1.00
 * @since 2008/09/08
 * @author Masatoshi Tsuge
 */
class CollisionChecker : public GgafDxCore::GgafDxChecker {

public:
    /** 蔻̈̋Ë(AABB)ČvZ邩ǂ̃tO */
    bool _need_update_aabb;
#ifdef MY_DEBUG
    /** Pt[̓蔻vfm̔ */
    static unsigned int _num_check;
#endif
public:
    /**
     * RXgN^<BR>
     * @param   prm_pActor  蔻@\ǉActor
     */
    explicit CollisionChecker(GgafDxCore::GgafDxGeometricActor* prm_pActor);

    /**
     * 蔻̈vfƂĒ` .
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻̋̒S[JXW
     * @param y 蔻̋̒S[JYW
     * @param z 蔻̋̒S[JZW
     * @param r 蔻̋̔a
     * @param rot_x 蔻̋Aɔă[JXł̉]sړsꍇ true
     * @param rot_y 蔻̋Aɔă[JYł̉]sړsꍇ true
     * @param rot_z 蔻̋Aɔă[JZł̉]sړsꍇ true
     */
    void setColliSphere(int prm_index, coord x, coord y, coord z, coord r, bool rot_x, bool rot_y, bool rot_z);

    /**
     * 蔻̈vfƂĒ` .
     * ɔĂ̓蔻̋̉]sړ@\͖
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻̋̒S[JXW
     * @param y 蔻̋̒S[JYW
     * @param z 蔻̋̒S[JZW
     * @param r 蔻̋̔a
     */
    void setColliSphere(int prm_index, coord x, coord y, coord z, coord r) {
        setColliSphere(prm_index, x, y, z, r, false, false, false);
    }

    /**
     * 蔻̈vfƂĒ` .
     * IuWFNg̊_̒SƂB<br>
     * ɔĂ̓蔻̋̉]sړ@\͖B<br>
     * @param prm_index 蔻̗̈vfԍ
     * @param r 蔻̋̔a
     */
    void setColliSphere(int prm_index, coord r) {
        setColliSphere(prm_index, 0, 0, 0, r, false, false, false);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 OXW
     * @param y1 OYW
     * @param z1 OZW
     * @param x2 EXW
     * @param y2 EYW
     * @param z2 EZW
     * @param rot_x 蔻̒̂Aɔă[JXł̉]sړsꍇ true
     * @param rot_y 蔻̒̂Aɔă[JYł̉]sړsꍇ true
     * @param rot_z 蔻̒̂Aɔă[JZł̉]sړsꍇ true
     */
    void setColliAABox(int prm_index,
                       coord x1, coord y1, coord z1,
                       coord x2, coord y2, coord z2,
                       bool rot_x, bool rot_y, bool rot_z);

    /**
     * 蔻̈vfŝƂĒ` .
     * ɔĂ̓蔻̋̉]sړ@\͖
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 OXW
     * @param y1 OYW
     * @param z1 OZW
     * @param x2 EXW
     * @param y2 EYW
     * @param z2 EZW
     */
    void setColliAABox(int prm_index,
                       coord x1, coord y1, coord z1,
                       coord x2, coord y2, coord z2) {
        setColliAABox(prm_index, x1, y1, z1, x2, y2, z2, false, false, false);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * Ž݂́A1px
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 OXW
     * @param y1 OYW
     * @param x2 EXW
     * @param y2 EYW
     */
    void setColliAABox(int prm_index, coord x1, coord y1, coord x2, coord y2) {
        setColliAABox(prm_index, x1, y1, -1 * PX_C(1) / 2, x2, y2, PX_C(1) / 2, false, false, false);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * BOXSWƁAAAsŎw
     * @param prm_index
     * @param x SXW
     * @param y SYW
     * @param z SZW
     * @param prm_width (X)
     * @param prm_height (Y)
     * @param prm_depth [isEYj
     */
    void setColliAABox_WHD(int prm_index, coord x, coord y, coord z, coord prm_width, coord prm_height, coord prm_depth) {
        int hw = prm_width  / 2;
        int hh = prm_height / 2;
        int hd = prm_depth  / 2;

        setColliAABox(prm_index, x-hw, y-hh, z-hd, x+hw, y+hh, z+hd);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * IuWFNg̊_𒆐SƂāAAAsŎw
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_width (X)
     * @param prm_height (Y)
     * @param prm_depth [isEYj
     */
    void setColliAABox_WHD(int prm_index, coord prm_width, coord prm_height, coord prm_depth) {
        setColliAABox_WHD(prm_index, 0, 0, 0, prm_width, prm_height, prm_depth);
    }


    /**
     * 蔻̈vfŝƂĒ` .
     * W𒆐SƂāAPӂ̒Ŏw
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻̗̂̒S[JXW
     * @param y 蔻̗̂̒S[JYW
     * @param z 蔻̗̂̒S[JZW
     * @param prm_edge Pӂ̒
     */
    void setColliAABox_Cube(int prm_index, coord x, coord y, coord z, coord prm_edge) {
        coord h = prm_edge / 2;
        setColliAABox(prm_index, x-h, y-h, z-h, x+h, y+h, z+h);
    }


    /**
     * 蔻̈vfŝƂĒ` .
     * IuWFNg̊_𒆐SƂāAPӂ̒Ŏw
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_edge Pӂ̒
     */
    void setColliAABox_Cube(int prm_index, coord prm_edge) {
        setColliAABox_Cube(prm_index, 0, 0, 0, prm_edge);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * W𒆐SƂāAPӂ̒Ŏw
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻̗̂̒S[JXW
     * @param y 蔻̗̂̒S[JYW
     * @param z 蔻̗̂̒S[JZW
     * @param prm_edge Pӂ̒
     * @param rot_x 蔻̗̂Aɔă[JXł̉]sړsꍇ true
     * @param rot_y 蔻̗̂Aɔă[JYł̉]sړsꍇ true
     * @param rot_z 蔻̗̂Aɔă[JZł̉]sړsꍇ true
     */
    void setColliAABox_Cube(int prm_index, coord x, coord y, coord z, coord prm_edge, bool rot_x, bool rot_y, bool rot_z) {
        int h = prm_edge / 2;
        setColliAABox(prm_index, x-h, y-h, z-h, x+h, y+h, z+h, rot_x, rot_y, rot_z);
    }

    /**
     * 蔻̈vfsvY^ƂĒ` .
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 OXW
     * @param y1 OYW
     * @param z1 OZW
     * @param x2 EXW
     * @param y2 EYW
     * @param z2 EZW
     * @param pos_prism vYʒuiPOS_PRISM_**_**)
     * @param rot_x 蔻̒̂Aɔă[JXł̉]sړsꍇ true
     * @param rot_y 蔻̒̂Aɔă[JYł̉]sړsꍇ true
     * @param rot_z 蔻̒̂Aɔă[JZł̉]sړsꍇ true
     */
    void setColliAAPrism(int prm_index, coord x1, coord y1, coord z1, coord x2, coord y2, coord z2, int pos_prism, bool rot_x, bool rot_y, bool rot_z);

    /**
     * 蔻̈vfŝƂĒ` .
     * ɔĂ̓蔻̋̉]sړ@\͖
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 OXW
     * @param y1 OYW
     * @param z1 OZW
     * @param x2 EXW
     * @param y2 EYW
     * @param z2 EZW
     * @param pos_prism vYʒuiGgafDxAAPrismActor  #define `Q)
     */
    void setColliAAPrism(int prm_index, coord x1, coord y1, coord z1, coord x2, coord y2, coord z2, int pos_prism) {
        setColliAAPrism(prm_index, x1, y1, z1, x2, y2, z2, pos_prism, false, false, false);
    }



    void setColliAAPrism_WHD(int prm_index, coord x, coord y, coord z, coord prm_width, coord prm_height, coord prm_depth, int pos_prism) {
        int hw = prm_width  / 2;
        int hh = prm_height / 2;
        int hd = prm_depth  / 2;
        setColliAAPrism(prm_index, x-hw, y-hh, z-hd, x+hw, y+hh, z+hd, pos_prism);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * IuWFNg̊_𒆐SƂāAAAsŎw
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_width (X)
     * @param prm_height (Y)
     * @param prm_depth [(Z)
     * @param pos_prism vYʒuiGgafDxAAPrismActor  #define `Q)
     */
    void setColliAAPrism_WHD(int prm_index, coord prm_width, coord prm_height, coord prm_depth, int pos_prism) {
        setColliAAPrism_WHD(prm_index, 0, 0, 0, prm_width, prm_height, prm_depth, pos_prism);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * W𒆐SƂāAPӂ̒Ŏw
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻̗̂̒S[JXW
     * @param y 蔻̗̂̒S[JYW
     * @param z 蔻̗̂̒S[JZW
     * @param prm_edge Pӂ̒
     * @param pos_prism vYʒuiGgafDxAAPrismActor  #define `Q)
     */
    void setColliAAPrism_Cube(int prm_index, coord x, coord y, coord z, coord prm_edge, int pos_prism) {
        int h = prm_edge / 2;
        setColliAAPrism(prm_index, x-h, y-h, z-h, x+h, y+h, z+h, pos_prism);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * W𒆐SƂāAPӂ̒Ŏw
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻̗̂̒S[JXW
     * @param y 蔻̗̂̒S[JYW
     * @param z 蔻̗̂̒S[JZW
     * @param prm_edge Pӂ̒
     * @param rot_x 蔻̗̂Aɔă[JXł̉]sړsꍇ true
     * @param rot_y 蔻̗̂Aɔă[JYł̉]sړsꍇ true
     * @param rot_z 蔻̗̂Aɔă[JZł̉]sړsꍇ true
     * @param pos_prism vYʒuiGgafDxAAPrismActor  #define `Q)
     */
    void setColliAAPrism_Cube(int prm_index, coord x, coord y, coord z, coord prm_edge, int pos_prism, bool rot_x, bool rot_y, bool rot_z) {
        int h = prm_edge / 2;
        setColliAAPrism(prm_index, x-h, y-h, z-h, x+h, y+h, z+h, pos_prism, rot_x, rot_y, rot_z);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * IuWFNg̊_𒆐SƂāAPӂ̒Ŏw
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_edge Pӂ̒
     * @param pos_prism vYʒuiGgafDxAAPrismActor.h ́AߑRgQ)
     */
    void setColliAAPrism_Cube(int prm_index, coord prm_edge, int pos_prism) {
        setColliAAPrism_Cube(prm_index, 0, 0, 0, prm_edge, pos_prism);
    }


    /**
     * 蔻̈vfspOpƂĒ` .
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 OXW
     * @param y1 OYW
     * @param z1 OZW
     * @param x2 EXW
     * @param y2 EYW
     * @param z2 EZW
     * @param pos_pyramid s~bhʒuiPOS_PYRAMID_***)
     * @param rot_x 蔻̒̂Aɔă[JXł̉]sړsꍇ true
     * @param rot_y 蔻̒̂Aɔă[JYł̉]sړsꍇ true
     * @param rot_z 蔻̒̂Aɔă[JZł̉]sړsꍇ true
     */
    void setColliAAPyramid(int prm_index, coord x1, coord y1, coord z1, coord x2, coord y2, coord z2, int pos_pyramid, bool rot_x, bool rot_y, bool rot_z);

    /**
     * 蔻̈vfs̎OpOpƂĒ` .
     * ɔĂ̓蔻̋̉]sړ@\͖
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 OXW
     * @param y1 OYW
     * @param z1 OZW
     * @param x2 EXW
     * @param y2 EYW
     * @param z2 EZW
     * @param pos_pyramid s~bhʒuiGgafDxAAPyramidActor  #define `Q)
     */
    void setColliAAPyramid(int prm_index, coord x1, coord y1, coord z1, coord x2, coord y2, coord z2, int pos_pyramid) {
        setColliAAPyramid(prm_index, x1, y1, z1, x2, y2, z2, pos_pyramid, false, false, false);
    }



    void setColliAAPyramid_WHD(int prm_index, coord x, coord y, coord z, coord prm_width, coord prm_height, coord prm_depth, int pos_pyramid) {
        int hw = prm_width  / 2;
        int hh = prm_height / 2;
        int hd = prm_depth  / 2;
        setColliAAPyramid(prm_index, x-hw, y-hh, z-hd, x+hw, y+hh, z+hd, pos_pyramid);
    }

    /**
     * 蔻̈vfs̎OpOpƂĒ` .
     * IuWFNg̊_𒆐SƂāAAAsŎw
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_width (X)
     * @param prm_height (Y)
     * @param prm_depth [(Z)
     * @param pos_pyramid s~bhʒuiGgafDxAAPyramidActor  #define `Q)
     */
    void setColliAAPyramid_WHD(int prm_index, coord prm_width, coord prm_height, coord prm_depth, int pos_pyramid) {
        setColliAAPyramid_WHD(prm_index, 0, 0, 0, prm_width, prm_height, prm_depth, pos_pyramid);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * W𒆐SƂāAPӂ̒Ŏw
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻̗̂̒S[JXW
     * @param y 蔻̗̂̒S[JYW
     * @param z 蔻̗̂̒S[JZW
     * @param prm_edge Pӂ̒
     * @param pos_pyramid s~bhʒuiGgafDxAAPyramidActor  #define `Q)
     */
    void setColliAAPyramid_Cube(int prm_index, coord x, coord y, coord z, coord prm_edge, int pos_pyramid) {
        int h = prm_edge / 2;
        setColliAAPyramid(prm_index, x-h, y-h, z-h, x+h, y+h, z+h, pos_pyramid);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * W𒆐SƂāAPӂ̒Ŏw
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻̗̂̒S[JXW
     * @param y 蔻̗̂̒S[JYW
     * @param z 蔻̗̂̒S[JZW
     * @param prm_edge Pӂ̒
     * @param rot_x 蔻̗̂Aɔă[JXł̉]sړsꍇ true
     * @param rot_y 蔻̗̂Aɔă[JYł̉]sړsꍇ true
     * @param rot_z 蔻̗̂Aɔă[JZł̉]sړsꍇ true
     * @param pos_pyramid s~bhʒuiGgafDxAAPyramidActor  #define `Q)
     */
    void setColliAAPyramid_Cube(int prm_index, coord x, coord y, coord z, coord prm_edge, int pos_pyramid, bool rot_x, bool rot_y, bool rot_z) {
        int h = prm_edge / 2;
        setColliAAPyramid(prm_index, x-h, y-h, z-h, x+h, y+h, z+h, pos_pyramid, rot_x, rot_y, rot_z);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * IuWFNg̊_𒆐SƂāAPӂ̒Ŏw
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_edge Pӂ̒
     * @param pos_pyramid s~bhʒuiGgafDxAAPyramidActor.h ́AߑRgQ)
     */
    void setColliAAPyramid_Cube(int prm_index, coord prm_edge, int pos_pyramid) {
        setColliAAPyramid_Cube(prm_index, 0, 0, 0, prm_edge, pos_pyramid);
    }

    virtual ~CollisionChecker();
};

}
#endif /*GGAFLIB_COLLISIONCHECKER_H_*/

