#ifndef GGAFLIB_QUANTITY_H_
#define GGAFLIB_QUANTITY_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

namespace GgafLib {

/**
 *  .
 * Ɏl(val)ƂɊւ鐔(qty)B
 * l𑀍ivZjƁAɔĐʂωB
 * @version 1.00
 * @since 2011/02/02
 * @author Masatoshi Tsuge
 */
template<typename QTY, typename VAL>
class Quantity : public GgafCore::GgafObject {

public:

    /** [r]l̃|C^ */
    VAL* _pVal;
    /** [r]lɊւ鐔 */
    QTY _qty;
    /** [r][^[lƃsNZ̊A */
    double _rate_val;

    bool _is_link;

public:
    /**
     * RXgN^ .
     * @return
     */
    Quantity() : GgafCore::GgafObject() {
        _qty = (QTY)0;
        _rate_val = 1.0;
        _pVal = NEW VAL();
        *_pVal = (VAL)0;
        _is_link = false;
    }

    /**
     * ` .
     * @param prm_val 1.0(100%) ̏ꍇɎllZbg
     * @param prm_qty 1.0(100%) ̏ꍇɐʂlZbg
     */
    void graduate(VAL prm_val, QTY prm_qty) {
        _rate_val = 1.0 * prm_qty / prm_val;
    }


    /**
     * l̕ϐĩ|C^jݒ .
     * @param prm_pInt_target_value [^[lϐ̃|C^(int*)ݒ
     */
    void link(VAL* prm_pVariable) {
        if (_is_link) {
            _pVal = prm_pVariable;
        } else {
            GGAF_DELETE(_pVal);
            _pVal = prm_pVariable;
            _is_link = true;
        }

    }

    /**
     * lݒ .
     * ݒ肷ƁÃ݂[^[̒(_qty) XV
     * @param prm_val l
     */
    inline void setVal(VAL prm_val) {
        *_pVal = prm_val;
        _qty = (QTY)((*_pVal) * _rate_val);
    }

    /**
     * llŎ擾 .
     */
    inline VAL getVal() {
        return *_pVal;
    }

    /**
     * llɊւ鐔ʂŎ擾 .
     */
    inline QTY getQty() {
        return _qty;
    }

    virtual ~Quantity() {
        if (!_is_link) {
            GGAF_DELETE(_pVal);
        }
    }
};

}
#endif /*GGAFLIB_QUANTITY_H_*/

