#include "jp/ggaf/lib/actor/camera/worker/AroundViewCamWorker.h"

#include "jp/ggaf/core/GgafFactory.h"
#include "jp/ggaf/core/actor/GgafSceneDirector.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/util/GgafDxInput.h"
#include "jp/ggaf/dxcore/util/GgafDxQuaternion.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoMvAssistant.h"
#include "jp/ggaf/lib/DefaultGod.h"
#include "jp/ggaf/lib/GgafLibProperties.h"
#include "jp/ggaf/lib/actor/camera/DefaultCamera.h"
#include "jp/ggaf/lib/actor/camera/DefaultCameraViewPoint.h"
#include "jp/ggaf/lib/actor/camera/DefaultCameraUpVector.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

AroundViewCamWorker::AroundViewCamWorker(const char* prm_name, DefaultCamera* prm_pCamera) : CameraWorker(prm_name, prm_pCamera) {
    _class_name = "AroundViewCamWorker";
    cd_ = 0;
    mdz_flg_ = false;
    mdz_vx_ = mdz_vy_ = mdz_vz_ = mdz_t_ = 0.0;
}

void AroundViewCamWorker::initialize() {
    CameraWorker::initialize();
}

void AroundViewCamWorker::onActive() {
    CameraWorker::onActive();
    //CameraWorker::onActive(); ㏑āA
    //̏W^[QbgWɏ㏑
    slideMvCamTo(pCam_->_x, pCam_->_y, pCam_->_z, 60);
    slideMvVpTo(pVp_->_x, pVp_->_y, pVp_->_z, 60);
}

void AroundViewCamWorker::processBehavior() {
    //TODO:xグACfBA
    //}EX|Cg̗Amdx,mdy,mdźARt[قǉߋƂ̍ɂƉ]肷邾낤

    long mx,my,mz,mdx,mdy,mdz;
    GgafDxInput::getMousePointer(&mx, &my, &mz);
    GgafDxInput::getMousePointer_REL(&mdx, &mdy, &mdz);
    mdy = -mdy; //Y̓Co[Y

//    if (GgafDxInput::isPushedDownMouseButton(0) || GgafDxInput::isPushedDownMouseButton(1) || GgafDxInput::isPushedDownMouseButton(2)) {
//        pVPGuide_->activate(); //KChON
//    } else if(GgafDxInput::isReleasedUpMouseButton(0) || GgafDxInput::isReleasedUpMouseButton(1) || GgafDxInput::isReleasedUpMouseButton(2)) {
//        pVPGuide_->inactivate(); //KChOFF
//    }

    if (GgafDxInput::isPushedDownMouseButton(0) || GgafDxInput::isPushedDownMouseButton(1) || GgafDxInput::isPushedDownMouseButton(2)) {
        RECT cRect; // NCAg̈̋`
        int cw, ch; // NCAg̈̕A
        // NCAg̈̕EvZ
        GetClientRect(GgafDxGod::_pHWndPrimary, &cRect);
        cw = cRect.right - cRect.left;
        ch = cRect.bottom - cRect.top;
        if (cw > ch) {
            cd_ = ch;
        } else {
            cd_ = cw;
        }
    }

    if ( !(GgafDxInput::isPressedMouseButton(0) && GgafDxInput::isPressedMouseButton(1)) &&
         (GgafDxInput::isPressedMouseButton(0) || GgafDxInput::isPressedMouseButton(1) || GgafDxInput::isPressedMouseButton(2))
    ) {
        //_𒆐SɃJ]ړ
        //J𒆐SɎ_]ړ
        //JƎ_sړ
        //ʂ̌vZ

        //[h]xNgA(vX_axis, vY_axis, vZ_axis) vZ begin =======>

        //ʉ](vx,vy)߂
        //double a = asin(1.0*dx/dy); //a XYʂ̂Ȃp 90x] xy y-x
        double vx = mdy;
        double vy = -mdx;
        double vz = 0;
        double d = sqrt(vx * vx + vy * vy); //|C^ړsNZ

        double t = 1.0 / d;
        vx = t * vx;
        vy = t * vy;
        vz = 0;
        //ʉ](vx,vy)VP̃[hԎɕϊ
        //VPCAM̃[hԕxNg@Ƃ镽ʏɉ]xNg݂͑

        D3DXMATRIX InvView;
        D3DXMatrixInverse( &InvView, nullptr, pCam_->getViewMatrix());
        //(vx,vy,vz) * InvView
        // 11_, 12_, 13_, 14_
        // 21_, 22_, 23_, 24_
        // 31_, 32_, 33_, 34_
        // vx*11_ + vy*21_ + vz*31_ + 41_, vx*12_ + vy*22_ + vz*32_ + 42_, vx*13_ + vy*23_ + vz*33_ + 43_, vx*14_ + vy*24_ + vz*34_ + 44_
        //xNg(0,0,0)->(vx,vy,vz) tr[ϊ
        //ϊxNg = (vx,vy,vz)ϊW - (0,0,0)ϊW
        //               <------------  (vx,vy,vz)ϊW-------------------------->    <-- (0,0,0)ϊW -->
        double vX_axis = vx*InvView._11 + vy*InvView._21 + vz*InvView._31 + InvView._41  -    InvView._41;
        double vY_axis = vx*InvView._12 + vy*InvView._22 + vz*InvView._32 + InvView._42  -    InvView._42;
        double vZ_axis = vx*InvView._13 + vy*InvView._23 + vz*InvView._33 + InvView._43  -    InvView._43;
        //K
        double d2 = sqrt(vX_axis * vX_axis + vY_axis * vY_axis + vZ_axis * vZ_axis);
        double t2 = 1.0 / d2;
        vX_axis = t2 * vX_axis;
        vY_axis = t2 * vY_axis;
        vZ_axis = t2 * vZ_axis;
        //<==========  [h]xNgA(vX_axis, vY_axis, vZ_axis) vZ end

        //W(x, y, z)ɂāA]̎(, , )ŁAƉ񂷉]
        //P = (0; x, y, z)
        //Q = (cos(/2);  sin(/2),  sin(/2),  sin(/2))
        //R = (cos(/2); - sin(/2), - sin(/2), - sin(/2))
        //R P Q = (0; )
        //(, , ) = (vX_axis,vY_axis,vY_axis);
        //(x, y, z)  CAM  VP

        //_𒆐SɃJ]ړ
        if (GgafDxInput::isPressedMouseButton(0) && (mdx != 0 || mdy != 0)) {
            //_J ̕xNg(x,y,z)
            double x = t_x_CAM_ - t_x_VP_;
            double y = t_y_CAM_ - t_y_VP_;
            double z = t_z_CAM_ - t_z_VP_;

            //]px
            double ang = (PI) * (d/cd_);
            double sinHalf = sin(ang/2);
            double cosHalf = cos(ang/2);

            GgafDxQuaternion Q(cosHalf, -vX_axis*sinHalf, -vY_axis*sinHalf, -vZ_axis*sinHalf);  //R
            Q.mul(0,x,y,z);//R*P
            Q.mul(cosHalf, vX_axis*sinHalf, vY_axis*sinHalf, vZ_axis*sinHalf); //R*P*Q
            slideMvCamTo(Q.i + t_x_VP_, Q.j + t_y_VP_, Q.k + t_z_VP_, 60);
        }
        //J𒆐SɎ_]ړ
        if (GgafDxInput::isPressedMouseButton(1) && (mdx != 0 || mdy != 0)) {
            //J_ ̕xNg(x,y,z)
            double x = t_x_VP_ - t_x_CAM_;
            double y = t_y_VP_ - t_y_CAM_;
            double z = t_z_VP_ - t_z_CAM_;
            //]px
            double ang = (PI) * (d/cd_);
            double sinHalf = sin(ang/2);
            double cosHalf = cos(ang/2);
            GgafDxQuaternion Q(cosHalf, -vX_axis*sinHalf, -vY_axis*sinHalf, -vZ_axis*sinHalf);  //R
            Q.mul(0,x,y,z);//R*P ]݂̐isxNgƂȂ
            Q.mul(cosHalf, vX_axis*sinHalf, vY_axis*sinHalf, vZ_axis*sinHalf); //R*P*Q
            slideMvVpTo(Q.i + t_x_CAM_, Q.j + t_y_CAM_, Q.k + t_z_CAM_, 60);
        }
        //JƎ_sړ
        if (GgafDxInput::isPressedMouseButton(2) && (mdx != 0 || mdy != 0)) {
            double ang = -PI/2.0;
            double sinHalf = sin(ang/2); //]px
            double cosHalf = cos(ang/2);
            double x = t_x_VP_ - t_x_CAM_;
            double y = t_y_VP_ - t_y_CAM_;
            double z = t_z_VP_ - t_z_CAM_;
            //K
            double d3 = sqrt(x * x + y * y + z * z);
            double t3 = 1.0 / d3;
            x = t3 * x;
            y = t3 * y;
            z = t3 * z;

            GgafDxQuaternion Q(cosHalf, -vX_axis*sinHalf, -vY_axis*sinHalf, -vZ_axis*sinHalf);  //R
            Q.mul(0,x,y,z);//R*P ]݂̐isxNgƂȂ
            Q.mul(cosHalf, vX_axis*sinHalf, vY_axis*sinHalf, vZ_axis*sinHalf); //R*P*Q
            double r = ((d/cd_) * PX_C(PROPERTY::GAME_BUFFER_WIDTH*2));
            slideMvCamTo(t_x_CAM_ + (Q.i*r),
                         t_y_CAM_ + (Q.j*r),
                         t_z_CAM_ + (Q.k*r) , 60);
            slideMvVpTo(t_x_VP_ + (Q.i*r),
                        t_y_VP_ + (Q.j*r),
                        t_z_VP_ + (Q.k*r) , 60);
        }

    } else if (mdz != 0 || (GgafDxInput::isPressedMouseButton(0) && GgafDxInput::isPressedMouseButton(1))) {
        if (mdz_flg_ == false) {
            //zC[ijŏ̃t[
            mdz_total_ = 0;
            //J  _ ̕xNg
            double vx = pVp_->_x - pCam_->_x;
            double vy = pVp_->_y - pCam_->_y;
            double vz = pVp_->_z - pCam_->_z;
            double t = 1.0 / sqrt(vx * vx + vy * vy + vz * vz);
            mdz_vx_ = t * vx;
            mdz_vy_ = t * vy;
            mdz_vz_ = t * vz;
        }
        double r = 0.0;
        if (mdz != 0) {
            r = (mdz*PX_UNIT*LEN_UNIT/10.0);
        } else if ((GgafDxInput::isPressedMouseButton(0) && GgafDxInput::isPressedMouseButton(1))) {
            r = ((1.0*mdy/cd_) * PROPERTY::GAME_BUFFER_WIDTH*2)*LEN_UNIT;
        }
        if (mdx != 0 || mdy != 0 || mdz != 0) {
            slideMvCamTo(t_x_CAM_ + mdz_vx_*r,
                         t_y_CAM_ + mdz_vy_*r,
                         t_z_CAM_ + mdz_vz_*r , 60);
            slideMvVpTo(t_x_VP_ + mdz_vx_*r,
                        t_y_VP_ + mdz_vy_*r,
                        t_z_VP_ + mdz_vz_*r , 60);
        }
        mdz_flg_ = true;
    } else {
        mdz_flg_ = false;
    }

    targetAutoCamup();
}

AroundViewCamWorker::~AroundViewCamWorker() {
}
