#include "jp/ggaf/lib/util/spline/SteppedCoordSplineKurokoLeader.h"

#include "jp/ggaf/dxcore/exception/GgafDxCriticalException.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/lib/util/StgUtil.h"
#include "jp/ggaf/lib/util/spline/SplineLine.h"
#include "jp/ggaf/lib/util/spline/SplineSource.h"
#include "jp/ggaf/lib/util/spline/SteppedCoordSplineManufacture.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

SteppedCoordSplineKurokoLeader::SteppedCoordSplineKurokoLeader(SplineManufacture* prm_pManufacture, GgafDxKuroko* prm_pKuroko_target) :
        SplineKurokoLeader(prm_pManufacture, prm_pKuroko_target) {
    _pSteppedSplManuf = (SteppedCoordSplineManufacture*)prm_pManufacture;
    _leading_frames = 0;
    _point_index = -1;
}

SteppedCoordSplineKurokoLeader::SteppedCoordSplineKurokoLeader(GgafDxKuroko* prm_pKuroko_target,
                                                               SplineLine* prm_pSpl):
        SplineKurokoLeader(nullptr, prm_pKuroko_target) { //nullptrœnɂA_is_created_pManufacture  falseɂȂ
    _pSteppedSplManuf = NEW SteppedCoordSplineManufacture(NEW SplineSource(prm_pSpl));
    _pSteppedSplManuf->calculate(); //YȂ悤ɁBꂱ̃^Cv͏
    _pManufacture = _pSteppedSplManuf; //ꃁo[ZbgBYȂ悤ɁBꂱ̃^Cv͏
    _leading_frames = 0;
    _point_index = -1;
}

void SteppedCoordSplineKurokoLeader::restart() {
    SplineKurokoLeader::restart();
    _leading_frames = 0;
    //n_֍sʏB
    if (ABS(_distance_to_begin) <= PX_C(1)) {
        //n_Ƃ̋ꍇ(PX_C(1)ȉ)̏ꍇA
        //XvCԓ_̑P_ڂԈāAn_̎̕ԓ_X^[g
        _point_index = 0;
    } else {
        //n_Ƃ̋Ă΁APt[₵n_
        _point_index = -1;
    }
}

void SteppedCoordSplineKurokoLeader::behave() {
    if (_is_leading) {
        GgafDxKuroko* const pKuroko_target = _pActor_target->getKuroko();
        _point_index++;
        if (_point_index == _pSteppedSplManuf->_sp->_rnum) {
            if (_cnt_loop == _max_loop) {
                //I
                _is_leading = false;
                return;
            } else {
                //[v
                _cnt_loop++;
                restart();
                _point_index++;
            }
        }
        coord x, y, z;
        getPointCoord(_point_index, x, y, z);
        coord d = UTIL::getDistance(_pActor_target->_x, _pActor_target->_y, _pActor_target->_z, x, y, z);
        pKuroko_target->setMvAngTwd(x, y, z);
        pKuroko_target->setMvVelo(d);
        _leading_frames++;
    }
}

SteppedCoordSplineKurokoLeader::~SteppedCoordSplineKurokoLeader() {
}
