#include "GgafEffectConst.fxh" 

////////////////////////////////////////////////////////////////////////////////
// CubeMapMassWallActorpVF[_[
// yTvz
// OǃvY̕`sB
// _obt@ɁAOǃvY񂪁A10JԂlߍłB
// Xe[g⃌WX^̍XVs킸AP `ŁAő
// 10IuWFNg܂ŕ`B_B
// author : Masatoshi Tsuge
// date:2011/01/10
////////////////////////////////////////////////////////////////////////////////
//G[̂߂ɂƂ肠ǉłƂ
float3 g_posCam_World;
float g_reflectance;
float g_specular;
float g_specular_power;

float g_distance_AlphaTarget;
float g_wall_dep;    //ǃubN̒iXWj
float g_wall_height; //ǃubN̍iYWj
float g_wall_width;  //ǃubN̕iZW)

float g_ah_POS_PRISM_ZX;
float g_fh_POS_PRISM_ZX;
float g_ah_POS_PRISM_YZ;
float g_fh_POS_PRISM_YZ;
float g_ah_POS_PRISM_XY;
float g_fh_POS_PRISM_XY;


float g_zf;
float g_tex_blink_power;   
float g_tex_blink_threshold;
float g_alpha_master;
// Cg̕
float3 g_vecLightFrom_World;
// AmbienCgFiːFj
float4 g_colLightAmbient;
// DiffuseCgFiːFj  
float4 g_colLightDiffuse;  
//Viewϊs
float4x4 g_matView; 
//ˉeϊs  
float4x4 g_matProj;  

#define POS_PRISM_nn    1 
#define POS_PRISM_np    2 
#define POS_PRISM_pn    4 
#define POS_PRISM_pp    8 
#define POS_PRISM_XY    16
#define POS_PRISM_YZ    32
#define POS_PRISM_ZX    64

//eNX`̃Tv(s0WX^)
sampler MyTextureSampler : register(s0);
sampler CubeMapTextureSampler : register(s1);
sampler BumpMapTextureSampler : register(s2);

//_VF[_[Ao͍\
struct OUT_VS
{
    float4 posModel_Proj   : POSITION;
	float2 uv              : TEXCOORD0;
	float4 color           : COLOR0;
    float3 vecNormal_World : TEXCOORD1;   //_̖@xNg([hWn)
    float3 vecEye_World    : TEXCOORD2;   //_̎(_->_)xNg([hWn)
};


///////////////////////////////////////////////////////////////////////////

//_VF[_[
OUT_VS GgafDxVS_CubeMapMassWall(
      float4 prm_posModel_Local   : POSITION,      // f̒_
      float3 prm_vecNormal_Local  : NORMAL,        // f̒_̖@
      float2 prm_uv               : TEXCOORD0 ,    // f̒_UV

      float4 prm_world0           : TEXCOORD1,
      float4 prm_world1           : TEXCOORD2,
      float4 prm_world2           : TEXCOORD3,
      float4 prm_world3           : TEXCOORD4,
      float2 prm_info             : TEXCOORD5
) {
	OUT_VS out_vs = (OUT_VS)0;

	int draw_face = (int)(prm_info.x);
    //UVɂǂ̖ʂ̒_fA
    //`svȖʂ̒_̏ꍇ͉ƂiWIgVF[_[gGj

    //draw_face͕ǕɃrbgĂ
    //&b 00abcdef
    //
    //}BOX̓WJԂ̐}
    //
    //                   ^y
    //              z  | 
    //                 \ | 
    //                  c| 
    // ----@--- a b d f ---- -> x
    //                   |e
    //                   | \
    //                   |  \   
	//  u v
	// (0,0)      0.25                     u
	//       +------+------+------+------+
	//       |      |        Z+          |
	//       |      |       c          |
	//  0.25 +  X+  +--------------------+
	//       | f  |        Y-          |
	//       |      |       d          |
	//   0.5 +------+--------------------+
	//       |      |        Y+          |
	//       |      |       a          |
	//  0.75 +  X-  +--------------------+
	//       | b  |        Z-          |
	//       |      |       e          |
	//       +------+------+------+------+
	//                                    (1,1)
	//    v

    //                          00abcdef
  	if (draw_face >= 32) {  //&b00100000
        draw_face -= 32;
    } else {
        //(a)`sv̏ꍇ
        if (0.25 < prm_uv.x && 
            0.5  < prm_uv.y && prm_uv.y < 0.75 ) 
		{
            return out_vs;
        }
    }

    //                          00abcdef
  	if (draw_face >= 16) {  //&b00010000
        draw_face -= 16;
    } else {
        //(b)`sv̏ꍇ
        if (                   prm_uv.x < 0.25 &&
            0.5  < prm_uv.y                       ) 
		{
            return out_vs;
        }
    }
    //                          00abcdef
  	if (draw_face >= 8) {   //&b00001000
        draw_face -= 8;
    } else {
        //(c)`sv̏ꍇ
        if (0.25 < prm_uv.x && 
                               prm_uv.y < 0.25 ) 
		{
            return out_vs;
        }
    }
    //                          00abcdef
   	if (draw_face >= 4) {   //&b00000100
        draw_face -= 4;
    } else {
        //(d)`sv̏ꍇ
        if (0.25 < prm_uv.x &&
            0.25 < prm_uv.y && prm_uv.y < 0.5 ) 
		{
            return out_vs;
        }
    }
    //                          00abcdef
  	if (draw_face >= 2) {   //&b00000010
        draw_face -= 2;
    } else {
        //E(e)`sv̏ꍇ
        if (0.25 < prm_uv.x &&
            0.75 < prm_uv.y                    ) 
		{
            return out_vs;
        } 
    }
    //                          00abcdef
  	if (draw_face >= 1) {   //&b00000001
       // draw_face -= 1;
    } else {
        //(f)`sv̏ꍇ
        if (                    prm_uv.x < 0.25 &&
                                prm_uv.y < 0.5    ) 
		{
            return out_vs;
        }
    }

	int pos_prism = (int)(prm_info.y);

	if (pos_prism == 0) {
        //BOX
	} else if (pos_prism >= POS_PRISM_ZX) {   
        //BOX̂Pʂ𖳗ăvY^ɕό`
		//{X -X ̖ʂvY̎΂ߖʂɂȂȂ悤ɂ
		// ZX  XZʂƌ
		pos_prism -= POS_PRISM_ZX;
		if (pos_prism == POS_PRISM_pp) {
			prm_posModel_Local.z = (prm_posModel_Local.z * ((prm_posModel_Local.x+g_fh_POS_PRISM_ZX)/g_wall_dep))       - ((prm_posModel_Local.x-g_fh_POS_PRISM_ZX)*g_ah_POS_PRISM_ZX);
		} else if (pos_prism == POS_PRISM_pn) {
			prm_posModel_Local.z = (prm_posModel_Local.z * (1.0-((prm_posModel_Local.x+g_fh_POS_PRISM_ZX)/g_wall_dep))) + ((prm_posModel_Local.x+g_fh_POS_PRISM_ZX)*g_ah_POS_PRISM_ZX);
		} else if (pos_prism == POS_PRISM_np) { 
			prm_posModel_Local.z = (prm_posModel_Local.z * ((prm_posModel_Local.x+g_fh_POS_PRISM_ZX)/g_wall_dep))       + ((prm_posModel_Local.x-g_fh_POS_PRISM_ZX)*g_ah_POS_PRISM_ZX);
		} else { //if (pos_prism == POS_PRISM_nn) {
			prm_posModel_Local.z = (prm_posModel_Local.z * (1.0-((prm_posModel_Local.x+g_fh_POS_PRISM_ZX)/g_wall_dep))) - ((prm_posModel_Local.x+g_fh_POS_PRISM_ZX)*g_ah_POS_PRISM_ZX);
		}
	} else if (pos_prism >= POS_PRISM_YZ) {   
		//{Z -Z ̖ʂvY̎΂ߖʂɂȂȂ悤ɂ
		pos_prism -= POS_PRISM_YZ;
		if (pos_prism == POS_PRISM_pp) {
			prm_posModel_Local.y = (prm_posModel_Local.y * ((prm_posModel_Local.z+g_fh_POS_PRISM_YZ)/g_wall_width))       - ((prm_posModel_Local.z-g_fh_POS_PRISM_YZ)*g_ah_POS_PRISM_YZ);
		} else if (pos_prism == POS_PRISM_pn) {
			prm_posModel_Local.y = (prm_posModel_Local.y * (1.0-((prm_posModel_Local.z+g_fh_POS_PRISM_YZ)/g_wall_width))) + ((prm_posModel_Local.z+g_fh_POS_PRISM_YZ)*g_ah_POS_PRISM_YZ);
		} else if (pos_prism == POS_PRISM_np) { 
			prm_posModel_Local.y = (prm_posModel_Local.y * ((prm_posModel_Local.z+g_fh_POS_PRISM_YZ)/g_wall_width))       + ((prm_posModel_Local.z-g_fh_POS_PRISM_YZ)*g_ah_POS_PRISM_YZ);
		} else { //if (pos_prism == POS_PRISM_nn) {
			prm_posModel_Local.y = (prm_posModel_Local.y * (1.0-((prm_posModel_Local.z+g_fh_POS_PRISM_YZ)/g_wall_width))) - ((prm_posModel_Local.z+g_fh_POS_PRISM_YZ)*g_ah_POS_PRISM_YZ);
		}
	} else { //if (pos_prism >= POS_PRISM_XY) {   
		pos_prism -= POS_PRISM_XY;
		//{X -X ̖ʂvY̎΂ߖʂɂȂȂ悤ɂ
		if (pos_prism == POS_PRISM_pp) {
			prm_posModel_Local.y = (prm_posModel_Local.y * ((prm_posModel_Local.x+g_fh_POS_PRISM_XY)/g_wall_dep))       - ((prm_posModel_Local.x-g_fh_POS_PRISM_XY)*g_ah_POS_PRISM_XY);
		} else if (pos_prism == POS_PRISM_pn) {
			prm_posModel_Local.y = (prm_posModel_Local.y * ((prm_posModel_Local.x+g_fh_POS_PRISM_XY)/g_wall_dep))       + ((prm_posModel_Local.x-g_fh_POS_PRISM_XY)*g_ah_POS_PRISM_XY);
		} else if (pos_prism == POS_PRISM_np) { 
			prm_posModel_Local.y = (prm_posModel_Local.y * (1.0-((prm_posModel_Local.x+g_fh_POS_PRISM_XY)/g_wall_dep))) + ((prm_posModel_Local.x+g_fh_POS_PRISM_XY)*g_ah_POS_PRISM_XY);
		} else { //if (pos_prism == POS_PRISM_nn) {
			prm_posModel_Local.y = (prm_posModel_Local.y * (1.0-((prm_posModel_Local.x+g_fh_POS_PRISM_XY)/g_wall_dep))) - ((prm_posModel_Local.x+g_fh_POS_PRISM_XY)*g_ah_POS_PRISM_XY);
		}
	}
	//
	//(prm_posModel_Local.y * ((prm_posModel_Local.x+fh)/g_wall_dep))   EEE [LbƂ܂Ƃ߂vZ
	//+ ((prm_posModel_Local.x-fh)*ah);                      EEE [𐅕ɂvZ

	float4x4 matWorld;
    matWorld._11_12_13_14 = prm_world0; 
    matWorld._21_22_23_24 = prm_world1;
    matWorld._31_32_33_34 = prm_world2;
    matWorld._41_42_43_44 = prm_world3; 
	//World*View*ˉeϊ
    const float4 posModel_World = mul(prm_posModel_Local, matWorld);        //World ϊ
    out_vs.posModel_Proj = mul( mul( posModel_World, g_matView), g_matProj);  //View*ˉe ϊ
	//UV͂̂܂
	out_vs.uv = prm_uv;
	//@ World ϊĐK
    out_vs.vecNormal_World = normalize(mul(prm_vecNormal_Local, matWorld)); 	
    out_vs.vecNormal_World.x+=0.5; //l0.5͕ǖʂɂ𓖂Ă邽
                   //CgxNg XYZ=0.819232,-0.573462,0 ŒBƂ肠B
    //@ƁADiffuseCg̓ςvZAʂɑ΂郉Cg̓ˊpɂ錸߂B
	float power = max(dot(out_vs.vecNormal_World, float3(-0.819232,0.573462,0)), 0);      
// const float power = max(dot(out_vs.vecNormal_World, -g_vecLightFrom_World ), 0); //{

	//AmbientCgFADiffuseCgFADiffuseCg lJ[쐬B      
	out_vs.color = (g_colLightAmbient + (g_colLightDiffuse*power));// * }eAFcolMaterialDiffuse;
    //u_J_vxNg
    out_vs.vecEye_World = normalize(g_posCam_World.xyz - posModel_World.xyz);

	//tHO
	//out_vs.color.a = colMaterialDiffuse.a;
//    if (out_vs.posModel_Proj.z > 0.6*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
//        out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
//    }
    
    if (out_vs.posModel_Proj.z > out_vs.posModel_Proj.w) {
        out_vs.posModel_Proj.z = out_vs.posModel_Proj.w;
    }
    //@O̓
	if ( out_vs.posModel_Proj.z < g_distance_AlphaTarget) {
		out_vs.color.a = (out_vs.posModel_Proj.z + 1.0)  / (g_distance_AlphaTarget*2);
	}
//    if (out_vs.posModel_Proj.z > g_zf*0.98) {   
//        out_vs.posModel_Proj.z = g_zf*0.98; //{OZłA`邽0.9ȓɏ㏑A
//    }
	return out_vs;
}

//bVWsNZVF[_[ieNX`Lj
float4 GgafDxPS_CubeMapMassWall(
	float2 prm_uv              : TEXCOORD0,
    float4 prm_color           : COLOR0,
    float3 prm_vecNormal_World : TEXCOORD1,
    float3 prm_vecEye_World    : TEXCOORD2   //_ -> _ xNg
) : COLOR  {
    if (prm_color.a == 0) {
        discard;
    }

    const float4 colTexCube = texCUBE(CubeMapTextureSampler, reflect(-prm_vecEye_World, prm_vecNormal_World));
    const float4 colTex2D   = tex2D( MyTextureSampler, prm_uv);

    float s = 0.0f; //XyL
    if (g_specular_power != 0) {
        //n[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNgj
        const float3 vecHarf = normalize(prm_vecEye_World + float3(-0.819232,0.573462,0));
        //const float3 vecHarf = normalize(prm_vecEye_World + (-g_vecLightFrom_World));  //{
        //n[txNgƖ@̓ςXyLvZ
        s = pow( max(0.0f, dot(prm_vecNormal_World, vecHarf)), g_specular ) * g_specular_power;
    }

    float4 colOut = (colTex2D * prm_color) + (colTexCube*g_reflectance) + s;
    //Blinkerl
    if (colTex2D.r >= g_tex_blink_threshold || colTex2D.g >= g_tex_blink_threshold || colTex2D.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power; //+ (colTex2D * g_tex_blink_power);
    }

    colOut.a = prm_color.a * colTex2D.a * colTexCube.a * g_alpha_master;

	return colOut;
}


float4 PS_Flush( 
	float2 prm_uv	  : TEXCOORD0,
    float4 prm_color    : COLOR0
) : COLOR  {
	//eNX`TvOĐF擾iF擾j
	const float4 colTex = tex2D( MyTextureSampler, prm_uv);        
	float4 colOut = colTex * prm_color * FLUSH_COLOR;
    colOut.a *= g_alpha_master;
	return colOut;
}

technique CubeMapMassWallTechnique
{
	pass P0 {
		AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
		SrcBlend  = SrcAlpha;
		DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
		//BlendOpAlpha = Add;       //default
		VertexShader = compile VS_VERSION GgafDxVS_CubeMapMassWall();
		PixelShader  = compile PS_VERSION GgafDxPS_CubeMapMassWall();
	}
}

technique DestBlendOne
{
	pass P0 {
		AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
		SrcBlend  = SrcAlpha;   
		DestBlend = One; //Z
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
		//BlendOpAlpha = Add;       //default
		VertexShader = compile VS_VERSION GgafDxVS_CubeMapMassWall();
		PixelShader  = compile PS_VERSION GgafDxPS_CubeMapMassWall();
	}
}

technique Flush
{
	pass P0 {
		AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
		SrcBlend  = SrcAlpha;
		DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
		//BlendOpAlpha = Add;       //default
		VertexShader = compile VS_VERSION GgafDxVS_CubeMapMassWall();
		PixelShader  = compile PS_VERSION PS_Flush();
	}
}
