#include "GgafEffectConst.fxh"
////////////////////////////////////////////////////////////////////////////////
// GgafCuAGgafDxMassMorphMeshModelpVF[_[
// author : Masatoshi Tsuge
// date:2016/03/18
////////////////////////////////////////////////////////////////////////////////

/** XyL[͈̔́in[txNgE@ςg_specularj */
float g_specular;
/** XyL[̋x */
float g_specular_power;
/** Ji_j̈ʒuxNg */
float3 g_posCam_World;

float4x4 g_matView;   //Viewϊs
float4x4 g_matProj;   //ˉeϊs

float3 g_vecLightFrom_World; // Cg̕
float4 g_colLightAmbient;   // AmbienCgFiːFj
float4 g_colLightDiffuse;   // DiffuseCgFiːFj

//float4 g_colMaterialDiffuse;  //}eADiffuseːFƁAAmbienːF
float g_tex_blink_power;
float g_tex_blink_threshold;
float g_alpha_master;
float g_zf;

//soWX^̃Tvg(ŒpCvCɃZbgꂽeNX`VF[_[Ŏg)
sampler MyTextureSampler : register(s0);

//texture g_diffuseMap;
//sampler MyTextureSampler = sampler_state {
//	texture = <g_diffuseMap>;
//};

//_VF[_[Ao͍\
struct OUT_VS
{
    float4 posModel_Proj   : POSITION;
    float2 uv              : TEXCOORD0;
    float4 color           : COLOR0;
    float3 vecNormal_World : TEXCOORD1;   // [hϊ@
    float3 vecEye_World    : TEXCOORD2;   //_ -> _ xNg
};


///////////////////////////////////////////////////////////////////////////

OUT_VS GgafDxVS_DefaultMassMorphMesh(
    float4 prm_posPrimary_Local      ,  // f̒_
    float3 prm_vecNormalPrimary_Local,  // f̒_̖@
    float2 prm_uv0                   ,  // f̒_UV

    float4 prm_world0,
    float4 prm_world1,
    float4 prm_world2,
    float4 prm_world3,
    float4 prm_color
) {
    OUT_VS out_vs = (OUT_VS)0;

    float4x4 matWorld;
    matWorld._11_12_13_14 = prm_world0;
    matWorld._21_22_23_24 = prm_world1;
    matWorld._31_32_33_34 = prm_world2;
    matWorld._41_42_43_44 = prm_world3;

    //_vZ
    const float4 posModel_World = mul(prm_posPrimary_Local, matWorld);
    out_vs.posModel_Proj = mul( mul( posModel_World, g_matView), g_matProj);  //World*View*ˉe
    //UVvZ
    out_vs.uv = prm_uv0;  //̂܂

    //@ World ϊĐK
    out_vs.vecNormal_World = normalize(mul(prm_vecNormalPrimary_Local, matWorld));
    //@ƁAgU̓ς烉Cgˊp߁Aʂɑ΂gǓ߂B
    const float power = max(dot(out_vs.vecNormal_World, -g_vecLightFrom_World ), 0);
    //gUFɌ悶AFZAŜ}eAF|B
    out_vs.color = (g_colLightAmbient + (g_colLightDiffuse*power)) * prm_color;
    //u_J_vxNg
    out_vs.vecEye_World = normalize(g_posCam_World.xyz - posModel_World.xyz);
    //̓}eAŗDƂi㏑j
    out_vs.color.a = prm_color.a;
    //tHO
    if (out_vs.posModel_Proj.z > 0.6*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
        out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
    }
//    if (out_vs.posModel_Proj.z > g_zf*0.98) {
//        out_vs.posModel_Proj.z = g_zf*0.98; //{OZłA`邽0.9ȓɏ㏑A
//    }
    return out_vs;
}


//[t^[QbgȂ
OUT_VS GgafDxVS_DefaultMassMorphMesh0(
    //vertex model
    float4 prm_posPrimary_Local       : POSITION0,  // f̒_
    float3 prm_vecNormalPrimary_Local : NORMAL0,    // f̒_̖@
    float2 prm_uv0                    : TEXCOORD0,  // f̒_UV
    //vertex instace data
    float4 prm_world0                 : TEXCOORD1,  // Worldsvf
    float4 prm_world1                 : TEXCOORD2,  // Worldsvf
    float4 prm_world2                 : TEXCOORD3,  // Worldsvf
    float4 prm_world3                 : TEXCOORD4,  // Worldsvf
    float4 prm_color                  : TEXCOORD5   // }eAJ[
) {
    float4 posModel_Local = prm_posPrimary_Local;
    float3 vecNormal_Local = prm_vecNormalPrimary_Local;
    return GgafDxVS_DefaultMassMorphMesh(posModel_Local, vecNormal_Local, prm_uv0,
                                         prm_world0,
                                         prm_world1,
                                         prm_world2,
                                         prm_world3,
                                         prm_color  );
}


//[t^[QbgP
OUT_VS GgafDxVS_DefaultMassMorphMesh1(
    //vertex model
    float4 prm_posPrimary_Local       : POSITION0,  // f̒_
    float3 prm_vecNormalPrimary_Local : NORMAL0,    // f̒_̖@
    float2 prm_uv0                    : TEXCOORD0,  // f̒_UV
    float4 prm_posMorphTarget1_Local  : POSITION1,  // f̃[t^[Qbg1_
    float3 prm_vecNormal1_Local       : NORMAL1  ,  // f̃[t^[Qbg1_̖@
    //vertex instace data
    float4 prm_world0                 : TEXCOORD1,  // Worldsvf
    float4 prm_world1                 : TEXCOORD2,  // Worldsvf
    float4 prm_world2                 : TEXCOORD3,  // Worldsvf
    float4 prm_world3                 : TEXCOORD4,  // Worldsvf
    float4 prm_color                  : TEXCOORD5   // }eAJ[
) {
    //d݂oāAɖ߂
    float weight1 = prm_world0[3];
    prm_world0[3] = 0;
    //_@uh
    float4 posModel_Local = prm_posPrimary_Local;
    float3 vecNormal_Local = prm_vecNormalPrimary_Local;
    if (weight1 != 0.0 ) {
        posModel_Local  = lerp(posModel_Local , prm_posMorphTarget1_Local, weight1);
        vecNormal_Local = lerp(vecNormal_Local, prm_vecNormal1_Local     , weight1);
    }

    return GgafDxVS_DefaultMassMorphMesh(posModel_Local, vecNormal_Local, prm_uv0,
                                         prm_world0,
                                         prm_world1,
                                         prm_world2,
                                         prm_world3,
                                         prm_color  );
}


//[t^[QbgQ
OUT_VS GgafDxVS_DefaultMassMorphMesh2(
    //vertex model
    float4 prm_posPrimary_Local       : POSITION0,  // f̒_
    float3 prm_vecNormalPrimary_Local : NORMAL0,    // f̒_̖@
    float2 prm_uv0                    : TEXCOORD0,  // f̒_UV
    float4 prm_posMorphTarget1_Local  : POSITION1,  // f̃[t^[Qbg1_
    float3 prm_vecNormal1_Local       : NORMAL1,    // f̃[t^[Qbg1_̖@
    float4 prm_posMorphTarget2_Local  : POSITION2,  // f̃[t^[Qbg2_
    float3 prm_vecNormal2_Local       : NORMAL2  ,  // f̃[t^[Qbg2_̖@
    //vertex instace data
    float4 prm_world0                 : TEXCOORD1,  // Worldsvf
    float4 prm_world1                 : TEXCOORD2,  // Worldsvf
    float4 prm_world2                 : TEXCOORD3,  // Worldsvf
    float4 prm_world3                 : TEXCOORD4,  // Worldsvf
    float4 prm_color                  : TEXCOORD5   // }eAJ[
) {
    //d݂oāAɖ߂
    float weight1 = prm_world0[3];
    float weight2 = prm_world1[3];
    prm_world0[3] = 0;
    prm_world1[3] = 0;
    //_@uh
    float4 posModel_Local = prm_posPrimary_Local;
    float3 vecNormal_Local = prm_vecNormalPrimary_Local;
    if (weight1 != 0) {
        posModel_Local  = lerp(posModel_Local , prm_posMorphTarget1_Local, weight1);
        vecNormal_Local = lerp(vecNormal_Local, prm_vecNormal1_Local     , weight1);
    }
    if (weight2 != 0) {
        posModel_Local  = lerp(posModel_Local , prm_posMorphTarget2_Local, weight2);
        vecNormal_Local = lerp(vecNormal_Local, prm_vecNormal2_Local     , weight2);
    }
    return GgafDxVS_DefaultMassMorphMesh(posModel_Local, vecNormal_Local, prm_uv0,
                                         prm_world0,
                                         prm_world1,
                                         prm_world2,
                                         prm_world3,
                                         prm_color  );
}


//[t^[QbgR
OUT_VS GgafDxVS_DefaultMassMorphMesh3(
    //vertex model
    float4 prm_posPrimary_Local       : POSITION0,  // f̒_
    float3 prm_vecNormalPrimary_Local : NORMAL0,    // f̒_̖@
    float2 prm_uv0                    : TEXCOORD0,  // f̒_UV
    float4 prm_posMorphTarget1_Local  : POSITION1,  // f̃[t^[Qbg1_
    float3 prm_vecNormal1_Local       : NORMAL1,    // f̃[t^[Qbg1_̖@
    float4 prm_posMorphTarget2_Local  : POSITION2,  // f̃[t^[Qbg2_
    float3 prm_vecNormal2_Local       : NORMAL2,    // f̃[t^[Qbg2_̖@
    float4 prm_posMorphTarget3_Local  : POSITION3,  // f̃[t^[Qbg3_
    float3 prm_vecNormal3_Local       : NORMAL3,    // f̃[t^[Qbg3_̖@
    //vertex instace data
    float4 prm_world0                 : TEXCOORD1,  // Worldsvf
    float4 prm_world1                 : TEXCOORD2,  // Worldsvf
    float4 prm_world2                 : TEXCOORD3,  // Worldsvf
    float4 prm_world3                 : TEXCOORD4,  // Worldsvf
    float4 prm_color                  : TEXCOORD5   // }eAJ[
) {
    //d݂oāAɖ߂
    float weight1 = prm_world0[3];
    float weight2 = prm_world1[3];
    float weight3 = prm_world2[3];
    prm_world0[3] = 0;
    prm_world1[3] = 0;
    prm_world2[3] = 0;
    //_@uh
    float4 posModel_Local = prm_posPrimary_Local;
    float3 vecNormal_Local = prm_vecNormalPrimary_Local;
    if (weight1 != 0) {
        posModel_Local  = lerp(posModel_Local , prm_posMorphTarget1_Local, weight1);
        vecNormal_Local = lerp(vecNormal_Local, prm_vecNormal1_Local     , weight1);
    }
    if (weight2 != 0) {
        posModel_Local  = lerp(posModel_Local , prm_posMorphTarget2_Local, weight2);
        vecNormal_Local = lerp(vecNormal_Local, prm_vecNormal2_Local     , weight2);
    }
    if (weight3 != 0) {
        posModel_Local  = lerp(posModel_Local , prm_posMorphTarget3_Local, weight3);
        vecNormal_Local = lerp(vecNormal_Local, prm_vecNormal3_Local     , weight3);
    }
    return GgafDxVS_DefaultMassMorphMesh(posModel_Local, vecNormal_Local, prm_uv0,
                                         prm_world0,
                                         prm_world1,
                                         prm_world2,
                                         prm_world3,
                                         prm_color  );
}


//[t^[QbgS
OUT_VS GgafDxVS_DefaultMassMorphMesh4(
    //vertex model
    float4 prm_posPrimary_Local       : POSITION0,  // f̒_
    float3 prm_vecNormalPrimary_Local : NORMAL0,    // f̒_̖@
    float2 prm_uv0                    : TEXCOORD0,  // f̒_UV
    float4 prm_posMorphTarget1_Local  : POSITION1,  // f̃[t^[Qbg1_
    float3 prm_vecNormal1_Local       : NORMAL1,    // f̃[t^[Qbg1_̖@
    float4 prm_posMorphTarget2_Local  : POSITION2,  // f̃[t^[Qbg2_
    float3 prm_vecNormal2_Local       : NORMAL2,    // f̃[t^[Qbg2_̖@
    float4 prm_posMorphTarget3_Local  : POSITION3,  // f̃[t^[Qbg3_
    float3 prm_vecNormal3_Local       : NORMAL3,    // f̃[t^[Qbg3_̖@
    float4 prm_posMorphTarget4_Local  : POSITION4,  // f̃[t^[Qbg4_
    float3 prm_vecNormal4_Local       : NORMAL4,    // f̃[t^[Qbg4_̖@
    //vertex instace data
    float4 prm_world0                 : TEXCOORD1,  // Worldsvf
    float4 prm_world1                 : TEXCOORD2,  // Worldsvf
    float4 prm_world2                 : TEXCOORD3,  // Worldsvf
    float4 prm_world3                 : TEXCOORD4,  // Worldsvf
    float4 prm_color                  : TEXCOORD5   // }eAJ[
) {
    //d݂oāAɖ߂
    float weight1 = prm_world0[3];
    float weight2 = prm_world1[3];
    float weight3 = prm_world2[3];
    float weight4 = prm_world3[3];
    prm_world0[3] = 0;
    prm_world1[3] = 0;
    prm_world2[3] = 0;
    prm_world3[3] = 1;
    //_@uh
    float4 posModel_Local = prm_posPrimary_Local;
    float3 vecNormal_Local = prm_vecNormalPrimary_Local;
    if (weight1 != 0) {
        posModel_Local  = lerp(posModel_Local , prm_posMorphTarget1_Local, weight1);
        vecNormal_Local = lerp(vecNormal_Local, prm_vecNormal1_Local     , weight1);
    }
    if (weight2 != 0) {
        posModel_Local  = lerp(posModel_Local , prm_posMorphTarget2_Local, weight2);
        vecNormal_Local = lerp(vecNormal_Local, prm_vecNormal2_Local     , weight2);
    }
    if (weight3 != 0) {
        posModel_Local  = lerp(posModel_Local , prm_posMorphTarget3_Local, weight3);
        vecNormal_Local = lerp(vecNormal_Local, prm_vecNormal3_Local     , weight3);
    }
    if (weight4 != 0) {
        posModel_Local  = lerp(posModel_Local , prm_posMorphTarget4_Local, weight4);
        vecNormal_Local = lerp(vecNormal_Local, prm_vecNormal4_Local     , weight4);
    }
    return GgafDxVS_DefaultMassMorphMesh(posModel_Local, vecNormal_Local, prm_uv0,
                                         prm_world0,
                                         prm_world1,
                                         prm_world2,
                                         prm_world3,
                                         prm_color  );
}


float4 GgafDxPS_DefaultMassMorphMesh(
    float2 prm_uv	           : TEXCOORD0,
    float4 prm_color           : COLOR0,
    float3 prm_vecNormal_World : TEXCOORD1,
    float3 prm_vecEye_World    : TEXCOORD2   //_ -> _ xNg
) : COLOR  {
    const float4 colTex2D   = tex2D( MyTextureSampler, prm_uv);

    float s = 0.0f; //XyL
    if (g_specular_power != 0) {
        //n[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNgj
        float3 vecHarf = normalize(prm_vecEye_World + (-g_vecLightFrom_World));
        //n[txNgƖ@̓ςXyLvZ
        s = pow( max(0.0f, dot(prm_vecNormal_World, vecHarf)), g_specular ) * g_specular_power;
    }
    float4 colOut = (colTex2D * prm_color) + s;
    //Blinkerl
    if (colTex2D.r >= g_tex_blink_threshold || colTex2D.g >= g_tex_blink_threshold || colTex2D.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power; //+ (colTex2D * g_tex_blink_power);
    }
    colOut.a = prm_color.a * g_alpha_master;
    return colOut;
}


float4 PS_Flush(
    float2 prm_uv	  : TEXCOORD0,
    float4 prm_color  : COLOR0
) : COLOR  {
    const float4 colTex2D  = tex2D( MyTextureSampler, prm_uv);
    float4 colOut = colTex2D * prm_color * FLUSH_COLOR;
    colOut *= g_alpha_master;
    return 	colOut;
}

//////////////////////////////////////////////////////////////////////////////
technique DefaultMassMorphMeshTechnique0
{
    //[t^[Qbg
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh0();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMassMorphMesh();
    }
}

technique DefaultMassMorphMeshTechnique1
{
    //[t^[Qbg1
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh1();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMassMorphMesh();
    }
}

technique DefaultMassMorphMeshTechnique2
{
    //[t^[Qbg2
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh2();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMassMorphMesh();
    }
}

technique DefaultMassMorphMeshTechnique3
{
    //[t^[Qbg3
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh3();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMassMorphMesh();
    }
}

technique DefaultMassMorphMeshTechnique4
{
    //[t^[Qbg4
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh4();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMassMorphMesh();
    }
}

//////////////////////////////////////////////////////////////////////////////
technique DestBlendOne0
{
    //[t^[Qbg
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh0();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMassMorphMesh();
    }
}

technique DestBlendOne1
{
    //[t^[Qbg1
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh1();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMassMorphMesh();
    }
}

technique DestBlendOne2
{
    //[t^[Qbg2
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh2();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMassMorphMesh();
    }
}

technique DestBlendOne3
{
    //[t^[Qbg3
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh3();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMassMorphMesh();
    }
}

technique DestBlendOne4
{
    //[t^[Qbg4
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh4();
        PixelShader  = compile PS_VERSION GgafDxPS_DefaultMassMorphMesh();
    }
}

//////////////////////////////////////////////////////////////////////////////
technique Flush0
{
    //[t^[Qbg
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh0();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}

technique Flush1
{
    //[t^[Qbg1
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh1();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}

technique Flush2
{
    //[t^[Qbg2
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh2();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}

technique Flush3
{
    //[t^[Qbg3
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh3();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}

technique Flush4
{
    //[t^[Qbg3
    pass P0 {
        AlphaBlendEnable = true;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        VertexShader = compile VS_VERSION GgafDxVS_DefaultMassMorphMesh4();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}

