#include "GgafEffectConst.fxh" 
float4x4 g_matWorld;  
float4x4 g_matView;   
float4x4 g_matProj;   

float3 g_vecLightFrom_World; 
float4 g_colLightAmbient;   
float4 g_colLightDiffuse;   

float4 g_colMaterialDiffuse;

float g_tex_blink_power;   
float g_tex_blink_threshold;
float g_alpha_master;
float g_zf;

sampler MyTextureSampler : register(s0);


struct OUT_VS
{
    float4 posModel_Proj    : POSITION;
	float2 uv     : TEXCOORD0;
	float4 color    : COLOR0;
};


OUT_VS GgafDxVS_GroundMesh(
      float4 prm_posModel_Local    : POSITION,      // f̒_
      float3 prm_vecNormal_Local : NORMAL,        // f̒_̖@
      float2 prm_uv     : TEXCOORD0      // f̒_UV
) {
	OUT_VS out_vs = (OUT_VS)0;

	//_vZ
	out_vs.posModel_Proj = mul( mul( mul(prm_posModel_Local, g_matWorld), g_matView), g_matProj);  //World*View*ˉeϊ
	//UV͂̂܂
	out_vs.uv = prm_uv;

    //_J[vZ

	//@ World ϊĐK
    const float3 vecNormal_World = normalize(mul(prm_vecNormal_Local, g_matWorld)); 	
    //@ƁADiffuseCg̓ςvZAʂɑ΂郉Cg̓ˊpɂ錸߂B
	const float power = max(dot(vecNormal_World, -g_vecLightFrom_World ), 0);      
	//AmbientCgFADiffuseCgFADiffuseCgA}eAF lJ[쐬B      
	out_vs.color = (g_colLightAmbient + (g_colLightDiffuse*power)) * g_colMaterialDiffuse;
	//tHO
	out_vs.color.a = g_colMaterialDiffuse.a;
    if (out_vs.posModel_Proj.z > 0.6*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
        out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
    }

 //J̈ʒu(0,0,-57.1259)
//͐E(-1.0f, -1.0f, 0 )Ƃ_(1.0f, 1.0f, 1,0f)Ƃ_ΊpƂ钼̂̐EɎ߂Ă܂Ă܂

//w͎ˉeԁiԁjɂ钸_WŊ邱Ƃɂ
//u_XN[ɓe邽߂̗̗̂̈i-1x1A-1y10z1jɔ[߂v
//Ƃ؂ȖڂĂ܂BwunvƌĂ΂̂́A
//̗̂悤ɎɃJ̎ɍLĂ钸_𓯂XYWɓe邽߂łB


	if ( out_vs.posModel_Proj.z < 60) {
		out_vs.color.a = (out_vs.posModel_Proj.z + 1.0)  / (57.1259*2);
//1 - (out_vs.posModel_Proj.z / 57.1259);
	}
	return out_vs;
}

float4 GgafDxPS_GroundMesh(
	float2 prm_uv	  : TEXCOORD0,
    float4 prm_color    : COLOR0
) : COLOR  {
	//eNX`TvOĐF擾iF擾j
	const float4 colTex = tex2D( MyTextureSampler, prm_uv);        
	float4 colOut = colTex * prm_color;

    //Blinkerl
	if (colTex.r >= g_tex_blink_threshold || colTex.g >= g_tex_blink_threshold || colTex.b >= g_tex_blink_threshold) {
		colOut *= g_tex_blink_power; //ă{|B_łڗB
	} 
	//}X^[
	colOut.a *= g_alpha_master;
	return colOut;
}


technique GroundMeshTechnique
{
	pass P0 {
		AlphaBlendEnable = true;
        //SeparateAlphaBlendEnable = true;
		SrcBlend  = SrcAlpha;
		DestBlend = InvSrcAlpha;
        //SrcBlendAlpha = One;      //default
        //DestBlendAlpha = Zero;    //default
		//BlendOpAlpha = Add;       //default
		VertexShader = compile VS_VERSION GgafDxVS_GroundMesh();
		PixelShader  = compile PS_VERSION GgafDxPS_GroundMesh();
	}
}

