#ifndef VAMSYSCAMWORKER_H_
#define VAMSYSCAMWORKER_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/actor/camera/worker/CameraWorker.h"

#include "jp/ggaf/dxcore/util/GgafDx26DirectionUtil.h"

#define VAM_POS_NON          DIR26( 0, 0, 0)
#define VAM_POS_ZRIGHT       DIR26( 0, 0,-1)
#define VAM_POS_ZRIGHT_UP    DIR26( 0,+1,-1)
#define VAM_POS_UP           DIR26( 0,+1, 0)
#define VAM_POS_ZLEFT_UP     DIR26( 0,+1,+1)
#define VAM_POS_ZLEFT        DIR26( 0, 0,+1)
#define VAM_POS_ZLEFT_DOWN   DIR26( 0,-1,+1)
#define VAM_POS_DOWN         DIR26( 0,-1, 0)
#define VAM_POS_ZRIGHT_DOWN  DIR26( 0,-1,-1)

namespace VioletVreath {

/**
 * VamSystem̃J} .
 * @version 1.00
 * @since 2010/10/25
 * @author Masatoshi Tsuge
 */
class VamSysCamWorker : public GgafLib::CameraWorker {

    /** [r/w]@ɑ΂YZʂɕsŉĂJ̃AOʒu */
    angle ang_cam_around_;
    /** [r]ang_cam_around_ ̏AOʒu */
    angle ang_cam_around_base_;
    /** [r]ang_cam_around_Aang_cam_around_base_Ɏ߂蒆ɁAtrue */
    bool returnning_cam_pos_;
    /** [r]ang_cam_around_Aang_cam_around_base_Ɏ߂₷(t[) */
    frame returnning_cam_pos_frames_;
    /** [r]ang_cam_around_ W̒萔ŕ\l(VAM_POS_XXXXX ) */
    dir26 pos_camera_;
    /** [r]pos_camera_̂Pt[O̕l(VAM_POS_XXXXX) */
    dir26 pos_camera_prev_;
    /** [r]ĴWʒu؂ւipos_camera_̒lωjȂtrue */
    bool is_just_changed_pos_cam_;
    /** [r/w]JȂ߂炩ړɔ₷t[ */
    frame cam_mv_frame_;
    /** [r]JȂ߂炩ړɔ₷t[̕Wl */
    frame cam_mv_frame_base_;

    coord DZC_;
    coord DXC_;
    coord DX2_C_;
    coord X_P_C_;

public:
    enum {
        SE_RETURNNING_CAM_POS     ,
    };
    MyShip* pMyShip_;
    GgafDxCore::GgafDxSeTransmitter* pSe_;

public:
    VamSysCamWorker(const char* prm_name, Camera* prm_pCamera);

    virtual void initialize() override;

    virtual void onActive() override;

    virtual void processBehavior() override;

    virtual void processJudgement() override {
    }
    inline dir26 getPosCam() {
        return pos_camera_;
    }
    inline bool isJustChangedPosCam() {
        return is_just_changed_pos_cam_;
    }
    virtual void onSwitchCameraWork() override;


    virtual ~VamSysCamWorker(); //fXgN^
};

}
#endif /*VAMSYSCAMWORKER_H_*/

