#ifndef ENEMYOEBIUSCORE_H_
#define ENEMYOEBIUSCORE_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/actor/DefaultMorphMeshActor.h"

#include "jp/ggaf/dxcore/util/GgafDxGeoElem.h"

namespace VioletVreath {

/**
 * GrEX̃RA .
 * @version 1.00
 * @since 2014/11/11
 * @author Masatoshi Tsuge
 */
class EnemyOebiusCore : public GgafLib::DefaultMorphMeshActor {

public:

    enum {
        PROG_INIT  ,
        PROG_ENTRY ,
        PROG_WAIT01 ,
        PROG_LEAVE ,
        PROG_BANPEI,
    };

    enum {
        SE_DAMAGED  ,
        SE_UNDAMAGED  ,
        SE_EXPLOSION,
        SE_FIRE,
    };

    EnemyOebiusController* pController_;

    /** tB[hCEtF[hAEgx */
    GgafDxCore::GgafDxAlphaFader* pAFader_;

public:
    /**
     * RXgN^
     * @param prm_name
     * @return
     */
    EnemyOebiusCore(const char* prm_name, EnemyOebiusController* prm_pController);

    void onCreateModel() override;

    /**
     * GrEX̏iCX^Xۏ؁j
     */
    void initialize() override;

    /**
     * GrEXANeBuɂȂuԂ̏ .
     */
    void onActive() override;

    /**
     * GrEX̐U镑 .
     */
    void processBehavior() override;

    /**
     * GrEX̐U镑̔菈 .
     */
    void processJudgement() override;

    /**
     * GrEX̏Փˎ .
     * @param prm_pOtherActor ՓˑΏ
     */
    void onHit(const GgafCore::GgafActor* prm_pOtherActor) override;


    void onInactive() override;


    virtual ~EnemyOebiusCore();
};

}
#endif /*ENEMYOEBIUSCORE_H_*/

