#ifndef ENEMYTHAGORAS_H_
#define ENEMYTHAGORAS_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/actor/DefaultMeshSetActor.h"

#include "jp/ggaf/dxcore/util/GgafDxGeoElem.h"

namespace VioletVreath {

/**
 * G@^SX .
 * gWbgxP
 * @version 1.00
 * @since 2013/07/10
 * @author Masatoshi Tsuge
 */
class EnemyThagoras : public GgafLib::DefaultMeshSetActor {

public:
    enum {
        SE_EXPLOSION ,
    };

    enum {
        PROG_INIT   ,
        PROG_ENTRY  ,
        PROG_MOVE01 ,
        PROG_LEAVE ,
        PROG_BANPEI,
    };

    /** tB[hCEtF[hAEgx */
    GgafDxCore::GgafDxAlphaFader* pAFader_;
    /** ړXvCvO */
    GgafLib::SplineKurokoLeader* pKurokoLeader_;
    /** ۓ(XP[)𓯊ׂ̃_~[AN^[ */
    GgafLib::DefaultGeometricActor* pActor4Sc_;

public:
    /**
     * RXgN^
     * @param prm_name
     * @return
     */
    EnemyThagoras(const char* prm_name);

    void onCreateModel() override;

    /**
     * ^SX̏iCX^Xۏ؁j
     */
    void initialize() override;

    /**
     * ^SXANeBuɂȂuԂ̏ .
     */
    void onActive() override;

    /**
     * ^SX̐U镑 .
     */
    void processBehavior() override;

    /**
     * ^SX̐U镑̔菈 .
     */
    void processJudgement() override;

    /**
     * ^SX̏Փˎ .
     * @param prm_pOtherActor ՓˑΏ
     */
    void onHit(const GgafCore::GgafActor* prm_pOtherActor) override;


    void onInactive() override;


    virtual ~EnemyThagoras();
};

}
#endif /*ENEMYTHAGORAS_H_*/

