#include "MyMagicEnergyCore.h"

#include "jp/ggaf/dxcore/actor/GgafDxFigureActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAxesMover.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/gecchi/VioletVreath/actor/my/MyMagicEnergy.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

#define MAX_SCALSE_MagicEnergyCore (R_SC(2))
MyMagicEnergyCore::MyMagicEnergyCore(const char* prm_name) :
        DefaultMeshActor(prm_name, "MagicEnergyCore", STATUS(MyMagicEnergyCore)) {
    _class_name = "MyMagicEnergyCore";
    pScaler_ = NEW GgafDxScaler(this);
    pAxsMver_ = NEW GgafDxAxesMover(this);
    MyMagicEnergy* p = NEW MyMagicEnergy("MyMagicEnergy", this);
    addSubLast(p);
    setAlpha(0.7);
}

void MyMagicEnergyCore::onCreateModel() {
    GgafDxModel* pModel = getModel();
    pModel->setSpecular(5.0, 1.0);
}

void MyMagicEnergyCore::initialize() {
    setHitAble(true);
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliSphere(0, 1);
}

void MyMagicEnergyCore::onActive() {
    pAxsMver_->execGravitationMvSequenceTwd(
                      P_MYSHIP,
                      +PX_C(90), 0, 0,
                      PX_C(10), 1000, PX_C(20));
}

void MyMagicEnergyCore::processBehavior() {
    double s = (P_MYSHIP->mp_ * (1.0 / MY_SHIP_MAX_MP));
    GgafDxKuroko* const pKuroko = getKuroko();
    //MPɘAđ傫Ȃ
    pScaler_->transitionLinearStep(
                s * MAX_SCALSE_MagicEnergyCore,
                100
             );
    CollisionChecker* pChecker = getCollisionChecker();
    if (s > 0.0) {
        pChecker->enable(0);
        pChecker->setColliSphere(0, s*PX_C(40));
    } else {
        pChecker->disable(0);
    }
    pScaler_->behave();
    pAxsMver_->behave();
    pKuroko->behave();
}

void MyMagicEnergyCore::processJudgement() {
}

int MyMagicEnergyCore::isOutOfView() {
    //ʊO薳
    return 0;
}

bool MyMagicEnergyCore::isOutOfSpacetime() const {
    //Q[W͈͊O薳
    return false;
}

MyMagicEnergyCore::~MyMagicEnergyCore() {
    GGAF_DELETE(pScaler_);
    GGAF_DELETE(pAxsMver_);
}
