#include "jp/ggaf/lib/manager/SplineManufactureManager.h"

#include "jp/ggaf/lib/GgafLibProperties.h"
#include "jp/ggaf/lib/manager/SplineManufactureConnection.h"
#include "jp/ggaf/lib/util/spline/FixedFrameSplineManufacture.h"
#include "jp/ggaf/lib/util/spline/FixedVelocitySplineManufacture.h"
#include "jp/ggaf/lib/util/spline/SteppedCoordSplineManufacture.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

SplineManufactureManager::SplineManufactureManager(const char* prm_manager_name) :
    GgafResourceManager<SplineManufacture> (prm_manager_name) {
}

SplineManufacture* SplineManufactureManager::processCreateResource(const char* prm_idstr, void* prm_pConnector) {
    _TRACE_("SplineManufactureManager::processCreateResource idstr="<<prm_idstr<<"");

    frame spent_frame = 0;
    angvelo angveloRzRyMv = 0;
    std::string classname = "";
    int turn_way = -1;
    bool turn_optimize = true;
    double rate_x = 1.0f;
    double rate_y = 1.0f;
    double rate_z = 1.0f;

    std::string id_str = std::string(prm_idstr);
    std::vector<std::string> spline_id = UTIL::split(id_str, "/"); // "FormationUrydike001/3"̂悤ɃXbV؂肪邩


    std::string spl_data_file="";
    std::string spl_filename = PROPERTY::DIR_SPLINE + spline_id[0] + ".spl";

    GgafStrMap mapSplPropperties;
    UTIL::readProperties(spl_filename, mapSplPropperties);

    if (UTIL::isExistKey("SPLINE", mapSplPropperties)) {
        if (spline_id.size() == 1) {
            //prm_idstr = "FormationUrydike001"
            std::string spl_data_file_csv = mapSplPropperties["SPLINE"];
            std::vector<std::string> vecSplineData = UTIL::split(spl_data_file_csv, ",");
#ifdef MY_DEBUG
            if (0 < vecSplineData.size()) {
                _TRACE_("x SplineManufactureManager::processCreateResource "<<prm_idstr<<" [SPLINE] ̓J}؂̔złAĂяo̓CfbNXw肵Ă܂BӐ}Ă܂H");
            }
#endif
            spl_data_file = vecSplineData[0];
        } else {
            //prm_idstr = "FormationUrydike001/3"
            //̂悤ɁA؂肪ꍇA
            //splt@C SPLINE
            //SPLINE=mobius1.dat,mobius2.dat,mobius3.dat,mobius4.dat
            //̂悤CSVŕw肵ĂāAXbV̌̐lCfbNXƂB
            std::string spl_data_file_csv = mapSplPropperties["SPLINE"];
            std::vector<std::string> vecSplineData = UTIL::split(spl_data_file_csv, ",");
            int i = STOI(spline_id[1]);
#ifdef MY_DEBUG
            if (i+1 > vecSplineData.size()) {
                throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" [SPLINE] ̔zvf"<<(vecSplineData.size())<<"łAwCfbNX"<<i<<"ׁ̈A͈͊OłB(e͈=0`"<<(vecSplineData.size()-1)<<")");
            }
            if (vecSplineData.size() == 1) {
                _TRACE_("x SplineManufactureManager::processCreateResource "<<prm_idstr<<" [SPLINE]̓J}؂̔zł͂܂񂪁AĂяo0Ԗڂ̃CfbNXwłBӐ}Ă܂H");
            }
#endif
            spl_data_file = vecSplineData[i];
        }
    } else {
        throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" [SPLINE] ͕K{łB");
    }
    if (spl_data_file.length() == 0) {
        throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" [SPLINE] w肳Ă܂B");
    }

    if (UTIL::isExistKey("MAG_X", mapSplPropperties)) {
        rate_x = atof(mapSplPropperties["MAG_X"].c_str());
    } else {
        rate_x = 1.0;
    }
    if (UTIL::isExistKey("MAG_Y", mapSplPropperties)) {
        rate_y = atof(mapSplPropperties["MAG_Y"].c_str());
    } else {
        rate_y = 1.0;
    }
    if (UTIL::isExistKey("MAG_Z", mapSplPropperties)) {
        rate_z = atof(mapSplPropperties["MAG_Z"].c_str());
    } else {
        rate_z = 1.0;
    }

    //CLASS
    enum SplineLeader {
        CLASS_FixedFrameSpline,
        CLASS_FixedVelocitySpline,
        CLASS_SteppedCoordSpline,
    } leader;

    if (UTIL::isExistKey("CLASS", mapSplPropperties)) {
        classname = mapSplPropperties["CLASS"];
        if (classname.length() == 0) {
            throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" [CLASS] w肳Ă܂B");
        }
    } else {
        throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" [CLASS] w肳Ă܂B");
    }

    if (classname.find("FixedFrameSpline") != std::string::npos) {
        leader = CLASS_FixedFrameSpline;
    } else if (classname.find("FixedVelocitySpline") != std::string::npos) {
        leader = CLASS_FixedVelocitySpline;
    } else if (classname.find("SteppedCoordSpline") != std::string::npos) {
        leader = CLASS_SteppedCoordSpline;
    } else {
        throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                "[CLASS]="<<classname<<" ͎wo܂B\ȃNX FixedFrameSpline/FixedVelocitySpline/SteppedCoordSpline ݂̂łB");
    }

    //SPENT_FRAME
    if (UTIL::isExistKey("SPENT_FRAME", mapSplPropperties)) {
        if (leader == CLASS_FixedFrameSpline) {
            spent_frame = (frame)atoi(mapSplPropperties["SPENT_FRAME"].c_str());
            if (spent_frame == 0) {
                throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                        "[SPENT_FRAME]  0 ͎wo܂B");
            }
        } else {
            throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                    "[CLASS]="<<classname<<" ̏ꍇ́A[SPENT_FRAME] ̎w͕słB(Rgɂďĉ)");
        }
    } else {
        if (leader == CLASS_FixedFrameSpline) {
            throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                    "[CLASS]="<<classname<<" ̏ꍇ́A[SPENT_FRAME] ̎w肪K{łB");
        }
    }

    //ANGLE_VELOCITY
    if (UTIL::isExistKey("ANGLE_VELOCITY", mapSplPropperties)) {
        if (leader == CLASS_FixedFrameSpline || leader == CLASS_FixedVelocitySpline) {
            angveloRzRyMv = (angvelo)atoi(mapSplPropperties["ANGLE_VELOCITY"].c_str());
            if (angveloRzRyMv == 0) {
                _TRACE_("x SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                        "[ANGLE_VELOCITY]  0 łBӐ}Ă܂H");
            }
        } else {
            throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                    "[CLASS]="<<classname<<" ̏ꍇ́A[ANGLE_VELOCITY] ̎w͕słB(Rgɂďĉ)");
        }
    } else {
        if (leader == CLASS_FixedFrameSpline || leader == CLASS_FixedVelocitySpline) {
            throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                    "[CLASS]="<<classname<<" ̏ꍇ́A[ANGLE_VELOCITY] ̎w肪K{łB");
        }
    }

    //TURN_WAY
    if (UTIL::isExistKey("TURN_WAY", mapSplPropperties)) {
        if (leader == CLASS_FixedFrameSpline || leader == CLASS_FixedVelocitySpline) {
            if (mapSplPropperties["TURN_WAY"] == "TURN_CLOSE_TO") {
                turn_way = TURN_CLOSE_TO;
            } else if (mapSplPropperties["TURN_WAY"] == "TURN_ANTICLOSE_TO") {
                turn_way = TURN_ANTICLOSE_TO;
            } else if (mapSplPropperties["TURN_WAY"] == "TURN_CLOCKWISE") {
                turn_way = TURN_CLOCKWISE;
            } else if (mapSplPropperties["TURN_WAY"] == "TURN_COUNTERCLOCKWISE") {
                turn_way = TURN_COUNTERCLOCKWISE;
            } else {
                throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                        "[TURN_WAY] ̒l('"<<mapSplPropperties["TURN_WAY"]<<"')słB\n" <<
                                           "TURN_CLOSE_TO/TURN_ANTICLOSE_TO/TURN_CLOCKWISE/TURN_COUNTERCLOCKWISE ̉ꂩw肵Ă");
            }
        } else {
            throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                    "[CLASS]="<<classname<<" ̏ꍇ́A[TURN_WAY] ̎w͕słB");
        }
    } else {
        if (leader == CLASS_FixedFrameSpline || leader == CLASS_FixedVelocitySpline) {
            throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                    "[CLASS]="<<classname<<" ̏ꍇ́A[TURN_WAY] ̎w肪K{łB");
        }
    }

    //TURN_OPTIMIZE
    if (UTIL::isExistKey("TURN_OPTIMIZE", mapSplPropperties)) {
        if (leader == CLASS_FixedFrameSpline || leader == CLASS_FixedVelocitySpline) {
            turn_optimize = UTIL::cnvBool(mapSplPropperties["TURN_OPTIMIZE"]);
        } else {
            throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                    "[CLASS]="<<classname<<" ̏ꍇ́A[TURN_OPTIMIZE] ̎w͕słB(Rgɂďĉ)");
        }
    } else {
        if (leader == CLASS_FixedFrameSpline || leader == CLASS_FixedVelocitySpline) {
            throwGgafCriticalException("SplineManufactureManager::processCreateResource "<<prm_idstr<<" : "<<
                    "[CLASS]="<<classname<<" ̏ꍇ́A[TURN_OPTIMIZE] ̎w肪K{łB");
        }
    }

    //SplineManufacture쐬
    SplineManufacture* pSplManuf = nullptr;
    if (leader == CLASS_FixedFrameSpline) {
        pSplManuf = NEW FixedFrameSplineManufacture(spl_data_file.c_str(),
                                                    spent_frame,
                                                    angveloRzRyMv,
                                                    turn_way,
                                                    turn_optimize);
    } else if (leader == CLASS_FixedVelocitySpline) {
        pSplManuf = NEW FixedVelocitySplineManufacture(spl_data_file.c_str(),
                                                       angveloRzRyMv,
                                                       turn_way,
                                                       turn_optimize);
    } else if (leader == CLASS_SteppedCoordSpline) {
        pSplManuf = NEW SteppedCoordSplineManufacture(spl_data_file.c_str());
    } else {
        throwGgafCriticalException("SplineManufactureManager::processCreateResource _classname="<<classname<< "͕sȃNXł");
    }
    pSplManuf->adjustAxisRate(rate_x, rate_y, rate_z); //gk
    pSplManuf->calculate(); //vZI

    return pSplManuf;
}

GgafResourceConnection<SplineManufacture>* SplineManufactureManager::processCreateConnection(const char* prm_idstr, SplineManufacture* prm_pResource) {
    _TRACE3_(" SplineManufactureManager::processCreateConnection "<<prm_idstr<<" 𐶐JnB");
    SplineManufactureConnection* pConne = NEW SplineManufactureConnection(prm_idstr, prm_pResource);
    _TRACE3_(" SplineManufactureManager::processCreateConnection "<<prm_idstr<<" 𐶐IB");
    return pConne;
}

