#ifndef ENEMYAPPHO_H_
#define ENEMYAPPHO_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/actor/DefaultMeshSetActor.h"

#include "jp/ggaf/dxcore/util/GgafDxGeoElem.h"

namespace VioletVreath {

/**
 * G@Ab|[ .
 * A˂UWK̎Ĝ悤ɁA
 * āAڂ̑OɃX[ƗāA
 * ƃEEāAX[ƓB
 * @version 1.00
 * @since 2013/03/18
 * @author Masatoshi Tsuge
 */
class EnemyAppho : public GgafLib::DefaultMeshSetActor {

public:
    enum {
        SE_EXPLOSION ,
    };

    enum {
        PROG_INIT   ,
        PROG_ENTRY  ,
        PROG_MOVE01 ,
        PROG_MOVE02 ,
        PROG_MOVE03 ,
        PROG_MOVE04 ,
        PROG_BANPEI ,
    };

    /** tB[hCEtF[hAEgx */
    GgafDxCore::GgafDxAlphaFader* pAFader_;
    /** [r]oW(tH[[VIuWFNgݒ) */
    GgafDxCore::GgafDxGeoElem entry_pos_;
    /** [r]EEW(tH[[VIuWFNgݒ) */
    GgafDxCore::GgafDxGeoElem hanging_pos_;
    /** [r]ޏoW(tH[[VIuWFNgݒ) */
    GgafDxCore::GgafDxGeoElem leave_pos_;
public:
    /**
     * RXgN^
     * @param prm_name
     * @return
     */
    EnemyAppho(const char* prm_name);

    void onCreateModel() override;

    /**
     * Ab|[̏iCX^Xۏ؁j
     */
    void initialize() override;

    /**
     * Ab|[̂ANeBuɂȂuԂ̏ .
     */
    void onActive() override;

    /**
     * Ab|[̐U镑 .
     */
    void processBehavior() override;

    /**
     * Ab|[̐U镑̔菈 .
     */
    void processJudgement() override;

    /**
     * Ab|[̏Փˎ .
     * @param prm_pOtherActor ՓˑΏ
     */
    void onHit(GgafCore::GgafActor* prm_pOtherActor) override;


    void onInactive() override;


    virtual ~EnemyAppho();
};

}
#endif /*ENEMYAPPHO_H_*/

