#ifndef COMMONSCENE_H_
#define COMMONSCENE_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/scene/DefaultScene.h"

#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene.h"

#ifdef P_GAME_SCENE
    #define P_COMMON_SCENE (P_GAME_SCENE->pCommonScene_)
#else
    #undef P_COMMON_SCENE
#endif

/**
 * ʃIuWFNg擾}N
 */
#define P_COMMON_DEPO(X)                   pDepo_##X##_
#define getCommonDepository(X)             (P_COMMON_SCENE->P_COMMON_DEPO(X))
#define dispatchFromCommon(X)              ( (X*)(getCommonDepository(X)->dispatch()) )
#define dispatchDelayFromCommon(X, F)      ( (X*)(getCommonDepository(X)->dispatch((F))) )
#define dispatchForceFromCommon(X)         ( (X*)(getCommonDepository(X)->dispatchForce()) )

#define P_COMMON_STORE(X)                   pStore_##X##_

namespace VioletVreath {

/**
 * ʃV[NX .
 * Ȏd͎̃Xe[W肷邱ƂłB
 * @version 1.00
 * @since 2008/09/08
 * @author Masatoshi Tsuge
 */
class CommonScene : public GgafLib::DefaultScene {

public:
    /** ėpGtFNĝPpAf|Wg */

    GgafCore::GgafActorDepository* const P_COMMON_DEPO(EffectExplosion001);
    /** ėpGtFNĝQpAf|Wg */
    GgafCore::GgafActorDepository* const P_COMMON_DEPO(EffectExplosion002);
    /** ėpGtFNĝRpAf|Wg */
    GgafCore::GgafActorDepository* const P_COMMON_DEPO(EffectExplosion003);
    /** ėpGtFNĝSpAf|Wg */
    GgafCore::GgafActorDepository* const P_COMMON_DEPO(EffectExplosion004);
    /** ^[{GtFNgpAf|Wg */
    GgafCore::GgafActorDepository* const P_COMMON_DEPO(EffectTurbo002);
    /** ACeIuWFNgAf|Wg */
    GgafCore::GgafActorDepository* const P_COMMON_DEPO(MagicPointItem001);
    /** ACeIuWFNgAf|Wg */
    GgafCore::GgafActorDepository* const P_COMMON_DEPO(MagicPointItem002);
    /** ACeIuWFNgAf|Wg */
    GgafCore::GgafActorDepository* const P_COMMON_DEPO(MagicPointItem003);

    /** ėpoGtFNĝPpAf|Wg */
    GgafCore::GgafActorDepository* const P_COMMON_DEPO(EffectEntry001);
    /** ėpoGtFNĝQpAf|Wg */
    GgafCore::GgafActorDepository* const P_COMMON_DEPO(EffectEntry002);
    /** ėpoGtFNĝRpAf|Wg */
    GgafCore::GgafActorDepository* const P_COMMON_DEPO(EffectEntry003);

    GgafCore::GgafActorDepository* const P_COMMON_DEPO(SpriteLabelBonus001);

    /** ėpoGtFNĝRpAf|Wg */
    GgafCore::GgafActorDepository* const P_COMMON_DEPO(Shot004);

    /**  */
    GgafCore::GgafActorDepositoryStore* const pStore_EnemyWateringLaser001_;
    GgafCore::GgafActorDepositoryStore* const pStore_EnemyStraightLaser001_;

public:
    CommonScene(const char* prm_name);
    /**
     * 
     */
    void initialize() override;
    void onReset() override;

    virtual void processBehavior() override;

    virtual ~CommonScene();
};

}
#endif /*COMMONSCENE_H_*/
