﻿/*@@@*
The MIT License (MIT)

Copyright (c) 2013 GMA0BN

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
**@@@*/
#include "stdafx.h"
#include "sockutil.h"

#undef NUMELEMS
#define NUMELEMS(a)     (sizeof(a) / sizeof(a[0]))

#define NCOLUMNS        16

/// sockaddr構造体の中身をダンプします。
BOOL dump_sockaddr(FILE* fp, struct sockaddr* p, size_t addrlen, const char* indent)
{
    int j;
    BOOL suc;
    size_t k, ofs;

    suc = TRUE;

    ofs = p->sa_data - (char*)p;
    if (addrlen == 0) {
        addrlen = sizeof(p->sa_data);
    } else {
        addrlen -= ofs;
    }

    // sa_familyフィールド
    fputs(indent, fp);
    fprintf(fp, "sa_family=0x%08x (", p->sa_family);
    if (!decode_addr_family(fp, p->sa_family)) {
        suc = FALSE;
    }
    fputs(")\n", fp);

    // sa_dataフィールド
    for (k = 0; k < addrlen; ) {
        fputs(indent, fp);
        for (j = 0; j < NCOLUMNS && k < addrlen; ++j) {
            if (j > 0) fputs(" ", fp);
            fprintf(stderr, "%02x", p->sa_data[k] & 0xff);
            ++k;
        }
        fputs("\n", fp);
    }

    return !ferror(fp) && suc;
}
