﻿/*@@@*
The MIT License (MIT)

Copyright (c) 2013 GMA0BN

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
**@@@*/
#pragma once

#define MAXLISTEN   FD_SETSIZE
#define MAXACCEPT   2048

#ifdef __cplusplus
extern "C" {
#endif

/// サーバ機能を初期化します。
extern void init_sockutil_sv(void);

/// サーバ機能を後始末します。
extern void term_sockutil_sv(void);

/// サーバ側セッションのコントロールブロック。
typedef struct tagServerCB {
    SessionRes res;
    unsigned sessionID;
    char hostName[NI_MAXHOST];
    struct sockaddr_storage from;
    unsigned (__stdcall *startAddress)(void* exinf);
    void* exinf2;
} ServerCB;

/// 指定したサービスのlistenを開始します。
extern int start_listen(PCSTR pServiceName, SOCKET s[], int n);
/*= Return value:
 *      Negative value: Error
 *      Otherwise: Number of sockets to listen
 *                 (Always it <= n. Exceeded sockets are closed.)
 */

/// 接続を待ち受け、接続されればセッションを開始します。
extern int wait_connection(
    const SOCKET s[],
    int n,
    DWORD TCTmoIn_ms,
    unsigned (__stdcall *startAddress)(void* exinf)
);
/*= Return value:
 *      0: Timeout
 *      1: Succeeded (Connected)
 *      Negative value: Error
 */

/// 全セッションの完了を待ちます。
extern BOOL wait_completion_all(void);
/*= Return value:
 *      TRUE:   Succeeded
 *      FALSE:  Failed
 */

#ifdef __cplusplus
}
#endif
