﻿/*@@@*
The MIT License (MIT)

Copyright (c) 2013 GMA0BN

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
**@@@*/
#include "stdafx.h"
#include "TestClient.h"

#define SHOW_ECHOBACK       1

static CRITICAL_SECTION g_syncRoot_session_cl;

/// セッションスレッドモジュールを初期化します。
void init_session_cl(void)
{
    InitializeCriticalSection(&g_syncRoot_session_cl);
}

/// セッションスレッドモジュールの後始末を行います。
void term_session_cl(void)
{
    DeleteCriticalSection(&g_syncRoot_session_cl);
}

/// セッションスレッドのサンプルです。(Client側。)
unsigned __stdcall SessionThreadFunc(void* exinf)
{
    BOOL suc;
    ClientCB* p;
    int i, j, n, r, nRet;
    char sendBuf[64];
    char recvBuf[64];
    int scnt;

    p = (ClientCB*)exinf;
    n = (int)(p->exinf2);

    suc = TRUE;

    // グリーティングメッセージをスキップ
    EnterCriticalSection(&g_syncRoot_session_cl);
    do {
        nRet = recv(p->res.socket, recvBuf, 1, 0);
        if (nRet < 0) {
            int err = WSAGetLastError();
            fprintf(stderr, "\nERROR: " __FUNCTION__ ": recv() failed. (err=%d)\n", err);
            suc = FALSE;
            break;
        } else if (nRet == 0) {
            fprintf(stderr, "\nERROR: " __FUNCTION__ ": Connection closed. (err=%d)\n");
            suc = FALSE;
            break;
        }
        fputc(recvBuf[0], stdout);
    } while (recvBuf[0] != '\n');
    LeaveCriticalSection(&g_syncRoot_session_cl);
    if (!suc) {
        goto last;
    }

    // 送受信テスト
    for (i = 0; i < n; ++i) {
        // 送信データ準備
        r = rand_safe() % (CHAR_MAX + 1);
        if (isprint(r)) {
            sendBuf[0] = (char)r;
            scnt = 1;
        } else {
            scnt = sprintf_s(sendBuf, sizeof(sendBuf), "%02x", r);
            if (scnt <= 0) {
                perror(__FUNCTION__);
                suc = FALSE;
                goto last;
            }
        }

        // 送信
        for (j = 0; j < scnt; ) {
            nRet = send(p->res.socket, sendBuf + j, scnt - j, 0);
            if (nRet < 0) {
                int err = WSAGetLastError();
                fprintf(stderr, "\nERROR: " __FUNCTION__ ": send() failed. (err=%d)\n", err);
                suc = FALSE;
                goto last;
            } else if (nRet == 0) {
                fprintf(stderr, "\nERROR: " __FUNCTION__ ": send() returned 0. (Connection closed?)\n");
                suc = FALSE;
                goto last;
            }
            j += nRet;
        }

        // 受信
        memset(recvBuf, 0, sizeof(recvBuf));
        for (j = 0; j < scnt; ) {
            nRet = recv(p->res.socket, recvBuf + j, scnt - j, 0);
            if (nRet < 0) {
                int err = WSAGetLastError();
                fprintf(stderr, "\nERROR: " __FUNCTION__ ": recv() failed. (err=%d)\n", err);
                suc = FALSE;
                goto last;
            } else if (nRet == 0) {
                fprintf(stderr, "\nERROR: " __FUNCTION__ ": Connection closed.\n");
                suc = FALSE;
                goto last;
            }
            j += nRet;
        }
#if SHOW_ECHOBACK
        printf("%s", recvBuf);
#endif

        // 照合
        if (memcmp(recvBuf, sendBuf, scnt) != 0) {
            fprintf(stderr, "\nERROR: " __FUNCTION__ ": Data mismatch.\n");
            suc = FALSE;
            goto last;
        }
    }
last:

    // 終了通知
    nRet = send(p->res.socket, "\rbye\r", 5, 0);
    if (nRet <= 0) {
        suc = FALSE;
    }

    return suc;
}
