/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2009-2011  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                2010-2011  hkrn (libMMDAI)                         */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the MMDAgent project team nor the names of  */
/*   its contributors may be used to endorse or promote products     */
/*   derived from this software without specific prior written       */
/*   permission.                                                     */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef MMDAI_PMDRENDERENGINE_H_
#define MMDAI_PMDRENDERENGINE_H_

namespace MMDAI {

class BulletPhysics;
class PMDBone;
class PMDMaterial;
class PMDModel;

typedef struct PMDTextureNative PMDTextureNative;

class PMDRenderEngine {
public:
    virtual ~PMDRenderEngine() {}
    virtual void renderRigidBodies(BulletPhysics *bullet) = 0;
    virtual void renderBone(PMDBone *bone) = 0;
    virtual void renderBones(PMDModel *model) = 0;
    virtual void renderModel(PMDModel *model) = 0;
    virtual void renderEdge(PMDModel *model) = 0;
    virtual void renderShadow(PMDModel *model) = 0;
    virtual PMDMaterial **allocateMaterials(int size) = 0;
    virtual void releaseMaterials(PMDMaterial **materials, int size) = 0;
    virtual PMDTextureNative *allocateTexture(const unsigned char *data,
                                              const int width,
                                              const int height,
                                              const int components) = 0;
    virtual void releaseTexture(PMDTextureNative *native) = 0;
};

} /* namespace */

#endif
