/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2010-2011  hkrn                                    */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the MMDAI project team nor the names of     */
/*   its contributors may be used to endorse or promote products     */
/*   derived from this software without specific prior written       */
/*   permission.                                                     */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef QMAMODELLOADERFACTORY_H
#define QMAMODELLOADERFACTORY_H

#include <MMDAI/IResourceFactory.h>
#include "QMAModelLoader.h"

namespace MMDAI {
class IPreference;
}

class QMAModelLoaderFactory : public MMDAI::IResourceFactory
{
public:
    QMAModelLoaderFactory(MMDAI::IPreference *preference);
    ~QMAModelLoaderFactory();

    MMDAI::IModelLoader *createModelLoader(const char *filename);
    MMDAI::IMotionLoader *createMotionLoader(const char *filename);
    MMDAI::ILipSyncLoader *createLipSyncLoader(const char *filename);
    void releaseModelLoader(MMDAI::IModelLoader *loader);
    void releaseMotionLoader(MMDAI::IMotionLoader *loader);
    void releaseLipSyncLoader(MMDAI::ILipSyncLoader *loader);

private:
    QMAModelLoader *createLoader(const char *filename);

    MMDAI::IPreference *m_preference;

    Q_DISABLE_COPY(QMAModelLoaderFactory)
};

#endif // QMAMODELLOADERFACTORY_H
