/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2009-2011  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                2010-2012  hkrn                                    */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the MMDAI project team nor the names of     */
/*   its contributors may be used to endorse or promote products     */
/*   derived from this software without specific prior written       */
/*   permission.                                                     */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef VPVL_IK_H_
#define VPVL_IK_H_

#include "vpvl/Bone.h"

namespace vpvl
{

/**
 * @file
 * @author Nagoya Institute of Technology Department of Computer Science
 * @author hkrn
 *
 * @section DESCRIPTION
 *
 * IK class represents a Inverse Kinematics of a Polygon Model Data object.
 */

class VPVL_API IK
{
public:
    IK();
    ~IK();

    static size_t totalSize(const uint8_t *data, size_t rest, size_t count, bool &ok);
    static size_t stride(const uint8_t *data);

    void read(const uint8_t *data, BoneList *bones);
    size_t estimateSize() const;
    void write(uint8_t *data) const;
    void solve();
    bool isSimulated() const;

    Bone *destinationBone() const {
        return m_destination;
    }
    Bone *targetBone() const {
        return m_target;
    }
    const BoneList &linkedBones() const {
        return m_bones;
    }

    void setBones(Bone *destination, Bone *target, const BoneList &boneIKs);
    void setAngleConstraint(float value);
    void setIterationSize(uint16_t value);

private:
    Bone *m_destination;
    Bone *m_target;
    BoneList m_bones;
    uint16_t m_iteration;
    float m_angleConstraint;
    float m_rawAngleConstraint;

    VPVL_DISABLE_COPY_AND_ASSIGN(IK)
};

typedef Array<IK*> IKList;

} /* namespace vpvl */

#endif
