//
//  args.c
//  chncpu
//
//  Created by 西田　耀 on 2014/07/05.
//  Copyright (c) 2014年 CHNOSProject. All rights reserved.
//

#include "chncpu.h"

CHNCPU_VMArgs *bindVMArgs(int argc, const char *argv[])
{
	int nextIndex = 1;
	const char *s;
	CHNCPU_VMArgs *args = malloc(sizeof(CHNCPU_VMArgs));
	CHNCPU_VMArgs_BindDataTag *bdTag;
	if(!args){
		puts("bindVMArgs: malloc error.");
        exit(EXIT_FAILURE);
	}
	
	args->appPath = NULL;
	args->VMFlags = 0;
	args->bindDatas = 0;
	
	for(; nextIndex < argc;){
		s = CHNCPU_VMArgs_GetNextAsString(argc, argv, &nextIndex);
		if(strcmp("-e", s) == 0){
			args->appPath = CHNCPU_VMArgs_GetNextAsString(argc, argv, &nextIndex);
		} else if(strcmp("-f", s) == 0){
			s = CHNCPU_VMArgs_GetNextAsString(argc, argv, &nextIndex);
			for(;*s != '\0'; s++){
				if(*s == 'i'){
					args->VMFlags |= CHNCPU_VM_FLAG_PRINT_INFO;
				} else{
					printf("bindVMArgs: unknown flag %c.\n", *s);
					argc = 0;
					continue;
				}
			}
		} else if(strcmp("-bd", s) == 0){
			if(args->bindDatas < sizeof(args->bindData)){
				bdTag = &args->bindData[args->bindDatas];
				bdTag->pReg = CHNCPU_VMArgs_GetNextAsPRegNum(argc, argv, &nextIndex);
				bdTag->iReg = CHNCPU_VMArgs_GetNextAsIRegNum(argc, argv, &nextIndex);
				bdTag->pType = CHNCPU_VMArgs_GetNextAsSignedHexValue(argc, argv, &nextIndex);
				bdTag->flags = CHNCPU_VMArgs_GetNextAsUnsignedHexValue(argc, argv, &nextIndex);
				bdTag->filePath = CHNCPU_VMArgs_GetNextAsString(argc, argv, &nextIndex);
				bdTag->data = CHNCPU_DATA_CreateDataFromFileAsPType(bdTag->filePath, bdTag->pType);
				if(bdTag->pReg < 0 || bdTag->iReg < 0 || bdTag->flags < 0 || (bdTag->flags == 0 && !bdTag->data)){
					puts("Invalid data option (-bd) args.");
					argc = 0;
					continue;
				} else{
					args->bindDatas++;
				}
			} else{
				puts("Too many bind data options (-bd).");
				argc = 0;
				continue;
			}
		} else{
			argc = 0;
			continue;
		}
	}
	
	if(argc < 3){
        puts("chncpu:Usage > chncpu [-e appPath] [-f flags] [-bd PRegID IRegID PType flags dataPath]");
        exit(EXIT_FAILURE);
    }
	
	return args;
}

int CHNCPU_VMArgs_BindDataToRuntimeEnv(CHNCPU_RuntimeEnvironment *env, CHNCPU_VMArgs *args)
{
	CHNCPU_VMArgs_BindDataTag *bdTag;
	int i;
	
	for(i = 0; i < args->bindDatas; i++){
		bdTag = &args->bindData[i];
		if(bdTag->flags != 0){
			continue;
		}
		// データサイズを指定されたIRegに格納
		env->iReg[bdTag->iReg] = bdTag->data->count;
		env->iRegBits[bdTag->iReg] = CHNCPU_BITS_MAX;
		// データタグを指定されたPRegに格納
		CHNCPU_DATA_AssignDataTagToPReg(env, bdTag->pReg, bdTag->data);
	}
	
	return 0;
}

int CHNCPU_VMArgs_BindDataFromRuntimeEnv(CHNCPU_RuntimeEnvironment *env, CHNCPU_VMArgs *args)
{
	CHNCPU_VMArgs_BindDataTag *bdTag;
	int i;
	
	for(i = 0; i < args->bindDatas; i++){
		bdTag = &args->bindData[i];
		if(bdTag->flags != 1){
			continue;
		}
		CHNCPU_DATA_WriteRawDataToFile(env->pReg[bdTag->pReg].data, bdTag->filePath, env->iReg[bdTag->iReg], bdTag->pType);
	}
	
	return 0;
}

const char *CHNCPU_VMArgs_GetNextAsString(int argc, const char *argv[], int *nextIndex)
{
	const char *s;
	if(*nextIndex < argc){
		s = argv[*nextIndex];
		(*nextIndex)++;
		return s;
	}
	return NULL;
}

int CHNCPU_VMArgs_GetNextAsPRegNum(int argc, const char *argv[], int *nextIndex)
{
	int regNum;
	
	regNum = CHNCPU_VMArgs_GetNextAsUnsignedHexValue(argc, argv, nextIndex);
	if(regNum >= 0){
		if(regNum < CHNCPU_NUMBER_OF_PREG){
			return regNum;
		}
		(*nextIndex)--;
	}
	return -1;
}

int CHNCPU_VMArgs_GetNextAsIRegNum(int argc, const char *argv[], int *nextIndex)
{
	int regNum;
	
	regNum = CHNCPU_VMArgs_GetNextAsUnsignedHexValue(argc, argv, nextIndex);
	if(regNum >= 0){
		if(regNum < CHNCPU_NUMBER_OF_IREG){
			return regNum;
		}
		(*nextIndex)--;
	}
	return -1;
}

int CHNCPU_VMArgs_GetNextAsUnsignedHexValue(int argc, const char *argv[], int *nextIndex)
{
	int val;
	char *p;
	
	if(*nextIndex < argc){
		val = (int)strtol(argv[*nextIndex], &p, 16);
		if(argv[*nextIndex] == p || *p != '\0' || val < 0){
			return -1;
		}
		(*nextIndex)++;
		return val;
	}
	return -1;
}

int CHNCPU_VMArgs_GetNextAsSignedHexValue(int argc, const char *argv[], int *nextIndex)
{
	int val;
	char *p;
	
	if(*nextIndex < argc){
		val = (int)strtol(argv[*nextIndex], &p, 16);
		if(argv[*nextIndex] == p || *p != '\0'){
			return 0;
		}
		(*nextIndex)++;
		return val;
	}
	return 0;
}
