//
//  ch4.h
//  chncpu
//
//  Created by 西田　耀 on 2014/06/04.
//  Copyright (c) 2014年 CHNOSProject. All rights reserved.
//

#ifndef chncpu_ch4_h
#define chncpu_ch4_h

#include <stdio.h>

typedef struct CH4_READER CH4Reader;
struct CH4_READER {
    const unsigned char *rawData;
    int rawDataLength;
    unsigned int errorFlags;
	int phase;
	int rp; // per 4bit
	unsigned int lastBits;
};

typedef unsigned int ch4_uint;
typedef int ch4_sint;

#define CH4_TYPE_UINT		0
#define CH4_TYPE_SINT		1
#define CH4_TYPE_FLOAT		2
#define CH4_TYPE_TEXT		3
#define CH4_TYPE_ARRAY		4
#define CH4_TYPE_OBJECT		5
#define CH4_TYPE_BYTE		6

#define CH4_READ_ERROR_INVALID_INDEX    1;
#define CH4_READ_ERROR_TRAP_PADDING		2;
#define CH4_READ_ERROR_NOT_SUPPORTED		4;


int CH4Reader_Initialize(CH4Reader *reader, const unsigned char *rawData, int rawDaraLength);
int CH4Reader_Internal_Read4bitAtIndex(CH4Reader *reader, int index);
ch4_uint CH4Reader_ReadNextAsUINT(CH4Reader *reader);
ch4_sint CH4Reader_ReadNextAsSINT(CH4Reader *reader);
unsigned int CH4Reader_ReadNextUINTn(CH4Reader *reader, unsigned int n);
int CH4Reader_SignExtend(int value, unsigned int baseBits);
int CH4Reader_SkipNextPadding(CH4Reader *reader);
int CH4Reader_IsEndOfBinary(CH4Reader *reader);
ch4_uint CH4Reader_ReadBodyAtIndexAsUINT(CH4Reader *reader, int index, int *retReadIndex);
ch4_uint CH4Reader_ReadBodyAtIndexAsUINT_prefix_ext(CH4Reader *reader, int index, int *retReadIndex);
ch4_uint CH4Reader_ReadBodyAtIndexAsUINT_prefix_ext(CH4Reader *reader, int index, int *retReadIndex);

#endif
