﻿using MikuMikuPlugin;
using System.Windows.Forms;

namespace MMM_GraphEditor
{
    partial class GraphEditorControl
    {
        /// <summary> 
        /// 必要なデザイナー変数です。
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        /// <summary> 
        /// 使用中のリソースをすべてクリーンアップします。
        /// </summary>
        /// <param name="disposing">マネージ リソースが破棄される場合 true、破棄されない場合は false です。</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
                this.scene = null;
            }
            base.Dispose(disposing);
        }

        protected override void OnLoad(System.EventArgs e)
        {
            base.OnLoad(e);
            this.Dock = System.Windows.Forms.DockStyle.Fill;
            UpdateUIStateByConfig();
        }

        public void UpdateUIStateByConfig()
        {
            chk_track_merker.Checked = config.track_marker;
            chk_track_yzero.Checked = config.track_yzero;
            chk_edit_pos.Checked = config.edit_flags[GraphPort.IDX_EDIT_POS];
            chk_edit_pos_ip.Checked = config.edit_flags[GraphPort.IDX_EDIT_POS_IP];
            chk_edit_rot.Checked = config.edit_flags[GraphPort.IDX_EDIT_ROT];
            chk_plot_pos_x.Checked = config.render_flags[GraphPort.IDX_POS_X];
            chk_plot_pos_y.Checked = config.render_flags[GraphPort.IDX_POS_Y];
            chk_plot_pos_z.Checked = config.render_flags[GraphPort.IDX_POS_Z];
            chk_plot_rot_x.Checked = config.render_flags[GraphPort.IDX_ROT_R];
            chk_plot_rot_y.Checked = config.render_flags[GraphPort.IDX_ROT_P];
            chk_plot_rot_z.Checked = config.render_flags[GraphPort.IDX_ROT_Y];
            radio_zxy.Checked = radio_xzy.Checked = radio_xyz.Checked = false;
            switch (config.euler_rot_order)
            {
                case 1:
                    radio_xyz.Checked = true;
                    break;
                case 2:
                    radio_xzy.Checked = true;
                    break;
                default:
                    radio_zxy.Checked = true;
                    break;
            }
        }

        protected override void OnResize(System.EventArgs e)
        {
            base.OnResize(e);
            graphPanelOuter.Width = ClientSize.Width - 60;
            graphPanelOuter.Height = ClientSize.Height;
            graphPort1.fitSize();
            this.Refresh();
        }

        #region コンポーネント デザイナーで生成されたコード

        /// <summary> 
        /// デザイナー サポートに必要なメソッドです。このメソッドの内容を 
        /// コード エディターで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            this.btn_plus = new System.Windows.Forms.Button();
            this.btn_minus = new System.Windows.Forms.Button();
            this.chk_plot_pos_x = new System.Windows.Forms.CheckBox();
            this.chk_plot_pos_y = new System.Windows.Forms.CheckBox();
            this.chk_plot_pos_z = new System.Windows.Forms.CheckBox();
            this.chk_plot_rot_x = new System.Windows.Forms.CheckBox();
            this.chk_plot_rot_y = new System.Windows.Forms.CheckBox();
            this.chk_plot_rot_z = new System.Windows.Forms.CheckBox();
            this.radio_zxy = new System.Windows.Forms.RadioButton();
            this.radio_xyz = new System.Windows.Forms.RadioButton();
            this.radio_xzy = new System.Windows.Forms.RadioButton();
            this.btn_center = new System.Windows.Forms.Button();
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.chk_track_merker = new System.Windows.Forms.CheckBox();
            this.chk_track_yzero = new System.Windows.Forms.CheckBox();
            this.chk_edit_pos = new System.Windows.Forms.CheckBox();
            this.chk_edit_pos_ip = new System.Windows.Forms.CheckBox();
            this.chk_edit_rot = new System.Windows.Forms.CheckBox();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.label4 = new System.Windows.Forms.Label();
            this.graphPanelOuter = new MMM_GraphEditor.GraphPanel();
            this.frameRuler1 = new MMM_GraphEditor.FrameRuler();
            this.graphPanelInnner = new MMM_GraphEditor.GraphPanel();
            this.graphPort1 = new MMM_GraphEditor.GraphPort();
            this.graphPanelOuter.SuspendLayout();
            this.graphPanelInnner.SuspendLayout();
            this.SuspendLayout();
            // 
            // btn_plus
            // 
            this.btn_plus.Location = new System.Drawing.Point(18, 0);
            this.btn_plus.Name = "btn_plus";
            this.btn_plus.Size = new System.Drawing.Size(16, 23);
            this.btn_plus.TabIndex = 2;
            this.btn_plus.Text = "+";
            this.toolTip1.SetToolTip(this.btn_plus, "グラフを拡大");
            this.btn_plus.UseVisualStyleBackColor = true;
            this.btn_plus.Click += new System.EventHandler(this.btn_plus_Click);
            // 
            // btn_minus
            // 
            this.btn_minus.Location = new System.Drawing.Point(37, 0);
            this.btn_minus.Name = "btn_minus";
            this.btn_minus.Size = new System.Drawing.Size(16, 23);
            this.btn_minus.TabIndex = 3;
            this.btn_minus.Text = "-";
            this.toolTip1.SetToolTip(this.btn_minus, "グラフを縮小");
            this.btn_minus.UseVisualStyleBackColor = true;
            this.btn_minus.Click += new System.EventHandler(this.btn_minus_Click);
            // 
            // chk_plot_pos_x
            // 
            this.chk_plot_pos_x.Appearance = System.Windows.Forms.Appearance.Button;
            this.chk_plot_pos_x.Checked = true;
            this.chk_plot_pos_x.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chk_plot_pos_x.Location = new System.Drawing.Point(0, 156);
            this.chk_plot_pos_x.Name = "chk_plot_pos_x";
            this.chk_plot_pos_x.Size = new System.Drawing.Size(18, 23);
            this.chk_plot_pos_x.TabIndex = 10;
            this.chk_plot_pos_x.Text = "X";
            this.chk_plot_pos_x.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chk_plot_pos_x.UseVisualStyleBackColor = true;
            this.chk_plot_pos_x.CheckedChanged += new System.EventHandler(this.btn_pos_x_CheckedChanged);
            // 
            // chk_plot_pos_y
            // 
            this.chk_plot_pos_y.Appearance = System.Windows.Forms.Appearance.Button;
            this.chk_plot_pos_y.Checked = true;
            this.chk_plot_pos_y.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chk_plot_pos_y.Location = new System.Drawing.Point(17, 156);
            this.chk_plot_pos_y.Name = "chk_plot_pos_y";
            this.chk_plot_pos_y.Size = new System.Drawing.Size(18, 23);
            this.chk_plot_pos_y.TabIndex = 11;
            this.chk_plot_pos_y.Text = "Y";
            this.chk_plot_pos_y.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chk_plot_pos_y.UseVisualStyleBackColor = true;
            this.chk_plot_pos_y.CheckedChanged += new System.EventHandler(this.btn_pos_y_CheckedChanged);
            // 
            // chk_plot_pos_z
            // 
            this.chk_plot_pos_z.Appearance = System.Windows.Forms.Appearance.Button;
            this.chk_plot_pos_z.Checked = true;
            this.chk_plot_pos_z.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chk_plot_pos_z.Location = new System.Drawing.Point(34, 156);
            this.chk_plot_pos_z.Name = "chk_plot_pos_z";
            this.chk_plot_pos_z.Size = new System.Drawing.Size(18, 23);
            this.chk_plot_pos_z.TabIndex = 12;
            this.chk_plot_pos_z.Text = "Z";
            this.chk_plot_pos_z.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chk_plot_pos_z.UseVisualStyleBackColor = true;
            this.chk_plot_pos_z.CheckedChanged += new System.EventHandler(this.btn_pos_z_CheckedChanged);
            // 
            // chk_plot_rot_x
            // 
            this.chk_plot_rot_x.Appearance = System.Windows.Forms.Appearance.Button;
            this.chk_plot_rot_x.Checked = true;
            this.chk_plot_rot_x.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chk_plot_rot_x.Location = new System.Drawing.Point(0, 205);
            this.chk_plot_rot_x.Name = "chk_plot_rot_x";
            this.chk_plot_rot_x.Size = new System.Drawing.Size(18, 23);
            this.chk_plot_rot_x.TabIndex = 13;
            this.chk_plot_rot_x.Text = "X";
            this.chk_plot_rot_x.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chk_plot_rot_x.UseVisualStyleBackColor = true;
            this.chk_plot_rot_x.CheckedChanged += new System.EventHandler(this.btn_rot_x_CheckedChanged);
            // 
            // chk_plot_rot_y
            // 
            this.chk_plot_rot_y.Appearance = System.Windows.Forms.Appearance.Button;
            this.chk_plot_rot_y.Checked = true;
            this.chk_plot_rot_y.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chk_plot_rot_y.Location = new System.Drawing.Point(16, 205);
            this.chk_plot_rot_y.Name = "chk_plot_rot_y";
            this.chk_plot_rot_y.Size = new System.Drawing.Size(18, 23);
            this.chk_plot_rot_y.TabIndex = 14;
            this.chk_plot_rot_y.Text = "Y";
            this.chk_plot_rot_y.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chk_plot_rot_y.UseVisualStyleBackColor = true;
            this.chk_plot_rot_y.CheckedChanged += new System.EventHandler(this.btn_rot_y_CheckedChanged);
            // 
            // chk_plot_rot_z
            // 
            this.chk_plot_rot_z.Appearance = System.Windows.Forms.Appearance.Button;
            this.chk_plot_rot_z.Checked = true;
            this.chk_plot_rot_z.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chk_plot_rot_z.Location = new System.Drawing.Point(34, 205);
            this.chk_plot_rot_z.Name = "chk_plot_rot_z";
            this.chk_plot_rot_z.Size = new System.Drawing.Size(18, 23);
            this.chk_plot_rot_z.TabIndex = 15;
            this.chk_plot_rot_z.Text = "Z";
            this.chk_plot_rot_z.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chk_plot_rot_z.UseVisualStyleBackColor = true;
            this.chk_plot_rot_z.CheckedChanged += new System.EventHandler(this.btn_rot_z_CheckedChanged);
            // 
            // radio_zxy
            // 
            this.radio_zxy.AutoSize = true;
            this.radio_zxy.Checked = true;
            this.radio_zxy.Location = new System.Drawing.Point(0, 233);
            this.radio_zxy.Name = "radio_zxy";
            this.radio_zxy.Size = new System.Drawing.Size(56, 16);
            this.radio_zxy.TabIndex = 20;
            this.radio_zxy.TabStop = true;
            this.radio_zxy.Text = "Z-X-Y";
            this.radio_zxy.UseVisualStyleBackColor = true;
            this.radio_zxy.CheckedChanged += new System.EventHandler(this.rot_axis_radio_changed);
            // 
            // radio_xyz
            // 
            this.radio_xyz.AutoSize = true;
            this.radio_xyz.Location = new System.Drawing.Point(0, 252);
            this.radio_xyz.Name = "radio_xyz";
            this.radio_xyz.Size = new System.Drawing.Size(56, 16);
            this.radio_xyz.TabIndex = 21;
            this.radio_xyz.Text = "X-Y-Z";
            this.radio_xyz.UseVisualStyleBackColor = true;
            this.radio_xyz.CheckedChanged += new System.EventHandler(this.rot_axis_radio_changed);
            // 
            // radio_xzy
            // 
            this.radio_xzy.AutoSize = true;
            this.radio_xzy.Location = new System.Drawing.Point(0, 272);
            this.radio_xzy.Name = "radio_xzy";
            this.radio_xzy.Size = new System.Drawing.Size(56, 16);
            this.radio_xzy.TabIndex = 22;
            this.radio_xzy.Text = "X-Z-Y";
            this.radio_xzy.UseVisualStyleBackColor = true;
            this.radio_xzy.CheckedChanged += new System.EventHandler(this.rot_axis_radio_changed);
            // 
            // btn_center
            // 
            this.btn_center.Location = new System.Drawing.Point(0, 0);
            this.btn_center.Name = "btn_center";
            this.btn_center.Padding = new System.Windows.Forms.Padding(1, 0, 0, 0);
            this.btn_center.Size = new System.Drawing.Size(16, 23);
            this.btn_center.TabIndex = 1;
            this.btn_center.Text = "C";
            this.toolTip1.SetToolTip(this.btn_center, "マーカー位置のY０に移動");
            this.btn_center.UseVisualStyleBackColor = true;
            this.btn_center.Click += new System.EventHandler(this.btn_center_Click);
            // 
            // chk_track_merker
            // 
            this.chk_track_merker.Appearance = System.Windows.Forms.Appearance.Button;
            this.chk_track_merker.Checked = true;
            this.chk_track_merker.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chk_track_merker.Location = new System.Drawing.Point(0, 41);
            this.chk_track_merker.Name = "chk_track_merker";
            this.chk_track_merker.Size = new System.Drawing.Size(51, 23);
            this.chk_track_merker.TabIndex = 4;
            this.chk_track_merker.Text = "マーカー";
            this.toolTip1.SetToolTip(this.chk_track_merker, "常にマーカーを中央に維持");
            this.chk_track_merker.UseVisualStyleBackColor = true;
            this.chk_track_merker.CheckedChanged += new System.EventHandler(this.chk_track_merker_CheckedChanged);
            // 
            // chk_track_yzero
            // 
            this.chk_track_yzero.Appearance = System.Windows.Forms.Appearance.Button;
            this.chk_track_yzero.Location = new System.Drawing.Point(0, 67);
            this.chk_track_yzero.Name = "chk_track_yzero";
            this.chk_track_yzero.Size = new System.Drawing.Size(51, 23);
            this.chk_track_yzero.TabIndex = 5;
            this.chk_track_yzero.Text = "Yゼロ";
            this.chk_track_yzero.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.toolTip1.SetToolTip(this.chk_track_yzero, "常に縦軸に０を維持");
            this.chk_track_yzero.UseVisualStyleBackColor = true;
            this.chk_track_yzero.CheckedChanged += new System.EventHandler(this.chk_track_yzero_CheckedChanged);
            // 
            // chk_edit_pos
            // 
            this.chk_edit_pos.Appearance = System.Windows.Forms.Appearance.Button;
            this.chk_edit_pos.Checked = true;
            this.chk_edit_pos.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chk_edit_pos.Location = new System.Drawing.Point(0, 111);
            this.chk_edit_pos.Name = "chk_edit_pos";
            this.chk_edit_pos.Size = new System.Drawing.Size(18, 22);
            this.chk_edit_pos.TabIndex = 6;
            this.chk_edit_pos.Text = "M";
            this.chk_edit_pos.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.toolTip1.SetToolTip(this.chk_edit_pos, "移動キーの編集可能切替");
            this.chk_edit_pos.UseVisualStyleBackColor = true;
            this.chk_edit_pos.CheckedChanged += new System.EventHandler(this.chk_edit_pos_CheckedChanged);
            // 
            // chk_edit_pos_ip
            // 
            this.chk_edit_pos_ip.Appearance = System.Windows.Forms.Appearance.Button;
            this.chk_edit_pos_ip.Checked = true;
            this.chk_edit_pos_ip.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chk_edit_pos_ip.Location = new System.Drawing.Point(17, 111);
            this.chk_edit_pos_ip.Name = "chk_edit_pos_ip";
            this.chk_edit_pos_ip.Size = new System.Drawing.Size(18, 22);
            this.chk_edit_pos_ip.TabIndex = 29;
            this.chk_edit_pos_ip.Text = "I";
            this.chk_edit_pos_ip.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.toolTip1.SetToolTip(this.chk_edit_pos_ip, "移動補完の編集能可切替");
            this.chk_edit_pos_ip.UseVisualStyleBackColor = true;
            this.chk_edit_pos_ip.CheckedChanged += new System.EventHandler(this.chk_edit_pos_ip_CheckedChanged);
            // 
            // chk_edit_rot
            // 
            this.chk_edit_rot.Appearance = System.Windows.Forms.Appearance.Button;
            this.chk_edit_rot.Location = new System.Drawing.Point(34, 111);
            this.chk_edit_rot.Name = "chk_edit_rot";
            this.chk_edit_rot.Size = new System.Drawing.Size(18, 22);
            this.chk_edit_rot.TabIndex = 30;
            this.chk_edit_rot.Text = "R";
            this.chk_edit_rot.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.toolTip1.SetToolTip(this.chk_edit_rot, "回転キーの編集可切替 (とても非実用的。使わないほうがいいです)");
            this.chk_edit_rot.UseVisualStyleBackColor = true;
            this.chk_edit_rot.CheckedChanged += new System.EventHandler(this.chk_edit_rot_CheckedChanged);
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(-2, 141);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(53, 12);
            this.label1.TabIndex = 25;
            this.label1.Text = "移動表示";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(-1, 190);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(53, 12);
            this.label2.TabIndex = 26;
            this.label2.Text = "回転表示";
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(-2, 26);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(29, 12);
            this.label3.TabIndex = 27;
            this.label3.Text = "追従";
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(1, 96);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(41, 12);
            this.label4.TabIndex = 28;
            this.label4.Text = "編集可";
            // 
            // graphPanelOuter
            // 
            this.graphPanelOuter.AutoScroll = true;
            this.graphPanelOuter.Controls.Add(this.frameRuler1);
            this.graphPanelOuter.Controls.Add(this.graphPanelInnner);
            this.graphPanelOuter.Location = new System.Drawing.Point(60, 0);
            this.graphPanelOuter.Margin = new System.Windows.Forms.Padding(0);
            this.graphPanelOuter.Name = "graphPanelOuter";
            this.graphPanelOuter.Size = new System.Drawing.Size(400, 180);
            this.graphPanelOuter.TabIndex = 3;
            // 
            // frameRuler1
            // 
            this.frameRuler1.Location = new System.Drawing.Point(0, 0);
            this.frameRuler1.Margin = new System.Windows.Forms.Padding(0);
            this.frameRuler1.Name = "frameRuler1";
            this.frameRuler1.Size = new System.Drawing.Size(300, 30);
            this.frameRuler1.TabIndex = 7;
            this.frameRuler1.TabStop = false;
            // 
            // graphPanelInnner
            // 
            this.graphPanelInnner.AutoScroll = true;
            this.graphPanelInnner.Controls.Add(this.graphPort1);
            this.graphPanelInnner.Location = new System.Drawing.Point(0, 30);
            this.graphPanelInnner.Margin = new System.Windows.Forms.Padding(0);
            this.graphPanelInnner.Name = "graphPanelInnner";
            this.graphPanelInnner.Size = new System.Drawing.Size(300, 150);
            this.graphPanelInnner.TabIndex = 1;
            // 
            // graphPort1
            // 
            this.graphPort1.CausesValidation = false;
            this.graphPort1.Location = new System.Drawing.Point(0, 0);
            this.graphPort1.Margin = new System.Windows.Forms.Padding(0);
            this.graphPort1.Name = "graphPort1";
            this.graphPort1.Scene = null;
            this.graphPort1.Size = new System.Drawing.Size(131, 80);
            this.graphPort1.TabIndex = 1;
            this.graphPort1.TabStop = false;
            // 
            // GraphEditorControl
            // 
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 12F);
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.Controls.Add(this.chk_edit_rot);
            this.Controls.Add(this.chk_edit_pos_ip);
            this.Controls.Add(this.chk_edit_pos);
            this.Controls.Add(this.label4);
            this.Controls.Add(this.label3);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.chk_track_yzero);
            this.Controls.Add(this.chk_track_merker);
            this.Controls.Add(this.btn_center);
            this.Controls.Add(this.radio_xzy);
            this.Controls.Add(this.radio_xyz);
            this.Controls.Add(this.radio_zxy);
            this.Controls.Add(this.chk_plot_rot_z);
            this.Controls.Add(this.chk_plot_rot_y);
            this.Controls.Add(this.chk_plot_rot_x);
            this.Controls.Add(this.chk_plot_pos_z);
            this.Controls.Add(this.chk_plot_pos_y);
            this.Controls.Add(this.chk_plot_pos_x);
            this.Controls.Add(this.btn_minus);
            this.Controls.Add(this.btn_plus);
            this.Controls.Add(this.graphPanelOuter);
            this.Name = "GraphEditorControl";
            this.Size = new System.Drawing.Size(433, 315);
            this.graphPanelOuter.ResumeLayout(false);
            this.graphPanelInnner.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

        }

        #endregion

        private Button btn_plus;
        private Button btn_minus;
        public GraphPanel graphPanelOuter;
        public GraphPanel graphPanelInnner;
        public GraphPort graphPort1;
        public FrameRuler frameRuler1;
        private CheckBox chk_plot_pos_x;
        private CheckBox chk_plot_pos_y;
        private CheckBox chk_plot_pos_z;
        private CheckBox chk_plot_rot_x;
        private CheckBox chk_plot_rot_y;
        private CheckBox chk_plot_rot_z;
        private RadioButton radio_zxy;
        private RadioButton radio_xyz;
        private RadioButton radio_xzy;
        private Button btn_center;
        private ToolTip toolTip1;
        public CheckBox chk_track_merker;
        public CheckBox chk_track_yzero;
        private Label label1;
        private Label label2;
        private Label label3;
        private Label label4;
        private CheckBox chk_edit_pos;
        private CheckBox chk_edit_pos_ip;
        private CheckBox chk_edit_rot;

    }
}
