﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MikuMikuMoving.Plugin;
using MikuMikuPlugin;
using DxMath;
using System.Diagnostics;

namespace MMM_GraphEditor
{
    public class GraphEditor : IResidentPlugin, IHaveUserControl
    {
        protected GraphEditorControl control { get; set; }

        private int refresh_counter = 0;
        private string func_label = "Viewer";

        public void Disabled()
        {
            this.control.Scene = null;
        }

        public void Enabled()
        {
            //throw new NotImplementedException();
        }

        public void Initialize()
        {
        }

        public void Update(float Frame, float ElapsedTime)
        {
            if (this.control != null && this.Scene != null && this.Scene.State.Equals(SceneState.Editing))
            {
                if (refresh_counter % 10 == 0)
                {
                    this.refresh_counter = 0;
                    this.control.Scene = this.Scene;
                    this.control.Refresh();
                }
                this.refresh_counter++;
            }
        }

        public System.Windows.Forms.IWin32Window ApplicationForm { get; set; }

        public string Description
        {
            get { return "Graph Editor Plugin"; }
        }

        public Guid GUID
        {
            get { return new Guid("70aa3704-075e-11e3-aa77-a7f2b782a7bd"); }
        }

        public void Dispose()
        {
            this.control.Scene = null;
        }

        public string EnglishText
        {
            get { return "Graph" + Environment.NewLine + func_label; }
        }

        public System.Drawing.Image Image
        {
            get { return null; }
        }

        public System.Drawing.Image SmallImage
        {
            get { return null; }
        }

        public string Text
        {
            get { return "Graph" + Environment.NewLine +  func_label; }
        }

        public MikuMikuPlugin.Scene Scene { get; set; }

        public System.Windows.Forms.UserControl CreateControl()
        {
            this.control = new GraphEditorControl();
            return this.control;
        }
    }
}
