﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MikuMikuMoving;
using MikuMikuMoving.Plugin;
using MikuMikuPlugin;

namespace MMM_GraphEditor
{
    public partial class GraphEditorControl : UserControl
    {


        public GraphEditorControl()
        {
            InitializeComponent();
        }

        private MikuMikuPlugin.Scene scene;

        public MikuMikuPlugin.Scene Scene
        {
            get { return this.scene; }
            set
            {
                this.scene = value;
                if (graphPort1 != null)
                    graphPort1.Scene = value;
            }
        }

        public override void Refresh()
        {
            base.Refresh();
            if (graphPort1 != null)
                graphPort1.Refresh();
        }

        private void btn_plus_Click(object sender, EventArgs e)
        {
            graphPort1.Zoom(1.6f);
        }

        private void btn_minus_Click(object sender, EventArgs e)
        {
            graphPort1.Zoom(0.625f);
        }

        private void btn_pos_x_CheckedChanged(object sender, EventArgs e)
        {
            graphPort1.render_pos[0] = btn_pos_x.Checked;
        }

        private void btn_pos_y_CheckedChanged(object sender, EventArgs e)
        {
            graphPort1.render_pos[1] = btn_pos_y.Checked;
        }

        private void btn_pos_z_CheckedChanged(object sender, EventArgs e)
        {
            graphPort1.render_pos[2] = btn_pos_z.Checked;
        }

        private void btn_rot_x_CheckedChanged(object sender, EventArgs e)
        {
            graphPort1.render_rot[0] = btn_rot_x.Checked;
        }

        private void btn_rot_y_CheckedChanged(object sender, EventArgs e)
        {
            graphPort1.render_rot[1] = btn_rot_y.Checked;
        }

        private void btn_rot_z_CheckedChanged(object sender, EventArgs e)
        {
            graphPort1.render_rot[2] = btn_rot_z.Checked;
        }

        private void rot_axis_radio_changed(object sender, EventArgs e)
        {
            if (radio_zxy.Checked)
            {
                graphPort1.default_rot_type = 0;
            }
            else if (radio_zyx.Checked)
            {
                graphPort1.default_rot_type = 1;
            }
            else if (radio_xzy.Checked)
            {
                graphPort1.default_rot_type = 2;
            }
            else
            {
                graphPort1.default_rot_type = -1;
            }
        }

        private void btn_center_Click(object sender, EventArgs e)
        {
            graphPort1.centerMarker();
        }

    }
}
