﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MikuMikuPlugin;

namespace MMM_GraphEditor
{
    public partial class GraphPort : UserControl
    {
        public GraphPort()
        {
            InitializeComponent();
        }

        private Point graph_move_start_pos;
        private bool graph_move_mode = false;

        protected override void OnMouseWheel(MouseEventArgs e)
        {
            base.OnMouseWheel(e);
            float zoom_ratio = ((e.Delta / 120)*0.2f)+1.0f;
            GraphPanel panel = (GraphPanel)this.Parent;
            int old_panel_y = -panel.AutoScrollPosition.Y;
            this.Zoom(zoom_ratio);
            panel.AutoScrollPosition = new Point(panel.AutoScrollPosition.X, (int) (old_panel_y * zoom_ratio));
        }

        public void Zoom(float i) {
            int min = 3;
            int max = 500;
            this.graph_scale *= i;
            if (this.graph_scale > max)
                this.graph_scale = max;
            if (this.graph_scale < min)
                this.graph_scale = min;
            this.Refresh();
        }

        protected override void OnResize(EventArgs e)
        {
            base.OnResize(e);

            Panel innerPanel;
            Panel outerPanel;
            GraphEditorControl mainControl;
            FrameRuler ruler;

            try
            {
                innerPanel = (Panel)Parent;
                if (Parent == null) return;

                outerPanel = (Panel)Parent.Parent;
                if (outerPanel == null) return;

                mainControl = (GraphEditorControl)Parent.Parent.Parent;
                if (mainControl == null) return;

                ruler = (FrameRuler)mainControl.frameRuler1;
                if (ruler == null) return;

                innerPanel.Width = Width + SystemInformation.VerticalScrollBarWidth;
                innerPanel.Height = outerPanel.Height - 30 - SystemInformation.HorizontalScrollBarHeight;
                ruler.Width = Width;
            }
            catch (System.Exception)
            {
                // ignore
            }

            
        }

        private void mouse_down(object sender, MouseEventArgs e)
        {
            if (e.Button == System.Windows.Forms.MouseButtons.Right)
            {
                this.graph_move_mode = true;
                this.graph_move_start_pos = e.Location;
            }
        }

        private void mouse_up(object sender, MouseEventArgs e)
        {
            if (e.Button == System.Windows.Forms.MouseButtons.Right && this.graph_move_start_pos != null)
            {
                this.graph_move_mode = false;
            }

        }

        private void mouse_move(object sender, MouseEventArgs e)
        {
            if (graph_move_mode)
            {
                GraphPanel panel_inner = (GraphPanel)this.Parent;
                GraphPanel panel_outer = (GraphPanel)this.Parent.Parent;
                panel_inner.AutoScrollPosition = new Point(
                    -panel_inner.AutoScrollPosition.X,
                    -panel_inner.AutoScrollPosition.Y - e.Location.Y + graph_move_start_pos.Y);
                panel_outer.AutoScrollPosition = new Point(
                    -panel_outer.AutoScrollPosition.X - e.Location.X + graph_move_start_pos.X,
                    -panel_outer.AutoScrollPosition.Y);
            }

        }

        public void key_down(object sender, PreviewKeyDownEventArgs e)
        {
            if (scene == null) return;
            switch (e.KeyCode)
            {
                case Keys.Right:
                    scene.MarkerPosition += 1;
                    centerMarker();
                    break;
                case Keys.Left:
                    scene.MarkerPosition -= 1;
                    centerMarker();
                    break;
                case Keys.C:
                    centerMarker();
                    break;
                case Keys.Enter:
                    if (target_bone == null || target_layer == null)  break;
                    MotionData cur_motion = target_bone.CurrentLocalMotion;
                    MotionFrameData fd = new MotionFrameData(scene.MarkerPosition, cur_motion.Move, cur_motion.Rotation);
                    target_layer.Frames.AddKeyFrame(fd);
                    break;
                default:
                    System.Diagnostics.Trace.WriteLine("Unknown key event: " + e.KeyCode);
                    break;
            }
        }

        public void centerMarker()
        {
            if (scene == null) return;
            GraphPanel panel_outer;
            try
            {
                panel_outer = (GraphPanel)this.Parent.Parent;
            }
            catch (System.Exception)
            {
                return;
            }
            panel_outer.AutoScrollPosition = new Point((int) (scene.MarkerPosition * frame_width - panel_outer.Width / 2), -panel_outer.AutoScrollPosition.Y);
        }

        private void key_down(object sender, KeyEventArgs e)
        {

        }
    }
}
