﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MikuMikuMoving;
using MikuMikuMoving.Plugin;
using MikuMikuPlugin;

namespace MMM_GraphEditor
{
    public partial class GraphEditorControl : UserControl
    {


        public GraphEditorControl()
        {
            InitializeComponent();
        }

        private MikuMikuPlugin.Scene scene;
        private long lastMarkerPos = 0;
        public GraphEditor.Config config;

        public MikuMikuPlugin.Scene Scene
        {
            get { return this.scene; }
            set
            {
                this.scene = value;
                if (graphPort1 != null)
                    graphPort1.Scene = value;
            }
        }

        public override void Refresh()
        {
            base.Refresh();
            if (graphPort1 != null)
            {
                graphPort1.Refresh();
                if (this.scene != null && this.scene.MarkerPosition != this.lastMarkerPos)
                    graphPort1.centerMarker();
            }
            if (this.scene != null)
            {
                this.lastMarkerPos = this.scene.MarkerPosition;
            }
        }

        private void btn_plus_Click(object sender, EventArgs e)
        {
            graphPort1.Zoom(1.6f);
        }

        private void btn_minus_Click(object sender, EventArgs e)
        {
            graphPort1.Zoom(0.625f);
        }

        private void btn_pos_x_CheckedChanged(object sender, EventArgs e)
        {
            config.render_flags[GraphPort.IDX_POS_X] = chk_plot_pos_x.Checked;
        }

        private void btn_pos_y_CheckedChanged(object sender, EventArgs e)
        {
            config.render_flags[GraphPort.IDX_POS_Y] = chk_plot_pos_y.Checked;
        }

        private void btn_pos_z_CheckedChanged(object sender, EventArgs e)
        {
            config.render_flags[GraphPort.IDX_POS_Z] = chk_plot_pos_z.Checked;
        }

        private void btn_rot_x_CheckedChanged(object sender, EventArgs e)
        {
            config.render_flags[GraphPort.IDX_ROT_R] = chk_plot_rot_x.Checked;
        }

        private void btn_rot_y_CheckedChanged(object sender, EventArgs e)
        {
            config.render_flags[GraphPort.IDX_ROT_P] = chk_plot_rot_y.Checked;
        }

        private void btn_rot_z_CheckedChanged(object sender, EventArgs e)
        {
            config.render_flags[GraphPort.IDX_ROT_Y] = chk_plot_rot_z.Checked;
        }

        private void rot_axis_radio_changed(object sender, EventArgs e)
        {
            if (radio_zxy.Checked)
            {
                config.euler_rot_order = 0;
            }
            else if (radio_xyz.Checked)
            {
                config.euler_rot_order = 1;
            }
            else if (radio_xzy.Checked)
            {
                config.euler_rot_order = 2;
            }
        }

        private void btn_center_Click(object sender, EventArgs e)
        {
            graphPort1.centerMarkerForce();
        }

        private void chk_edit_pos_CheckedChanged(object sender, EventArgs e)
        {
           
            config.edit_flags[GraphPort.IDX_EDIT_POS] = chk_edit_pos.Checked;
        }
        private void chk_edit_pos_ip_CheckedChanged(object sender, EventArgs e)
        {
            config.edit_flags[GraphPort.IDX_EDIT_POS_IP] = chk_edit_pos_ip.Checked;

        }

        private void chk_edit_rot_CheckedChanged(object sender, EventArgs e)
        {
            config.edit_flags[GraphPort.IDX_EDIT_ROT] = chk_edit_rot.Checked;
        }

        private void chk_track_merker_CheckedChanged(object sender, EventArgs e)
        {
            config.track_marker = chk_track_merker.Checked;
        }

        private void chk_track_yzero_CheckedChanged(object sender, EventArgs e)
        {
            config.track_yzero = chk_track_yzero.Checked;
        }
    }
}
