/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.Flushable;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class DOMElementFormatter
implements Formatter {
    public static final DOMElementFormatter INSTANCE = new DOMElementFormatter();

    DOMElementFormatter() {
    }

    public boolean format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        int indent;
        Element elem = (Element)o;
        out.append('[');
        StringFormatter.serialize(context, elem.getTagName(), out);
        out.append(',');
        if (context.isPrettyPrint()) {
            out.append('\n');
            indent = context.getInitialIndent() + context.getDepth() + 1;
            for (int j = 0; j < indent; ++j) {
                out.append(context.getIndentText());
            }
        }
        out.append('{');
        if (elem.hasAttributes()) {
            NamedNodeMap names = elem.getAttributes();
            for (int i = 0; i < names.getLength(); ++i) {
                Node node;
                if (i != 0) {
                    out.append(',');
                }
                if (context.isPrettyPrint() && names.getLength() > 1) {
                    out.append('\n');
                    for (int j = 0; j < context.getDepth() + 2; ++j) {
                        out.append('\t');
                    }
                }
                if (!((node = names.item(i)) instanceof Attr)) continue;
                StringFormatter.serialize(context, node.getNodeName(), out);
                out.append(':');
                if (context.isPrettyPrint()) {
                    out.append(' ');
                }
                StringFormatter.serialize(context, node.getNodeValue(), out);
            }
            if (context.isPrettyPrint() && names.getLength() > 1) {
                out.append('\n');
                int indent2 = context.getInitialIndent() + context.getDepth() + 1;
                for (int j = 0; j < indent2; ++j) {
                    out.append(context.getIndentText());
                }
            }
        }
        out.append('}');
        if (elem.hasChildNodes()) {
            NodeList nodes = elem.getChildNodes();
            JSONHint hint = context.getHint();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Object value = nodes.item(i);
                if (!(value instanceof Element) && (!(value instanceof CharacterData) || value instanceof Comment)) continue;
                out.append(',');
                if (context.isPrettyPrint()) {
                    out.append('\n');
                    int indent3 = context.getInitialIndent() + context.getDepth() + 1;
                    for (int j = 0; j < indent3; ++j) {
                        out.append(context.getIndentText());
                    }
                }
                context.enter(i + 2, hint);
                value = context.preformatInternal(value);
                context.formatInternal(value, out);
                context.exit();
                if (!(out instanceof Flushable)) continue;
                ((Flushable)((Object)out)).flush();
            }
        }
        if (context.isPrettyPrint()) {
            out.append('\n');
            indent = context.getInitialIndent() + context.getDepth();
            for (int j = 0; j < indent; ++j) {
                out.append(context.getIndentText());
            }
        }
        out.append(']');
        return true;
    }
}

