/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.io.OutputSource;

final class StringFormatter
implements Formatter {
    public static final StringFormatter INSTANCE = new StringFormatter();
    private static final int[] ESCAPE_CHARS = new int[128];

    StringFormatter() {
    }

    public boolean format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        StringFormatter.serialize(context, o.toString(), out);
        return false;
    }

    static void serialize(JSON.Context context, String s, OutputSource out) throws Exception {
        out.append('\"');
        int start = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c < ESCAPE_CHARS.length) {
                int x = ESCAPE_CHARS[c];
                if (x == 0) continue;
                if (x > 0) {
                    if (start < i) {
                        out.append(s, start, i);
                    }
                    out.append('\\');
                    out.append((char)x);
                    start = i + 1;
                    continue;
                }
                if (x != -1 && (x != -2 || context.getMode() == JSON.Mode.STRICT)) continue;
                if (start < i) {
                    out.append(s, start, i);
                }
                out.append("\\u00");
                out.append("0123456789ABCDEF".charAt(c / 16));
                out.append("0123456789ABCDEF".charAt(c % 16));
                start = i + 1;
                continue;
            }
            if (c == '\u2028') {
                if (start < i) {
                    out.append(s, start, i);
                }
                out.append("\\u2028");
                start = i + 1;
                continue;
            }
            if (c != '\u2029') continue;
            if (start < i) {
                out.append(s, start, i);
            }
            out.append("\\u2029");
            start = i + 1;
        }
        if (start < length) {
            out.append(s, start, length);
        }
        out.append('\"');
    }

    static {
        for (int i = 0; i < 32; ++i) {
            StringFormatter.ESCAPE_CHARS[i] = -1;
        }
        StringFormatter.ESCAPE_CHARS[8] = 98;
        StringFormatter.ESCAPE_CHARS[9] = 116;
        StringFormatter.ESCAPE_CHARS[10] = 110;
        StringFormatter.ESCAPE_CHARS[12] = 102;
        StringFormatter.ESCAPE_CHARS[13] = 114;
        StringFormatter.ESCAPE_CHARS[34] = 34;
        StringFormatter.ESCAPE_CHARS[92] = 92;
        StringFormatter.ESCAPE_CHARS[60] = -2;
        StringFormatter.ESCAPE_CHARS[62] = -2;
        StringFormatter.ESCAPE_CHARS[127] = -1;
    }
}

