class Rating < ActiveRecord::Base
  belongs_to :navi_voice

  default_scope -> { order('id') }

  validates :value, numericality: {only_integer: true, less_than_or_equal_to: 5, greater_than_or_equal_to: 0 }
  validates :navi_voice_id, numericality: {only_integer: true}
  validates :ident, presence: true
  validates :ip_hash, presence: true
end
