require 'fileutils'

class VoicePreview < Paperclip::Processor
  ZIP_BUFSIZE = 16 * 1024

  def make
    src = @file
    options[:format] or raise Paperclip::Error, 'Format option is missing!'
    ext = ".#{options[:format]}".downcase

    dst = Tempfile.new(["nv-preview-", ext])
    dst.binmode
    dst_path = File.expand_path(dst.path)
    tmpdir = Dir.mktmpdir("nv-preview-")

    begin
      tfiles = []
      Zip::ZipFile.foreach(src.path) do |ze|
        i = nil
        case ze.name.downcase
        when "7.ogg"
          i = "01"
        when "then.ogg"
          i = "02"
        when "12.ogg"
          i = "03"
        else
          next
        end
        tfiles << (tf = "#{tmpdir}/#{i}.ogg")
        open(tf, "w") do |of|
          of.binmode
          zs = ze.get_input_stream
          while buf = zs.read(ZIP_BUFSIZE)
            of << buf
          end
        end
      end
      if tfiles.size < 3
        Rails.logger.error "Preview target is missing. zip entry count=#{Zip::ZipFile.foreach(src.path).count}"
        raise Paperclip::Error, I18n.t("voice_preview.err_missing")
      end
      tfiles.each do |tf|
        `soxi -t "#{tf}"`.chomp.downcase == 'vorbis' &&
          `soxi -e "#{tf}"`.chomp.downcase == 'vorbis' or
          raise Paperclip::Error, I18n.t("voice_preview.err_not_ogg")
        `soxi -r "#{tf}"`.to_i == 44100 && `soxi -c "#{tf}"`.to_i == 1 and next
        rtmp = "#{tmpdir}/rate-convert-tmp-#{$$}.ogg"
        system('sox', tf, '-c', '1', '-r', '44100', rtmp) or raise Paperclip::Error, I18n.t("voice_preview.err_normalize")
        FileUtils.mv rtmp, tf
      end
      system(*['sox', tfiles.sort, dst_path].flatten) or raise Paperclip::Error, I18n.t("voice_preview.err_concat")
    rescue => e
      Rails.logger.error "Failed to generate preview voice: #{e.backtrace.first}: #{e.message}, last error is #{$?}"
      FileUtils.mkdir_p "#{Rails.root}/tmp/failed"
      failed_path = "#{Rails.root}/tmp/failed/#{Time.now.to_i}.zip"
      Rails.logger.error "Keeping failed archive to '#{failed_path}'"
      FileUtils.cp @file.path, failed_path
      env = ENV.to_hash
      env['SAVED_ARCHIVE'] = failed_path
      defined?(ExceptionNotifier) and
        ExceptionNotifier::Notifier.exception_notification(env, e).deliver
      raise Paperclip::Error, I18n.t("voice_preview.err") + ": #{e.message}"
    ensure
       FileUtils.remove_entry_secure tmpdir
    end
    dst
  end
end
