﻿''' <summary>共通クラス</summary>
''' <remarks>Public Const/Shared 宣言用クラス。グローバルな変数、メソッドなどを定義する</remarks>
Public Class ClassMyCommon

    ''' <summary>プログラムタイトル</summary>
    Public Const TITLE As String = "Office Image Reducer"

    ''' <summary>バージョン</summary>
    Public Const VERSION As String = "02.02-180210"

    ''' <summary>メッセージ</summary>
    ''' <remarks>改行はvbCrLf</remarks>
    Public Const OPENING_MSG As String _
        = "Programmed by S.Hori" + vbCrLf _
        + vbCrLf _
        + "下記のWEBサイトから最新版を入手できます。" + vbCrLf _
        + "https://ja.osdn.net/users/hor931101jp/pf/01" + vbCrLf _
        + "下記のSVNリポジトリからソースコードをチェックアウトできます。" + vbCrLf _
        + "svn://svn.pf.osdn.jp/h/ho/hor931101jp/01/tags" + vbCrLf _
        + vbCrLf _
        + "ここに docx xlsx pptx ファイルをドラックアンドドロップしてください。" + vbCrLf

    ''' <summary>メインフォームインスタンス宣言</summary>
    Public Shared frmMain As FormMain

    ''' <summary>ログの管理インスタンス宣言</summary>
    Public Shared Log As ClassLog

    ''' <summary>ミリ秒指定で待機する。</summary>
    ''' <param name="WaitTime">待機時間[ms]</param>
    ''' <remarks>引数を 50 以下にしても Windows の都合で 50ms 以上待機してしまうこともおこりうる</remarks>
    Public Shared Sub WaitTickCount(ByVal WaitTime As Int32)
        Dim StartTickCount As Int32 = Environment.TickCount And Int32.MaxValue
        Dim NowTickCount As Int32
        Do
            Application.DoEvents()
            System.Threading.Thread.Sleep(1)
            NowTickCount = Environment.TickCount And Int32.MaxValue
        Loop Until ((NowTickCount - StartTickCount) >= WaitTime)
    End Sub

    ''' <summary>システムメニューを取得するAPI</summary>
    Private Declare Function GetSystemMenu Lib "user32" (ByVal hWnd As Integer, ByVal bRevert As Integer) As Integer

    ''' <summary>システムメニューの項目を削除するAPI</summary>
    Private Declare Function DeleteMenu Lib "user32" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer

    ''' <summary>メニューバーを再描画するAPI</summary>
    Private Declare Function DrawMenuBar Lib "user32.dll" (ByVal hWnd As Integer) As Integer

    ''' <summary>フォームの「右上コントロールボックス」と「左上アイコンのシステムメニュー」のカスタマイズを行う。</summary>
    ''' <param name="f">対象とするフォーム</param>
    Public Shared Sub FormControlBoxCustomize(f As Form)
        'Const SC_SIZE = &HF000&          'システムメニューの「サイズ変更」
        'Const SC_MOVE = &HF010&          'システムメニューの「移動」
        'Const SC_MINIMIZE = &HF020&      'システムメニューの「最小化」
        'Const SC_MAXIMIZE = &HF030&      'システムメニューの「最大化」
        Const SC_CLOSE = &HF060&         'システムメニューの「閉じる」
        'Const SC_RESTORE = &HF120        'システムメニューの「元のサイズに戻す」
        Const MF_BYCOMMAND = &H0&        'メニュー項目指定
        Const MF_BYPOSITION = &H400&     'ポジション指定
        'Const MF_ENABLED = &H0&          '有効化
        'Const MF_GRAYED = &H1&           '無効化
        'Const MF_DISABLED = &H2&         '半無効化(見かけ上有効)
        Dim DUMMY As Integer

        ''「区切り線」の削除
        DUMMY = DeleteMenu(GetSystemMenu(f.Handle, 0), 5, MF_BYPOSITION)
        ''「閉じる」の削除 + ｘボタンの無効化
        DUMMY = DeleteMenu(GetSystemMenu(f.Handle, 0), SC_CLOSE, MF_BYCOMMAND)
        ''描画 (変更を反映)
        DUMMY = DrawMenuBar(f.Handle)

    End Sub

    ''' <summary>本体のEXEファイルのあるフォルダをフルパスで返す</summary>
    ''' <returns>フォルダのフルパス。最後に\がつく。例) C:\MyFolder\ </returns>
    Public Shared Function AppPath() As String
        Return System.IO.Path.GetDirectoryName( _
            System.Reflection.Assembly.GetExecutingAssembly().Location) + "\"
    End Function

End Class
