/*
 *   cgrep (color grep)
 *
 *   00/04/18 V0.10 by oga
 *   13/12/14 V0.11 support -i (ignore case)
 *   14/02/01 V0.12 support MS VC6
 *
 */
#include <stdio.h>
#include <string.h>

#ifdef _WIN32
#if !defined(strncasecmp)
#define strncasecmp strnicmp
#endif
#endif

enum {COL_ESC, COL_BS};
int  color = 6;	  /* -c : yellow?             */
int  vf    = 0;   /* -v: verbose              */
int  igcf  = 0;	  /* -i: ignore case  V0.11-A */

/*
 *  add color ESC sequence to "key" in "buf"
 */
void ChangeBold(char *buf, char *key, int type)
{
    char wk[4096];
    int  i;
    int  j = 0;
    int  k;
    int  klen;
    int  ret;

    klen = strlen(key);
    memset (wk, 0, sizeof(wk));

    for (i = 0; i < strlen(buf); i++) {
        if (igcf) {                                 /* V0.11-A */
            ret = strncasecmp(&buf[i], key, klen);  /* V0.11-A */
	} else {                                    /* V0.11-A */
            ret = strncmp(&buf[i], key, klen);
	}                                           /* V0.11-A */
        if (ret) {                                  /* V0.11-C */
            /* no match */
            wk[j++] = buf[i];
        } else {
            /* match */
            if (type == COL_ESC) {
                /* ESC color */
                wk[j++] = 27;		/* ESC   */
                wk[j++] = '[';
                wk[j++] = '3';
                wk[j++] = ('0'+color);	/* color 1-7 */
                wk[j++] = 'm';
                /* strcat(wk, key); */
                strncpy(&wk[j], &buf[i], klen);  /* V0.11-C */
                j += klen;                       /* V0.11-C */
                wk[j++] = 27;		/* ESC   */
                wk[j++] = '[';
                wk[j++] = '0';		/* normal color */
                wk[j++] = 'm';
            } else {
                /* COL_BS */
                /* Back Space color (for less?) */
                /* not available                */
		for (k = 0; k<klen; k++) {
		     /* wk[j++] = key[k]; */
		     wk[j++] = buf[i+k];         /* V0.11-C   */ 
		     wk[j++] = 0x08;             /* backspace */
		     /* wk[j++] = key[k]; */
		     wk[j++] = buf[i+k];         /* V0.11-C   */ 
		}
            }
            i += (klen-1);
        }
    }
    strcpy(buf, wk);
}

void usage()
{
    printf("usage: cgrep <search_str> [files ...] [-c <color>] [-b] [-i]\n");
    printf("       -c <color> : specify 1-7. default 6\n");
    printf("       -b         : bold with backspace (for less)\n");
    printf("       -i         : ignore case\n");
}

/*
 *  strcasestr()
 *
 *    case ignore strstr()
 *
 *  IN  : buf   search target string
 *        key   search key
 *  OUT : ret   NULL : match
 *              str  : match point
 */
char *strcasestr(char *buf, char *key)
{
    int  i;
    int  buflen, keylen;
    int  ret = 1;          /* no match */
    char *pt;

    buflen = strlen(buf);
    keylen = strlen(key);

    if (buflen < keylen) {
        return NULL;
    }

    /* [0][1][2][3][4] */
    /*       [0][1][2] */
    for (i = 0; i <= buflen-keylen; i++) {
    	if (!strncasecmp(&buf[i], key, keylen)) {
	    return &buf[i];
	}
    }

    return NULL;
}

int main(int a, char *b[])
{
    int  i, x;
    FILE *fp;
    char buf[4096];
    int  ctype = COL_ESC;
    char *filename[1000];
    int  files = 0;
    char *pt;
    char *key = NULL;

    for (i = 1; i<a; i++) {
        if (!strcmp(b[i],"-h")) {
	    usage();
            return 1;
        }
        if (!strcmp(b[i],"-b")) {
            ctype = COL_BS;
            continue;
        }
        if (!strcmp(b[i],"-c")) {
            color = atoi(b[++i]);
            continue;
        }

	/* V0.11-A start */
        if (!strcmp(b[i],"-i")) {
            igcf = 1;
            continue;
        }
	/* V0.11-A end   */

        if (key == NULL) {
            key = b[i];
            continue;
        }
        filename[files++] = b[i];
    }

    if (key == NULL) {
	usage();
	return 1;
    }

    x = 0;
    do {
        if (files) {
	    if (!(fp = fopen(filename[x],"r"))) {
		perror("fopen");
		continue;
	    }
        } else {
            fp = stdin;
        }

        while (fgets(buf,sizeof(buf),fp)) {
	    if (igcf) {
	        /* ignore case */
                pt = strcasestr(buf, key);
	    } else {
                pt = strstr(buf, key);
	    }
            if (pt) {
                ChangeBold(buf, key, ctype);
                if (files > 1) {
                    printf("%s:%s", filename[x], buf);
                } else {
                    printf("%s", buf);
                }
            }
        }

        if (files) fclose(fp);
    } while ( ++x < files);

	return 0;
}

