package lambda;

import java.util.*;

public class Main1 {

	/* Ɏw肳֐̃C^tF[X */
	public static interface ItemWithIndexVisitor<E> {
		public void visit(E item, int index);
	}

	/* Xg̗vfo͊֐ */
	public static <E> void eachWithIndex(List<E> list, ItemWithIndexVisitor<E> visitor) {
		for (int i = 0; i < list.size(); i++) {
			visitor.visit(list.get(i), i);
		}
	}

	public static void main(String[] args) {
		List<String> list = Arrays.asList("A", "B", "C");
		eachWithIndex(list,
			(value, index) -> {
				String output = String.format("%d -> %s", index, value);
				System.out.println(output);
			}
		);
	}
}