package com.haru.tetoru.parts;

import static com.haru.tetoru.parts.Block.$;
import static com.haru.tetoru.parts.Block.D;
import static com.haru.tetoru.parts.Block._;

public class Table {

	/****************************/
	/* Constant                 */
	/****************************/
	/* TCY */
	static final int WIDTH  = 12;
	static final int HEIGHT  = 21;

	/* Qi͌ȂubN */
	static final int OFFSET = 2;

	/* E[ */
	static final int L = 1;
	/* [ */
	static final int R = WIDTH - 2;

	/****************************/
	/* Member variable          */
	/****************************/
	/* c~2z */
	private int[][] table;

	/****************************/
	/* Constructor              */
	/****************************/
	public Table() {
		/* e[u` */
		table = new int[HEIGHT + OFFSET][WIDTH];

		/* e[u */
		for (int y = 0; y < table.length; y++) {
			if (table.length-1 == y) {
				for (int x = 0; x < table[y].length; x++) {
					table[y][x] = $;
				}
			} else {
				for (int x = 0; x < table[y].length; x++) {
					if (L > x || R < x) {
						table[y][x] = $;
					} else {
						table[y][x] = _;
					}
				}
			}
		}
	}

	/****************************/
	/* Member method            */
	/****************************/
	/**
	 * e[u\p擾
	 */
	public String toString() {
		StringBuilder builder;
		builder = new StringBuilder();

		/* e[u\p쐬(Qi͌ȂubN) */
		for (int i = OFFSET; i < table.length; i++) {
			for (int block : table[i]) {
				builder.append(block);
			}
			builder.append(System.getProperty("line.separator"));
		}

		return builder.toString();
	}

	/* e[u͈̔͊O */
	boolean isOutOfRange(Point p) {
		return p.x < 0 || p.x >= table[0].length
			|| p.y < 0 || p.y >= table.length;
	}

	/**
	 * (x,y)̈ʒũubN̎ނ擾(`́ABlock.*)
	 * @param x
	 * @param y
	 * @return
	 */
	int getBlockType(int x, int y) {
		return table[y][x];
	}

	/* e[uɐݒu(private) */
	private void putBlock(int x, int y, int type) {
		table[y][x] = type;
	}

	/**
	 * blocks[startIdx]blocks[endIdx]܂ł̃ubNe[uɐݒu
	 * @param startIdx
	 * @param endIdx
	 * @param blocks
	 * @return
	 */
	public boolean putBlocks(int startIdx, int endIdx, Block[] blocks) {
		/* `FbN */
		if (startIdx >= blocks.length || endIdx >= blocks.length) {
			return false;
		}

		/* e[uɐݒu */
		for (int i = startIdx; i <= endIdx; i++) {
			putBlock(blocks[i].getX(), blocks[i].getY(), blocks[i].getType());
		}

		return true;
	}

	/**
	 * blocks[startIdx]blocks[endIdx]̈ʒuɋubNݒu
	 * @param startIdx
	 * @param endIdx
	 * @param blocks
	 * @return
	 */
	public boolean putEmptyBlocks(int startIdx, int endIdx, Block[] blocks) {
		int type = _;

		/* `FbN */
		if (startIdx >= blocks.length || endIdx >= blocks.length) {
			return false;
		}

		/* e[uɐݒu */
		for (int i = startIdx; i <= endIdx; i++) {
			putBlock(blocks[i].getX(), blocks[i].getY(), type);
		}

		return true;
	}

	/**********************************************************************/
	/* C폜														  */
	/**********************************************************************/
	/* 1s폜(ۂɂ͍폜A폜Ώۂ̃~mƂĐݒ) */
	private void delLine(int y) {
		for (int i = L; i <= R; i++) {
			table[y][i] = D;
		}
	}

	/* 1s폜ł邩 */
	private boolean isDelLine(int y) {
		boolean ret = true;

		for (int i = L; i <= R; i++) {
			if (_ == table[y][i]) {
				ret = false;
				break;
			}
		}

		return ret;
	}

	/**
	 * s폜
	 * @param blocks
	 * @return
	 */
	public boolean delMultiLine(Block[] blocks) {
		boolean ret = false;
		int delY;

		for (Block block : blocks) {
			delY = block.getY();
			if (isDelLine(delY)) {
				ret = true;
				delLine(delY);
			}
		}
		return ret;
	}

	/**
	 * 폜Ώۃ~m̃Cl߂
	 */
	public void pack() {
		int packLineNum = 0; /* l߂郉C */
		final int CHECK_X = 1; /* Cō폜Ώۃ~m`FbNʒu

		/* ŉʍs폜Ώۂ`FbN */
		packLineNum = (D == table[table.length-2][CHECK_X]) ? 1 : 0;

		/* es폜Ώۂ`FbNȂAl߂ */
		for (int y = table.length-3; y >= 0; y--) {
			/* 폜Ώۂ̍s */
			if (D == table[y][CHECK_X]) {
				/* 폜Ώۂ̍s̏ꍇAl߂郉C1 */
				packLineNum++;
			} else {
				/* 폜ΏۂłȂꍇAysڂpackLineNumsAɋl߂ */
				if (0 != packLineNum) {
					/* 1ubNmɐݒ */
					for (int i = 1; i < table[y].length - 1; i++) {
						table[y + packLineNum][i] = table[y][i];
					}
				}
			}
		}

		/* ŏʂpackLineNums */
		for (int y = 0; y < packLineNum; y++) {
			for (int i = L; i < R; i++) {
				table[y][i] = _;
			}
		}
	}

}
