package com.haru.tetoru.parts;

import static com.haru.tetoru.parts.Block._;
import static com.haru.tetoru.parts.Mino.R_LEFT;
import static com.haru.tetoru.parts.Mino.R_RIGHT;
import static com.haru.tetoru.parts.Table.HEIGHT;
import static com.haru.tetoru.parts.Table.L;
import static com.haru.tetoru.parts.Table.OFFSET;
import static com.haru.tetoru.parts.Table.R;
import static com.haru.tetoru.template.Player.OP_DOWN;
import static com.haru.tetoru.template.Player.OP_LEFT;
import static com.haru.tetoru.template.Player.OP_NO;
import static com.haru.tetoru.template.Player.OP_RIGHT;
import static com.haru.tetoru.template.Player.OP_ROTATE_LEFT;
import static com.haru.tetoru.template.Player.OP_ROTATE_RIGHT;
import static com.haru.tetoru.template.Player.OP_START;

import java.util.ArrayList;

/**
 * PlayerTableԂ̒ԑw
 * e[ȗ쒆~mɑ΂鑀s
 * Playeȓ(R}h)ɑ΂ăe[uւ̏ƂĐU蕪
 */
public class MinoController {

	/****************************/
	/* Constant                 */
	/****************************/
	/* ubN̏oʒu */
	private static final int START_X = 5;
	private static final int START_Y = 0 + OFFSET;

	/****************************/
	/* Member variable          */
	/****************************/
	/* e[uǗ */
	/* TODO:CX^X^C~O */
	private Table tableInstance; 
	/* lNXg */
	private NextTable nextTable;

	/****************************/
	/* Constructor              */
	/****************************/
	public MinoController(Table table) {
		this.tableInstance = table;
		nextTable = new NextTable();
	}

	/****************************/
	/* Member method            */
	/****************************/
	/**
	 * lNXg\p擾B
	 * NextTable#toStringbvB
	 * @return
	 */
	public String toStringNext() {
		return nextTable.toString();
	}

	/**
	 * ~m
	 * TODO:߂ƂĕԂׂł͂ȂH
	 * @return
	 */
	public Mino initMino() {
		/* ނ擾 */
		int type = nextTable.getNextType();

		/* ʒu̐ݒ */
		int x = START_X;
		int y = START_Y;

		/* ~m̐ */
		return new Mino(type, x, y);
	}

	/**
	 * ~mu邩B
	 * ɒS̈ʒuw肷B
	 * @param current
	 * @param x
	 * @param y
	 * @return
	 */
	public boolean isSetMino(Mino current, int x, int y) {
		int cnt;
		int[][] info = current.getRelativePos();
		boolean ret = true;


//		Debug.println("x:" + x + " y:" + y);

		/* S̔ */
		if (_ != tableInstance.getBlockType(x,  y)) {
			ret = false;;
		} else {
			/* 3_̔ */
			for (cnt = 0; cnt < info.length; cnt++) {
				int offsetX = info[cnt][0];
				int offsetY = info[cnt][1];

//				Debug.println("{" + offsetX + ", " + offsetY + "}");

				/* ʒu` */
				Point p = new Point(x + offsetX, y + offsetY);

				/* zOANZX`FbN */
				if (tableInstance.isOutOfRange(p)) {
					ret = false;
					break;
				}

				/*  */
				if (_ != tableInstance.getBlockType(p.x, p.y)) {
					ret = false;
					break;
				}
			}
		}

		return ret;
	}

	/**
	 * Player̓͂ɑ΂ă~m̑{
	 * 
	 * @param current
	 * @param type ̎
	 * @return
	 */
	public boolean doOperate(Mino current, int type) {

		boolean ret = false;

		/* ubN̑ */
		switch(type) {
		/* ړ */
		case OP_DOWN:
			ret = moveDown(current);
			break;
		/* Eړ */
		case OP_RIGHT:
			ret = moveRight(current);
			break;
		/* ړ */
		case OP_LEFT:
			ret = moveLeft(current);
			break;
		/* E] */
		case OP_ROTATE_RIGHT:
			ret = rotate(current, R_RIGHT);
			break;
		/* ] */
		case OP_ROTATE_LEFT:
			ret = rotate(current, R_LEFT);
			break;
		/* Ȃ */
		case OP_NO:
			ret = true; /* Al͋CɂĂȂ */
			break;
		case OP_START:
			ret = true; /* Al͋CɂĂȂ */
			break;
		/* ͎s */
		default:
			ret = false; /* Al͋CɂĂȂ */
			break;
		}

		return ret;
	}

	/**
	 * Ɉړ
	 * @param current
	 * @return
	 */
	public boolean moveDown(Mino current) {
		int x = current.getX();
		int y = current.getY();
		Block[] orgBlocks = current.getBlocks();
		Block[] newBlocks;

		/* ̈ʒuU */
		tableInstance.putEmptyBlocks(0, orgBlocks.length - 1, orgBlocks);

		/* ɒu邩 */
		if (!isSetMino(current, x, y+1)) {
			Debug.println("ɐݒu");

			/* ̈ʒuɐݒ*/
			tableInstance.putBlocks(0, orgBlocks.length - 1, orgBlocks);
			return false;
		}


		/* PɈړ */
		current.setCenter(x, y+1);

		/* 1ɒu */
		newBlocks = current.getBlocks();
		tableInstance.putBlocks(0, newBlocks.length - 1, newBlocks);

		return true;
	}

	/**
	 * EɈړ
	 * @param current
	 * @return
	 */
	private boolean moveRight(Mino current) {
		int x = current.getX();
		int y = current.getY();
		Block[] orgBlocks = current.getBlocks();
		Block[] newBlocks;

		/* ̈ʒuU */
		tableInstance.putEmptyBlocks(0, orgBlocks.length - 1, orgBlocks);

		/* Eɒu邩 */
		if (!isSetMino(current, x+1, y)) {
			/* ̈ʒuɐݒ*/
			tableInstance.putBlocks(0, orgBlocks.length - 1, orgBlocks);
			return false;
		}

		/* PEɈړ */
		current.setCenter(x+1, y);

		/* 1Eɒu */
		newBlocks = current.getBlocks();
		tableInstance.putBlocks(0, newBlocks.length - 1, newBlocks);

		return true;
	}

	/**
	 * Ɉړ
	 * @param current
	 * @return
	 */
	private boolean moveLeft(Mino current) {
		int x = current.getX();
		int y = current.getY();
		Block[] orgBlocks = current.getBlocks();
		Block[] newBlocks;

		/* ̈ʒuU */
		tableInstance.putEmptyBlocks(0, orgBlocks.length - 1, orgBlocks);

		/* ɒu邩 */
		if (!isSetMino(current, x-1, y)) {
			/* ̈ʒuɐݒ*/
			tableInstance.putBlocks(0, orgBlocks.length - 1, orgBlocks);
			return false;
		}

		/* PɈړ */
		current.setCenter(x-1, y);

		/* 1ɒu */
		newBlocks = current.getBlocks();
		tableInstance.putBlocks(0, newBlocks.length - 1, newBlocks);

		return true;
	}
	
	/**********************************************************************/
	/* ]																  */
	/**********************************************************************/
	/**
	 * ]~mݒuł邩B
	 * ]łꍇASRSɏ]]łʒu̒SʒuretCenterɊi[B
	 * @param tmpMino
	 * @param dr
	 * @param retCenter Sʒůi[̈
	 * @return
	 */
	boolean isSetRotateMino(Mino tmpMino, int dr, Point retCenter) {
		/* TODO:AMINO_PARAM_TABLEɈˑ */
		/*1.Mino\bhɂׂ(̃~mn\bhɂĂl */
		/*2.]Ԃ̎擾VvɂłȂ(getState()͒`ׂ) */
		
		/* MinoNXKvȗŔA~m4_̈ʒuƁAޕKvȂ߁B */
		/* S̈ړ͍sȂ߁AMinoNXɂKv͂ȂB */

		boolean ret = false;

		/* p[^擾 */
		int type = tmpMino.getType();
		int dir = dr;

		/* statě(TableƂĈ₷`ł΂Ȃł悢) */
		MINO_PARAM_TABLE.ROTATE_MINO_TYPE rotateMinoType = tmpMino.getRotateMinoType();
		final int state =
			(rotateMinoType.compareRotateState(MINO_PARAM_TABLE.ROTATE_MINO_TYPE.ROTATE_STATE.r0)) ? 0 :
			(rotateMinoType.compareRotateState(MINO_PARAM_TABLE.ROTATE_MINO_TYPE.ROTATE_STATE.r90)) ? 1 :
			(rotateMinoType.compareRotateState(MINO_PARAM_TABLE.ROTATE_MINO_TYPE.ROTATE_STATE.r180)) ? 2 :
			(rotateMinoType.compareRotateState(MINO_PARAM_TABLE.ROTATE_MINO_TYPE.ROTATE_STATE.r270)) ? 3 : -1;

		int turn = /* ̉] */
			(Mino.R_RIGHT == dr)	
			? (state - 1 + 4) % 4
			: (state + 1) % 4;

		/* `FbN */
		if (-1 == state) {
			return false;
		}
		if (null == retCenter) {
			/* p@̌ */
			return false;
		}

		/* ]@5܂œKp */
		for (int i = 1; i <= 5; i++) {
			Point p = RotateRule.moveDirection(i, type, turn, dir);
			Debug.print("(" + p.x + "," + p.y + ")");

			/* zu钆S̈ʒu */
			Point center = new Point(tmpMino.getX() + p.x,
									 tmpMino.getY() + p.y);

			/* zOANZX`FbN */
			if (tableInstance.isOutOfRange(center)) {
				Debug.print("̈O");
				ret = false;
				break;
			}

			/* ~mzuł */
			ret = isSetMino(tmpMino, center.x, center.y); 
			if (ret) {

				/* ]łʒu̒SʒuretCenterɊi[ */
				retCenter.x = center.x;
				retCenter.y = center.y;
				break;
			}
		}
		Debug.println("");

		return ret;
	}

	/**
	 * ]~me[uɐݒu
	 * @param current
	 * @param dr
	 * @return
	 */
	private boolean rotate(Mino current, int dr) {
		boolean ret;
		Point retCenter = new Point();
		Block[] orgBlocks;
		Block[] newBlocks;

		/* `FbN */
		if (Mino.R_RIGHT != dr && Mino.R_LEFT != dr) {
			return false;
		}

		final Mino origin = new Mino(current.getRotateMinoType(),current.getX(), current.getY());
			/* final͐񂳂ƂCłĂ(current̐ݒp\bh͌Ăяo) */
		orgBlocks = origin.getBlocks();
		
		/* ̈ʒuU */
		tableInstance.putEmptyBlocks(0, orgBlocks.length - 1, orgBlocks);

		/* 쒆~m] */
		ret = current.rotateMinoType(dr);
		if (!ret) {
			/* ~m̉]Ɏs߁Acurrent͕ωĂȂ */

			/* ̈ʒuɐݒ*/
			tableInstance.putBlocks(0, orgBlocks.length - 1, orgBlocks);
			return false;
		}

		/* ]~mu邩(SRSɏ]ĉ]łS̈ʒu擾) */
		ret = isSetRotateMino(current, dr, retCenter);
		if (!ret) {
			/**
			 * current͈̖߂lƂČĂяoɕԂ邽߁A
			 * currentɑ΂鑀
			 **/
			ret = current.rotateMinoType((Mino.R_RIGHT== dr ? Mino.R_LEFT : Mino.R_RIGHT));
			if (!ret) {
				Debug.println("]ɖ߂̂Ɏs!?");
			}

			/* ̈ʒuɐݒ*/
			tableInstance.putBlocks(0, orgBlocks.length - 1, orgBlocks);
			return false;
		}

		/* Sʒuݒ */
		current.setCenter(retCenter.x, retCenter.y);

		/* ~me[uɐݒ */
		newBlocks = current.getBlocks();
		tableInstance.putBlocks(0, newBlocks.length - 1, newBlocks);

		return true;
	}

	/**********************************************************************/
	/* AI																  */
	/**********************************************************************/
	/* 1̃e[uɑ2̃~mݒuBݒu邱Ƃ\ȂׂẴ~mɂĕԂB*/
	public Mino[] getPuttableMino(Mino current) {
		ArrayList<Mino> puttableMino = new ArrayList<Mino>(); /* ݒu\ȃ~m */
		Block[] currentBlocks = current.getBlocks();

		/* ނ擾 */
		int topY = current.getY(); /* ԏB͏ */


		/* ݂̑͏ */
//		tableInstance.delMino(current);
		tableInstance.putEmptyBlocks(0, currentBlocks.length - 1, currentBlocks);

		for (int y = HEIGHT + OFFSET - 1; y >= topY; y--) {

			Mino tmp = current.clone();

			/* TODO:tmp.rotateMinoType()̖߂ĺH */
			for (int i = 0; i < 4; i++, tmp.rotateMinoType(Mino.R_LEFT)) { 
				for (int x = L; x <= R; x++) {
					/* ݒł邩 */
					if (!isSetMino(tmp, x, y)) {
						continue;
					}
					/* ݒuĂ邩 */
					if (isSetMino(tmp, x, y + 1)) {
						continue;
					}
					/* Ώۈʒu܂ňړ\ */
					/* TODO:͕̔ʂ̏ōs */
					
					/* ݒu\~mǉ */
					Mino addMino = tmp.clone();
					addMino.setCenter(x, y);
					puttableMino.add(addMino);
				}
			}
		}

		/* ݂F߂悤 */
//		tableInstance.setMino(current);
		tableInstance.putBlocks(0, currentBlocks.length - 1, currentBlocks);

		return  puttableMino.toArray(new Mino[puttableMino.size()]);
	}

	/* ]l߂ */
	/* TODO:ړs\ȏꍇA߂l𕉂ɂ */
	public int getEvalValue(Mino mino) {
		int point = 0;
		Block[] blocks = mino.getBlocks();

		/* ŉ_ɂقǕ]グ */
		/* ŉ_yW擾 */
		int bottomY = 0;
		for (int i = 0; i < blocks.length; i++) {
			int y = blocks[i].getY();
			if (bottomY < y) {
				bottomY = y;
			}
		}
		/* ŉ_yWɂقǁA]l */
		point += bottomY; /*  */
		
		
		
		for (int i = 0; i < blocks.length; i++) {
			int x = blocks[i].getX();
			int y = blocks[i].getY();
			

			/* nʂɐݒuĂȂꍇ */
			if (Mino._ == tableInstance.getBlockType(x, y + 1)){
				point -= 1;
			} else {
				point += 5;
			}
			
			/* Eݒu */
			if (Mino._ != tableInstance.getBlockType(x + 1, y)) {
				point += 1;
			}
			/* ݒu */
			if (Mino._ != tableInstance.getBlockType(x - 1, y)) {
				point += 1;
			}

			
//			for (int up = y; up-- > 0; up--) {
//			
//				if (Mino.$ != table[up][x]) {
//					point -= 5;
//					continue;
//				}
//			}
		}
		
		
		return point;
	}

	/**
	 * ]~mݒuł邩B
	 * ]łꍇASRSɏ]]łʒu̒SʒuretCenterɊi[B
	 * @param tmpMino
	 * @param dr
	 * @param retX Sʒůi[̈(X)
	 * @param retY Sʒůi[̈(Y)
	 * @return
	 */
	public boolean isSetRotateMino(Mino tmpMino, int dr, Integer retX, Integer retY) {
		boolean ret;
		Point retCenter = new Point();

		if (null == retX || null == retY) {
			return false;
		}

		ret = isSetRotateMino(tmpMino, dr, retCenter);

		/* TODO:ȉŖ߂ݒł邩͖mF */
		retX = retCenter.x;
		retY = retCenter.y;

		return ret;
	}

}
