package com.haru.tetoru.parts;


public class RotateRule {

	private static final int CANDIDATE_NUM = 5;
	private static final int STATE_NUM = 4;

	private enum Dir {
		_(0, 0),
		L(-1, 0),
		R(1, 0),
		U(0, -1),
		D(0, 1),
		LU(-1, -1),
		RU(1, -1),
		LD(-1, 1),
		RD(1, 1),
		D2(0, 2),
		U2(0, -2),
		RD2(1, 2),
		LD2(-1, 2),
		RU2(1, -2),
		LU2(-1, -2),
		L2(-2, 0),
		R2(2, 0),
		L2D(-2, 1),
		R2U(2, -1),
		R2D(2, 1),
		L2U(-2, -1);

		private int x;
		private int y;

		private Dir(int x, int y) {
			this.x = x;
			this.y = y;
		}

		public Point get() {
			return new Point(x, y);
		}
	};
	

	//	
	//	E]	 {]	 1	 11	 2	 12
	//	]	 {]	 E1	 E11	 2	 E12
	//	E90x]
	//	E]	 {]	 E1	 E11	 2	 E12
	//	]	 {]	 E1	 E11	 2	 E12
	//	180x]
	//	E]	 {]	 E1	 E11	 2	 E12
	//	]	 {]	 1	 11	 2	 12
	//	90x]
	//	E]	 {]	 1	 11	 2	 12
	//	]	 {]	 1	 11	 2	 12
	private static Dir[][][] tblOther = { /* new Dir[NUM][STATE_NUM][DEMENSION] */
		/* 1 */
		{
			{Dir._, Dir._}, /*  {E], ]} */
			{Dir._, Dir._}, /* E90x] */
			{Dir._, Dir._}, /* 180x] */
			{Dir._, Dir._}  /* 90x] */
		},
		/* 2 */
		{
			{Dir.L, Dir.R}, /*  {E], ]} */
			{Dir.R, Dir.R}, /* E90x] */
			{Dir.R, Dir.L}, /* 180x] */
			{Dir.L, Dir.L}  /* 90x] */
		},
		/* 3 */
		{
			{Dir.LU, Dir.RU}, /*  {E], ]} */
			{Dir.RD, Dir.RD}, /* E90x] */
			{Dir.RU, Dir.LU}, /* 180x] */
			{Dir.LD, Dir.LD}  /* 90x] */
		},
		/* 4 */
		{
			{Dir.D2, Dir.D2}, /*  {E], ]} */
			{Dir.U2, Dir.U2}, /* E90x] */
			{Dir.D2, Dir.D2}, /* 180x] */
			{Dir.U2, Dir.U2}  /* 90x] */
		},
		/* 5 */
		{
			{Dir.LD2, Dir.RD2}, /*  {E], ]} */
			{Dir.RU2, Dir.RU2}, /* E90x] */
			{Dir.RD2, Dir.LD2}, /* 180x] */
			{Dir.LU2, Dir.LU2}  /* 90x] */
		},
	};

	/* T~m̏ꍇA3̏Ԃ180x]Ԃ̓pX */
	private static Dir[][][] tblT = {
		/* 1 */
		{
			{Dir._, Dir._}, /*  {E], ]} */
			{Dir._, Dir._}, /* E90x] */
			{Dir._, Dir._}, /* 180x] */
			{Dir._, Dir._}  /* 90x] */
		},
		/* 2 */
		{
			{Dir.L, Dir.R}, /*  {E], ]} */
			{Dir.R, Dir.R}, /* E90x] */
			{Dir.R, Dir.L}, /* 180x] */
			{Dir.L, Dir.L}  /* 90x] */
		},
		/* 3 */
		{
			{Dir._, Dir._},   /*  {E], ]} */
			{Dir.RD, Dir.RD}, /* E90x] */
			{Dir._, Dir._},   /* 180x] */
			{Dir.LD, Dir.LD}  /* 90x] */
		},
		/* 4 */
		{
			{Dir.D2, Dir.D2}, /*  {E], ]} */
			{Dir.U2, Dir.U2}, /* E90x] */
			{Dir.D2, Dir.D2}, /* 180x] */
			{Dir.U2, Dir.U2}  /* 90x] */
		},
		/* 5 */
		{
			{Dir.LD2, Dir.RD2}, /*  {E], ]} */
			{Dir.RU2, Dir.RU2}, /* E90x] */
			{Dir.RD2, Dir.LD2}, /* 180x] */
			{Dir.LU2, Dir.LU2}  /* 90x] */
		},
	};

	/* I~m͓ */
	//	
	//	E]	 {]	 2	 E1	 21	 E12
	//	]	 {]	 1	 E2	 12	 E21
	//	E90x]
	//	E]	 {]	 1	 E2	 12	 E21
	//	]	 {]	 E2	 1	 E21	 12
	//	180x]
	//	E]	 {]	 E1	 2	 E12	 21
	//	]	 {]	 E2	 1	 E21	 12
	//	90x]
	//	E]	 {]	 E1	 2	 E12	 21
	//	]	 {]	 2	 E1	 21	 E12
	private static Dir[][][] tblI = {
		/* 1 */
		{
			{Dir._, Dir._}, /*  {E], ]} */
			{Dir._, Dir._}, /* E90x] */
			{Dir._, Dir._}, /* 180x] */
			{Dir._, Dir._}  /* 90x] */
		},
		/* 2 */
		{
			{Dir.L2, Dir.L}, /*  {E], ]} */
			{Dir.L, Dir.R2}, /* E90x] */
			{Dir.R, Dir.R2}, /* 180x] */
			{Dir.R, Dir.L2}  /* 90x] */
		},
		/* 3 */
		{
			{Dir.R, Dir.R2}, /*  {E], ]} */
			{Dir.R2, Dir.L}, /* E90x] */
			{Dir.L2, Dir.L}, /* 180x] */
			{Dir.L2, Dir.R}  /* 90x] */
		},
		/* 4 */
		{
			{Dir.L2D, Dir.LU2}, /*  {E], ]} */
			{Dir.LU2, Dir.R2U}, /* E90x] */
			{Dir.RD2, Dir.R2U}, /* 180x] */
			{Dir.RD2, Dir.L2D}  /* 90x] */
		},
		/* 5 */
		{
			{Dir.RU2, Dir.R2D}, /*  {E], ]} */
			{Dir.R2D, Dir.LD2}, /* E90x] */
			{Dir.L2U, Dir.LD2}, /* 180x] */
			{Dir.L2U, Dir.RU2}  /* 90x] */
		},
	};


	/**
	 * ]@ɏ]āAS̈ړ擾B
	 * ڂSRS(X[p[[e[VVXe)ŌB
	 * @param i (range from 1 to 5)
	 * @param type ~m
	 * @param turn ]Ỏ]
	 * @param dr ]̕
	 * @return
	 */
	public static Point moveDirection(int candidate, int type, int turn, int dr) {
		/* `FbN */
		if (1 > candidate || CANDIDATE_NUM < candidate) {
			return new Point(-1, -1);
		}

		/* turn̕␳(`FbNȂ) */
		turn = turn % STATE_NUM;

		/* ]̕Yɕϊ */
		int idxDr = (Mino.R_RIGHT == dr) ? 0 : 1;


		/* ړe[u擾 */
		Dir[][][] tbl = 
				(Block.I == type) ? tblI :
				(Block.T == type) ? tblT 
								  : tblOther; 

		return tbl[candidate - 1][turn][idxDr].get();
	}
}
