package errorReachableAnalyzer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

import model.ModelInterface;
import model.State;
import model.Transition;
import multiConcurrentModel.MultiConcurrentModel;
import multiConcurrentModel.MultiConcurrentState;
import multiConcurrentModel.MultiConcurrentTransition;

public class MultiRequirementParser {
	private MultiConcurrentModel mcm;
	private List<Integer> checker;
	private Queue<MultiConcurrentTransition> deadStack;

	public MultiRequirementParser(MultiConcurrentModel mcm,
			List<Integer> checker) {
		this.mcm = mcm;
		this.checker = checker;
		deadStack = new LinkedBlockingQueue<MultiConcurrentTransition>();
	}

	public MultiRequirementParser() {
		// eXgpɍRXgN^
	}

	public List<List<Integer>> checkSimulate(ModelInterface controller) {
		pasteDead();
		pasteController(controller);
		return checkCanSimulateM(this.mcm);
	}

	public List<List<Integer>> checkUpdatedSimulate(ModelInterface controller) {
		pasteUpdatedDead();
		this.pasteController(controller);
		return checkCanSimulateM((MultiConcurrentModel) mcm);
	}

	List<List<Integer>> checkCanSimulateM(MultiConcurrentModel rs) {
		List<List<Integer>> result = new ArrayList<List<Integer>>();
		boolean isDead = false;
		for (int i = 0; i < rs.getSize(); i++) {
			MultiConcurrentState s = rs.getState(i);
			// if(s.isDead())System.out.println("checkUpdatedSimulate"+s);
			//if(s.isController())System.out.println("checkCanSimulate"+s+":"+s.isController()+","+s.isDead());
			if (s.isController() && s.isDead()) {
				isDead = true;
				result = integratingResult(result, s.getDeadList());
			}
		}
		/*
		 * for(int i=0;i<result.size();i++)//debug
		 * System.out.println("Degradation candidate:"+result.get(i).get(0));//
		 */// debug

		for (int i = 0; i < rs.getErrorSize(); i++) {
			if (rs.getErrorState(i).isController()) {
				isDead = true;
				System.out.println("controller cannot be generated: "
						+ rs.getErrorState(i));
				System.out.println("  " + rs.getErrorState(i));
				// break;
			}
		}
		if (!isDead) {
			System.out.println("controller can be generated");
		} else {
			System.out.println("controller cannot be generated:");
		}
		return result;
	}

	// TODO someday we have to try to solve dead end problem
	public List<List<Integer>> integratingResult(List<List<Integer>> oldResult,
			List<List<Integer>> current) {
		List<List<Integer>> newResult = new ArrayList<List<Integer>>();
		if (oldResult == null || oldResult.size() == 0)
			return current;
		for (int j = 0; j < current.size(); j++) {
			boolean isTarget = true;
			/*
			 * for(int k=0;k<checker.size();k++){
			 * if((current.get(j).get(k)|checker.get(k))!=checker.get(k)){
			 * isTarget=false;break; } }//͍͑ʖځBDeadEndIɉ
			 */
			if (isTarget)
				for (int i = 0; i < oldResult.size(); i++) {
					List<Integer> newR = new ArrayList<Integer>();
					for (int k = 0; k < current.get(j).size(); k++) {
						newR.add((int) oldResult.get(i).get(k)
								| current.get(j).get(k));
					}
					newResult.add(newR);
				}
		}

		return minimizeList(newResult);
	}

	public void pasteDead() {
		deadStack = mcm.getErrorTransition();
		pasteMultiDeadWithStack();
	}

	public void pasteMultiDeadWithStack() {
		while (!deadStack.isEmpty()) {
			MultiConcurrentTransition tmp = deadStack.remove();
			MultiConcurrentState s = (MultiConcurrentState) tmp.getFrom();
			/*
			 * System.out.println("pasteMultiDeadWithStack");
			 * System.out.println("target:"+s+"deadList"+s.getDeadList());
			 * //debug for(int i=0;i<s.getToTransitionNum();i++) //debug
			 * System.out
			 * .println("  "+s.getToTransition(i)+((MultiConcurrentState
			 * )s.getToTransition(i).getTo()).getDeadList()); //debug
			 */
			if (stateDeadCheckForAllReq(s)) {
				for (int i = 0; i < s.getFromTransitionNum(); i++) {
					MultiConcurrentTransition t = (MultiConcurrentTransition) s
							.getFromTransition(i);
					if (!deadStack.contains(t))
						deadStack.add(t);
				}
			}
			// System.out.println(deadStack.size());
		}
	}

	boolean stateDeadCheckForAllReq(MultiConcurrentState m) {

		/*
		 * m[hLosing regionɑ邩ۂ𔻒肵Aꍇ͂Losing region肷B 肵Losing
		 * region͈m[hɕێB mȉ̂ǂ炩̏𖞂ꍇALosing regionɑB ܂ALosing
		 * region̓@͖ɉĈقȂ̂łLB
		 * Aȉ"AND""OR"͉L"Losing region"̊Ǘ@̋Lڂɉ̂Ƃ 1iȉANDj:
		 * Jڐ̃m[hLosing regionɑ悤UncontrollableȑJڂPȏ㑶݂ꍇ @F
		 * moĂUncontrollableȑJڂ̐̃m[hLosing regionSĒo
		 * ANDɂČqmLosing regionƂȂ 2iȉORjF
		 * AND𖞂ASĂ̑JڂɂāAJڐ̃m[hLosing regionɑ悤ȏꍇ @F
		 * moĂSđJڂ̐̃m[hLosing region𒊏o ORɂČqmLosing
		 * regionƂȂ
		 *
		 * L̏1,2ɍvȂ̂͂Losing regionɂ܂܂ȂB ̏ꍇAʂmɕێB
		 */

		/*
		 * Losing region̊Ǘ@ a.Losing regionANDORp_ɂĕ\\łB
		 * a-0._\_vfp1̗͂vfɑΉ邠safety propertyۏ؏oȂȂƂ\B
		 * a-1.ANDi&&j͂2safety property p1p2ɕۏ؏oȂȂ悤Losing
		 * region\̂ɗp "p1 && p2" ƕ\ȂALosing
		 * regionp1p2̂ǂۏؕs\ł a-2.OR(||)͂2safety property
		 * p1p2̂ǂ炩ۏ؏oȂ悤Losing region\̂ɗp
		 * "p1 || p2"ƕ\ȂALosing region͈̕ۏ؂߂ȂΑ̕ۏ؂oȂԂłB
		 * b.ʓIȘ_̕ό`\Ȃ߁AGLosing region̎
		 * ̗̂悤AND݂̂ō\ORŌq`ɕό` 1: (p1 || p2)&&(p3 || p4)=(p1 &&
		 * p3)||(p1 && p4)||(p2 && p3)||(p2 && p4) 2: p1 &&(p2 || p3)=(p1 &&
		 * p2)||(p1 || p3) 3:@(p1 || p2) && p3 &&(p3 || p2) = (p1 && p3 &&
		 * p3)||(p1 && p2 && p3)||(p2 && p3 && p3)||(p2 && p2&& p3) =(p1 &&
		 * p3)||(p2 && p3) vZʂ팸邽߁AKvɉė3̂悤Ɏ̊ȒP}
		 * c.La.b.ɓĂint^zvfɎXgŕ\ c-0.ǂsafety
		 * propertyۏ؏oȂȂ̂bitɂĕ\B
		 * "int"ƂĂ邪AԂbitłBbitɑ΂čsBint^ł鎖̂ɈӖ͂ȂB
		 * zɂ̂int^32bitł邽߁A33ȏsafety property߂̑[ułB
		 * c-1.int^zAND݂̂ō\\ĂB Ⴆp1-p6܂ł6safety
		 * propertyVXeɂ p1p3ۏ؏oȂ(Ȃ킿Ap1 && p3ł)悤Losing
		 * region"000101"ƕ\B iint^ƂĈĂ̂ŐlƂĂ"5"ƕ\j
		 * c-2.int^z̗vfXgƂĊi[鎖ł̗vfԂORŌqĂ邱ƂӖĂB
		 * Ⴆp1-p6܂ł6safety propertyVXeɂ (p1 && p3)||(p2 && p5 &&
		 * p6)ƂLosing region "000101""110010"Ƃ2̗vfXgɂĕ\B
		 * ̂悤ɂ邱ƂŁALosing regionǂ̂悤safety propertyɋNč\zĂ邩 iLosing
		 * regionł͂ǂ̑gݍ킹safety property̕ۏ؂߂Ηǂ̂j
		 * eՂɂ킩B̏ꍇp1,p32߂邩Ap2,p5,p63߂邩̓ƂȂB
		 */

		// ANDꍇɁALosing region̓ɗpLosing regionێ邽߂̃Xg
		List<List<List<Integer>>> andDeadLists = new ArrayList<List<List<Integer>>>();

		// ORꍇɁALosing region̓ɗpLosing regionێ邽߂̃Xg
		List<List<Integer>> orDeadExp = new ArrayList<List<Integer>>();

		// m[hAND𖞂AOR𖞂𔻒f邽߂boolϐ
		boolean andDead = false, orDead = true;
		// m[hJڂ擪珈邽߂̑O
		m.reset();

		// m[hJڂɃ`FbNAANDA܂OR𖞂`FbN
		while (m.hasNext()) {
			// `FbNJڂmctƂB
			MultiConcurrentTransition mct = (MultiConcurrentTransition) m
					.next();

			// mAND𖞂mctpĔf
			// ifxłtrueɂȂmAND𖞂Ƃm肷B
			if ((((MultiConcurrentState) mct.getTo()).isDead() || mct.isDead())
					&& !mct.isControllable()) {
				/*
				 * ȉAmLosing region肷邽߂Losing regionۑ邽߂̍
				 * fł̓m[hƂ͓ƗđJڂLosing regionɑꍇ݂mct̑Jڐ悪Losing
				 * regionɑĂ邩mct̂Losing regionɑĂ邩
				 * 邢͂̂ǂɂāAɏ𕪂Ă邪A܂ŉłB܂Aɑ̑Jڐœ肵Losing
				 * regionƏdȂ肪悤Losing region͂̎_ŏȂiLosing region̊Ǘ@
				 * b.ŐGꂽÅȒPsĂj
				 */
				List<List<Integer>> l = ((MultiConcurrentState) mct.getTo())
						.getDeadList();
				if (l != null && !l.isEmpty()) {
					if (mct.getDead() != null) {
						List<List<Integer>> ll = new ArrayList<List<Integer>>();
						for (int i = 0; i < l.size(); i++) {
							List<Integer> tmp = new ArrayList<Integer>();
							for (int j = 0; j < l.get(i).size(); j++)
								tmp.add((int) l.get(i).get(j)
										| mct.getDead().get(j));
							boolean contains = true;
							for (int j = 0; j < ll.size(); j++) {
								if (!checkContains(ll.get(j), tmp))
									contains = false;
							}
							if (!contains || ll.isEmpty())
								ll.add(tmp);
						}
						andDeadLists.add(ll);

					} else {
						List<List<Integer>> ll = new ArrayList<List<Integer>>();
						for (int i = 0; i < l.size(); i++) {
							List<Integer> tmp = new ArrayList<Integer>();
							for (int j = 0; j < l.get(i).size(); j++) {
								tmp.add((int) l.get(i).get(j));
							}
							ll.add(tmp);
						}
						andDeadLists.add(ll);
					}
				} else {
					List<List<Integer>> in = new ArrayList<List<Integer>>();
					List<Integer> tmp = new ArrayList<Integer>();
					for (int i = 0; i < mct.getDead().size(); i++)
						tmp.add((int) mct.getDead().get(i));
					in.add(tmp);
					andDeadLists.add(in);
				}
				andDead = true;
				orDead = false;
				// mOR𖞂mctpĔf
				// {whilȇSẴ[vɂĂiftrueƂȂꍇ̂݁AORB
				// tɌ΁AxłȂOR邱Ƃ͂Ȃ
			} else if (orDead
					&& (((MultiConcurrentState) mct.getTo()).isDead() || mct
							.isDead()) && mct.isControllable()) {
				/*
				 * ȉAmLosing region肷邽߂Losing regionۑ邽߂̍
				 * AND̏ꍇƐ͓łB
				 */
				List<List<Integer>> l = ((MultiConcurrentState) mct.getTo())
						.getDeadList();
				List<List<Integer>> newl = new ArrayList<List<Integer>>();
				if (mct.getDead() != null) {
					if (l == null || l.isEmpty()) {
						List<Integer> tmp = new ArrayList<Integer>();
						for (int j = 0; j < mct.getDead().size(); j++) {
							tmp.add((int) mct.getDead().get(j));
						}
						newl.add(tmp);
					} else
						for (int i = 0; i < l.size(); i++) {
							List<Integer> tmp = new ArrayList<Integer>();
							// System.out.println(l.get(i)); //debug
							for (int j = 0; j < mct.getDead().size(); j++) {
								tmp.add((int) mct.getDead().get(j)
										| l.get(i).get(j));
							}
							newl.add(tmp);
						}
				} else {
					for (int i = 0; i < l.size(); i++) {
						List<Integer> tmp = new ArrayList<Integer>();
						for (int j = 0; j < l.get(i).size(); j++) {
							tmp.add((int) l.get(i).get(j));
						}
						newl.add(tmp);
					}
				}
				orDeadExp.addAll(newl);
				orDeadExp = minimizeList(orDeadExp);
				// mANDORȂmctpĔf
				// elsexłʂOR𖞂͂Ȃ
				// AND𔻒f镪xłʂĂ܂ꍇAANDꂽ̂ƂȂ
			} else {
				orDead = false;
			}
		}
		m.reset();

		// ȉAORꂽꍇAANDꂽꍇȀȂꍇ
		// Losing region̍XVsB
		/*
		 * OȐꍇ́AŏW߂Losing regionORŌqA
		 * Ȃ킿AXg̗vfɓ邾Ȃ̂ŁÂ܂ܓւ`ƂȂB
		 */
		if (orDead) {
			// System.out.println("stateDeadCheckForAllReq:orDead");
			return m.replaceDeadList(orDeadExp);
		}
		/*
		 * AND̏ꍇ́AŏW߂Losing regionANDŌqAPANDŌqꍇAǗ@̕jƈقȂĂ܂̂
		 * ό`ɑ鏈ōsAORŌqꂽ`ŕ\ȂB
		 */
		else if (andDead) {
			List<List<Integer>> newl = new ArrayList<List<Integer>>();
			for (int i = 0; i < andDeadLists.size(); i++) {
				newl = composeList(newl, andDeadLists.get(i));
			}
			// System.out.println("stateDeadCheckForAllReq:andDead");
			return m.replaceDeadList(newl);
		}
		/*
		 * ORANDȂꍇLosing regionB
		 */
		else {
			// System.out.println("stateDeadCheckForAllReq:else");
			return m.replaceDeadList(new ArrayList<List<Integer>>());
		}
	}

	List<List<Integer>> composeList(List<List<Integer>> a, List<List<Integer>> b) {
		if (a == null || a.isEmpty()) {
			b = minimizeList(b);

			return b;
		} else if (b == null || b.isEmpty()) {
			a = minimizeList(a);
			return a;
		}
		List<List<Integer>> ab = new ArrayList<List<Integer>>();
		for (int i = 0; i < a.size(); i++)
			for (int j = 0; j < b.size(); j++) {
				List<Integer> tmpa = new ArrayList<Integer>();
				for (int k = 0; k < a.get(i).size(); k++) {
					tmpa.add((int) a.get(i).get(k) | b.get(j).get(k));
				}
				ab.add(tmpa);
			}
		ab = minimizeList(ab);

		return ab;
	}

	void pasteController(ModelInterface controller) {
		for (int i = 0; i < controller.getSize(); i++)
			controller.getState(i).reset();
		pasteCToStateWithHash(controller.getInitialState(),
				mcm.getInitialState());
	}

	// nbV}bvpRg[̃V~[V
	// Rg[̃f̑SԂƑSJڂɑΉ񍇐f̏ԂƑJڂ肵AɃ}[NĂ\bh
	// Rg[̏ԑJڂɂĕ񍇐fERRORɓBꍇ͂̎_Ōxēł؂
	void pasteCToStateWithHash(State c, State m) {
		HashMap<State, ContSet> map = new HashMap<State, ContSet>();
		c.setIsController();
		m.setIsController();
		map.put(c, new ContSet(c, m));
		int i=0;
		while (!map.isEmpty()) {
			ContSet current=map.remove(map.keySet().toArray()[0]);
			while (current.getController().hasNext()) {
				Transition t = (Transition) current.getController().next();
				//System.out.println("pasteCToStateWithHash"+t);//debug
				if (current.getModel().getToTransition(t.toString()) != null/*&&!current.getController().getToTransition(t.toString()).getTo().isController()*/) {i++;
					ContSet next= new ContSet(t.getTo(), current.getModel()
							.getToStateByTransition(t.toString()));
					next.getController().setIsController();
					next.getModel().setIsController();
					if(next.getController().hasNext()&&!map.containsValue(next.getController()))
							map.put(next.getController(), next);
				}
			}
			//System.out.println("pasteCToStateWithHash"+current.getModel() + "," + current.getController());
		}
		//System.out.println("pasteCToStateWithHashMap:"+i);
	}

	// Rg[̃V~[V`FbN̂߂̏ێ邽߂̃NX
	class ContSet {
		State controller, model;

		ContSet(State c, State m) {
			this.controller = c;
			this.model = m;
		}

		State getController() {
			return this.controller;
		}

		State getModel() {
			return this.model;
		}
	}

	/* ŎgĂupdated part̒gs\B{MultiSystemModelMakercomposeďoԂKv */
	void pasteUpdatedDead() {
		List<Transition> l = mcm.getUpdatedPart();
		// System.out.println("pasteUpdatedDead");//debug
		if (l.size() == 0) {
			return;
		}
		for (int i = 0; i < l.size(); i++) {

			Transition t = l.get(i);
			// System.out.println(" "+t.getFrom()+":"+((MultiConcurrentState)t.getFrom()).getDeadList()+"->"+t+"->"+t.getTo()+":"+((MultiConcurrentState)t.getTo()).getDeadList());//debug*/

			if (((MultiConcurrentState) l.get(i).getTo()).isDead()
					|| ((MultiConcurrentTransition) l.get(i)).getDead() != null
					|| (!((MultiConcurrentState) l.get(i).getTo()).isDead() && ((MultiConcurrentState) l
							.get(i).getFrom()).isDead())) {
				deadStack.add((MultiConcurrentTransition) l.get(i));
			} else {
				// System.out.println("This updated part is not need to be analyzed");
			}
		}
		pasteMultiDeadWithStack();
	}

	boolean checkContains(List<Integer> container, List<Integer> containee) {
		for (int i = 0; i < container.size(); i++) {
			// System.out.println(container+","+containee); //debug
			if ((container.get(i) | containee.get(i)) != containee.get(i)) {
				return false;
			}
		}
		return true;
	}

	List<List<Integer>> minimizeList(List<List<Integer>> a) {
		List<List<Integer>> ab = new ArrayList<List<Integer>>();
		for (int i = 0; i < a.size(); i++) {
			List<Integer> tmp = new ArrayList<Integer>();
			for (int j = 0; j < a.get(i).size(); j++)
				tmp.add((int) a.get(i).get(j));
			ab.add(tmp);
		}
		for (int i = 0; i < ab.size(); i++) {
			for (int j = i + 1; j < ab.size(); j++)
				if (checkContains(ab.get(i), ab.get(j))) {
					ab.remove(j);
					j--;
				} else if (checkContains(ab.get(j), ab.get(i))) {
					ab.remove(i);
					j = i;
				}
		}
		return ab;

	}
}