package model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Model implements ModelInterface{
	State[] states;
	State initialState,errorState;
	String name;
	HashMap<String,State> map;
	public Model(State[] states,HashMap<String,State> map){
		this.states=states;
		this.map=map;
		this.setInitialState(states[0]);
		this.setErrorState(states[states.length-1]);
	}
	Model(String name,State[] states,HashMap<String,State> map){
		this.name=name;
		this.states=states;
		this.map=map;
		this.setInitialState(states[0]);
		this.setErrorState(states[states.length-1]);
	}
	public State getState(int i){
		return states[i];
	}
	
	public State getState(String i){
		return map.get(i);
	}
	public int getSize(){
		return states.length;
	}
	public State getInitialState(){
		return this.initialState;
	}
	public void setInitialState(State s){
		this.initialState=s;
	}
	public State getErrorState(){
		return this.errorState;
	}
	public void setErrorState(State s){
		this.errorState=s;
	}
	
	public List<Transition> getUpdatedPart(){
		return new ArrayList<Transition>();
	}
	public String getName() {
		return name;
	}
	
}
