package multiGR.model;

public abstract class ModelMaterial {
	private boolean isController;
	protected boolean isDead;
	protected String name;
	
	protected ModelMaterial(String name){
		this.name=name;
		isController=false;
		isDead=false;
	}
	public String toString(){
		return name;
	}

	public boolean isDead(){
		return isDead;
	}
	public boolean isController(){
		return isController;
	}
	public void setIsDead(){
		isDead=true;
	}
	public void setIsController(){
		isController=true;
	}
	public void eraseIsDead(){
		isDead=false;
	}
	public void eraseIsController(){
		isController=false;
	}
	public String getName(){
		return name;
	}
	
	abstract boolean hasNext();
	abstract ModelMaterial next();
	abstract void reset();
}
