package multiConcurrentModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


public class MultiConcurrentState extends State {
	String env;
	List<String> reqMoniList;
	List<int[]> deadList;
	int updateNumber;
	public MultiConcurrentState(String name) {
		super(name);	
		reqMoniList=new ArrayList<String>();
		deadList=new ArrayList<int[]>();
	}

	public MultiConcurrentState(int[] s){
		this("");
		String name="ERROR";
		for(int i=0;i<s.length;i++){
			if(i!=0)name=name+",";
			name=name+s[i];
		}
		this.name=name;
		this.deadList.add(s);
	}
	public MultiConcurrentState(State env,List<State> initReq){
		this(env.toString());
		for(int i=0;i<initReq.size();i++){
			String tmp=initReq.get(i).toString();
			this.reqMoniList.add(tmp);
			this.name=this.name.concat(tmp);
		}
		this.env=env.toString();
	}
	
	public void setIsDead(int[] reqs){
		boolean setDead=true;
		for(int i=0;i<deadList.size();i++){
			boolean tmp=true,remove=true;
			for(int j=0;j<reqs.length;j++){
				if((deadList.get(i)[j]|reqs[j])!=reqs[j]){
					tmp=false;
				}
				if((deadList.get(i)[j]|reqs[j])!=deadList.get(i)[j])
					remove=false;
			}
			if(tmp){
				setDead=false;break;
			}
			if(remove){
				System.out.println("remove");
				deadList.remove(i);
			}
		}
		if(setDead)deadList.add(reqs);
	}
	
	@Override
	public boolean isDead(){
			return !deadList.isEmpty();
	}
	
	public boolean isDead(int[] req){
			return deadList.contains(req);			
	}
	void addReqMoni(String s){
		this.name.concat(s);
		this.reqMoniList.add(s);
	}
	public String getEnv() {
		return env;
	}
	public List<int[]> getDeadList(){
		List<int[]> clone =new ArrayList<int[]>();
		for(int i=0;i<deadList.size();i++){
			clone.add(deadList.get(i));
		}
		return clone;
	}//*/
	public boolean replaceDeadList(List<int[]> d){
		if(getName().contains("ERROR")){
			return false;
		}
		if(deadList.size()==d.size()){
			boolean allSame=true;
			for(int i=0;i<deadList.size();i++)
				for(int j=0;j<deadList.get(i).length;j++)
					if(deadList.get(i)[j]!=d.get(i)[j]){
						allSame=false;
						break;
					}
			if(allSame){
				return false;
			}else{
				this.deadList=d;
				return true;
			}
		}else{
			this.deadList=d;
			return true;
		}

	}
	
	public void clearDeaedList(){
		deadList.clear();
	}
	
	public List<String> getReqMoniList(){
		return reqMoniList;
	}
}
