.nr HY 0
.TH GIT\-QDELETE 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, 2022, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qdelete \- remove patches from a Git\-MQ series
.
.
.SH SYNOPSIS
.BR git\ qdelete \ [ \-k \ |\  \-\-keep ]\ < \fIpatch >\  ...
.br
.BR git\ qremove \ [ \-k \ |\  \-\-keep ]\ < \fIpatch >\  ...
.br
.BR git\ qrm \ [ \-k \ |\  \-\-keep ]\ < \fIpatch >\  ...
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qdelete
command removes patch references from the
.B Git\-MQ
patch series,
.I without
recording their contents in project history;
by default,
the associated patch files are also deleted
from the Git-MQ patch directory.
.
.LP
The
.B git\ qremove
and
.B git\ qrm
forms are simple aliases for
.BR git\ qdelete ;
all three behave identically.
.
.LP
Patches which are to be removed must be individually specified,
by name.
If the
.B \-\-keep
option is specified,
patch series references are deleted,
and no associated project history is recorded,
but the patch files themselves are retained;
such patches may subsequently by identified by the
.B git\ qseries\ \-\-missing
command.
.
.LP
Patches which have been applied cannot be removed by
.BR git\ qdelete ;
to remove applied patches,
and move their content into project history,
use the
.B git\ qfinish
command.
.
.
.SH OPTIONS
.TP 4n 4n
.BR \-k ,\   \-\-keep
Remove the specified patches from the series,
but do not delete the associated patch files.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qdelete
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qdelete
command exhibits fundamentally the same behaviour as its
.B hg\ qdelete
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, 2022, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qapplied (1),
.BR git\-qfinish (1),
.BR git\-qseries (1),
.BR git\-qunapplied (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
