.nr HY 0
.TH GIT\-QHEADER 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qheader \- display log message text from a patch header
.
.
.SH SYNOPSIS
.B git qheader
.RI [< patch >]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qheader
command displays the commit log message text,
as recorded in the header of any
.B Git\-MQ
patch which is specified by the
.RI < patch >
argument;
if no
.RI < patch >
argument is specified,
the displayed log message is retrieved from the
topmost currently-applied patch,
if any.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qheader
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qheader
command exhibits fundamentally the same behaviour as its
.B hg\ qheader
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qseries (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
