.nr HY 0
.TH GIT\-QIMPORT 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qimport \- import patches or existing commits
.
.
.SH SYNOPSIS
.B git qimport
.RB [ \-efP ]
.RB [ \-n
.RI < name >]
.RB [[ \-r \ < \fIcommit >]\  ... ]
.RI [< patch\c
.RB >]\  ... ]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qimport
command may be used to add new patches,
or existing unregistered patches, to the
.B Git\-MQ
patch series;
it may also be used to convert existing committed revisions to
patches,
thus bringing them under
.B Git\-MQ
control.
.
.LP
When importing patches, the
.RI < patch >
argument specifies the name of the patch file
which is to be imported.
If the
.B \-e
(or
.BR \-\-existing )
option is specified,
the patch file should already be present in the active
.B Git\-MQ
patch directory, and
.RI < patch >
should specify a bare file name;
conversely, if the
.B \-e
(or
.BR \-\-existing )
option is not specified,
.RI < patch >
should specify a path name for the patch file.
.
.LP
If
.RI < patch >
is specified as
.RI \(oq \- \(cq,
the patch will be read from standard input;
in this case, the
.BR \-n < \fIname >
(or
.BR \-\-name =< \fIname >)
must be used to assign a name for the imported patch.
.
.LP
Patches must be named to conform with git\(aqs rules for naming tags;
to import a patch with a \%non\(hyconforming file name, the
.BR \-n < \fIname >
(or
.BR \-\-name =< \fIname >)
option must be used to assign a conforming patch name.
.
.LP
If the
.B \-P
(or
.BR \-\-push )
option is specified,
the patch(es) will be pushed (applied) after import.
Without this option,
patches will be copied to the
.B Git\-MQ
patch directory,
if necessary,
and will be registered in the series file,
but they will not be applied.
.
.LP
If the
.BR \-r < \fIcommit >
(or
.BR \-\-rev =< \fIcommit >)
option is specified,
then one or more existing commits will be converted to
.B Git\-MQ
patches.
The
.RI < commit >
option argument is required;
it must specify a (possibly abbreviated) commit ID,
or a range of such commit IDs,
and aggregate of all such specified ranges must represent
one contiguous range,
which must not include,
or span,
any merge commit,
and must end at the parent commit of the first applied
.B Git\-MQ
patch,
or at the
.B HEAD
commit,
if no
.B Git\-MQ
patches have been applied.
.
.LP
When converting existing commits to patches, the
.B \-P
(or
.BR \-\-push )
option is ignored;
such patches are
.I always
marked as
.IR applied .
.
.
.SH OPTIONS
.TP 4n
.BR \-e ,\  \-\-existing
Register patches for which the patch files are already present in the
.B Git\-MQ
patch directory,
but for which no entry yet exists in the series file.
.
.TP
.BR \-f ,\  \-\-force
Overwrite patch files which already exist in the
.B Git\-MQ
patch directory.
.
.TP
.BR \-n \ < \fIname >,\  \-\-name =< \fIname >
Specify the name,
under which the patch is to be registered;
(this may differ from the base name specified in the
.RI < patch >
argument).
This option cannot be used if importing more than one patch,
or if converting more than one commit,
(or if both importing and converting,
in a single invocation of the
.B git\ qimport
command).
.
.TP
.BR \-r \ < \fIcommit >,\  \-\-rev =< \fIcommit >
Specify a single commit ID, or a range of commit IDs,
for conversion to
.B Git\-MQ
patches;
this may be specified using any form of reference
which is acceptable to git,
for identification of a single commit,
or a range of commits.
.
.TP
.BR \-P ,\  \-\-push
Apply each patch,
after it has been imported;
this option is ignored for converted commits,
(which are always registered as
.IR applied ).
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qimport
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qimport
command exhibits fundamentally the same behaviour as its
.B hg\ qimport
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qnew (1),
.BR git\-qpush (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
