.nr HY 0
.TH GIT\-QSELECT 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qselect \- manage the active guard state of a patch queue
.
.
.SH SYNOPSIS
.BR git\ qselect \ [ \-s \ |\  \-\-series ]\ [ \-v \ |\  \-\-verbose ]
.br
.BR git\ qselect \ [ \-n \ |\  \-\-none ]\ [ \-\-pop ]\ [ \-\-reapply ]\ \c
.RB [< \fIguard >\  ... ]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qselect
command is used to manage the active guard state of a patch queue,
and so,
in conjunction with the
.B git\ qguard
command,
control the selection of patches which may be pushed.
.
.LP
Depending on the combination of options and arguments specified,
the
.B git\ qselect
command supports three distinct modes of operation,
namely,
in order of precedence from highest to lowest:\(em
.
.IP 1. 4n
Invoked when the
.BR \-n \ (or\  \-\-none )
option,
or any set of one or more
.RI < guard >
arguments is specified,
the
.BR \-n \ (or\  \-\-none )
option,
if specified,
initially ensures that any currently active guards are deactivated;
the active guard state is then set to
.I exactly
match any particular set of
.RI < guard >
arguments which are specified.
.
.IP \&
Note that,
in this highest precedence mode of operation,
the effect of
.RI < guard >
arguments is
.I not
cumulative;
thus,
specification of the
.BR \-n \ (or\  \-\-none )
option together with any \%non\(hyempty set of
.RI < guard >
arguments,
while permitted,
is effectively redundant.
However,
the
.BR \-n \ (or\  \-\-none )
option
.I is
required,
when the intent is to
.I clear
\%currently\(hyactive guards,
and leave the queue with all guards deactivated;
in this case,
the
.BR \-n \ (or\  \-\-none )
option
.I must
be specified,
with no accompanying set of
.RI < guard >
arguments.
.
.IP 2.
Invoked only when the
.BR \-s \ (or\  \-\-series )
option is specifed,
and neither the
.BR \-n \ (or\  \-\-none )
option,
nor any
.RI < guard >
argument is present,
the command will display an \%alpha\(hynumerically sorted
list of guards which have been defined by the
.B git\ qguard
command,
and recorded within the series file,
regardless of the active guard state of the patch queue.
.
.IP \&
The display format,
in this mode of operation,
may be agumented to include a count of patches to which
each guard is assigned,
(and also a count of patches to which no guards have been assigned,
designated by the reserved \%pseudo\(hyguard name
.RB \(lq NONE \(rq),
by specifying the
.BR \-v \ (or\  \-\-verbose )
option,
in conjunction with
.BR \-s \ (or\  \-\-series ).
.
.IP 3.
Invoked when no
.RI < guard >
arguments are,
and neither the
.BR \-n \ (or\  \-\-none )
option,
nor the
.BR \-s \ (or\  \-\-series )
option is specified,
this lowest precedence mode of operation simply produces
a display of the currently active guards,
if any,
or reports that no guards are active,
otherwise.
.
.LP
Note that it is possible for the
.BR git\ qselect ,
and
.B git\ qguard
commands to modify the guard state of applied patches,
without changing the applied state of the patch series;
invoking
.B git\ qselect
with the
.BR \-\-pop ,
or
.B \-\-reapply
options modifies this behaviour.
.
.
.SH OPTIONS
.TP 4n
.BR \-n ,\  \-\-none
Selects the highest precedence mode of operation,
and causes deactivation of any currently active guards.
.
.TP
.B \-\-pop
In the case where guarded patches,
(in the prevailing guard state after specified changes,
if any,
have been instated),
precede the topmost applied patch,
pop patches from the stack until no such patches remain
within the applied series.
.
.TP
.B \-\-reapply
Note the identity of the topmost applied patch,
and proceed as for the
.B \-\-pop
option;
then,
provided the former topmost patch remains unguarded,
in the currently active guard state,
push patches,
skipping any which
.I are
guarded,
until the formerly identified patch again becomes topmost.
.
.TP
.BR \-s ,\  \-\-series
Ignored if any
.RI < guard >
argument,
or the
.B \-\-none
option is also specified;
otherwise selects the intermediate precedence mode of operation,
to display a list of all guards which have been defined
in the series file.
.
.TP
.BR \-v ,\  \-\-verbose
In the case where the effect of the
.B \-\-series
option is dominant,
include patch counts for each defined guard,
and the tally of unguarded patches,
in the displayed list.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qselect
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qselect
command exhibits fundamentally the same behaviour as its
.B hg\ qselect
counterpart.
.
.
.SH CAVEATS AND BUGS
It may be observed that certain combinations of options,
and
.RI < guard >
arguments make no sense.
Allowing execution to continue,
when any such nonsensical combination is specified,
may be considered a bug.
However, this is not caught;
rather,
execution
.I does
continue,
on the basis of selection of the highest precedence applicable
operating mode,
and inconsistently specified options
are silently ignored.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qguard (1),
.BR git\-qpop (1),
.BR git\-qpush (1),
.BR git\-qseries (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
