.nr HY 0
.TH GIT\-QTOP 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qtop \- identify the most recently applied Git\-MQ patch
.
.
.SH SYNOPSIS
.BR git\ qtop \ [ \-v \ |\  \-\-verbose ]\ [ \-s \ |\  \-\-summary ]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qtop
command displays the identity of the topmost applied patch,
if any, in a
.B Git\-MQ
patch series.
.
.
.SH OPTIONS
.TP 4n
.BR \-s ,\  \-\-summary
Include the summary line from the patch header, if available.
.TP
.BR \-v ,\  \-\-verbose
Include the patch sequence number, and the status flag,
(which should always be
.RB \(oq A \(cq),
as described for the
.B git\ qseries
command.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qtop
reports an exit status code of 0,
when an applied patch is identified,
or of 1 if no patches have been applied.
Any other \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qtop
command exhibits fundamentally the same behaviour as its
.B hg\ qtop
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qnext (1),
.BR git\-qprev (1),
.BR git\-qseries (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
